/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.BrowseFolders;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());
    public static final String URL_REGEXP = "^https?://([^/?#: ]+(:[^/?#: ]+)?@)?[^/?#: ]+(:\\d+)?(/[^?# ]*(\\?[^#]*)?(#\\w*)?)?$";
    private static final Pattern URL_PATTERN = Pattern.compile("^https?://([^/?#: ]+(:[^/?#: ]+)?@)?[^/?#: ]+(:\\d+)?(/[^?# ]*(\\?[^#]*)?(#\\w*)?)?$");
    private static final char[] INVALID_FILENAME_CHARS = new char[]{'/', '\\', '|', ':', '*', '?', '\"', '<', '>'};

    private Utils() {
    }

    public static boolean validatePhpUnitForProject(PhpUnit phpUnit, PhpProject project) {
        String error = PhpUnit.validateVersion(phpUnit);
        if (error == null) {
            error = PhpUnit.validateVersion(phpUnit, project);
        }
        if (error != null) {
            UiUtils.invalidScriptProvided((String)error, (String)"PhpUnit");
            return false;
        }
        return true;
    }

    public static boolean isValidUrl(String url) {
        if (url == null) {
            return false;
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException ex) {
            return false;
        }
        return URL_PATTERN.matcher(url).matches();
    }

    public static File browseFileAction(Component parent, File currentDirectory, String title) {
        return Utils.browseAction(parent, currentDirectory, title, 0);
    }

    public static File browseLocationAction(Component parent, File currentDirectory, String title) {
        return Utils.browseAction(parent, currentDirectory, title, 1);
    }

    private static File browseAction(Component parent, File currentDirectory, String title, int mode) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(mode);
        if (currentDirectory != null && currentDirectory.exists()) {
            chooser.setSelectedFile(currentDirectory);
        }
        if (0 == chooser.showOpenDialog(parent)) {
            return FileUtil.normalizeFile((File)chooser.getSelectedFile());
        }
        return null;
    }

    public static File browseLocalServerAction(Component parent, JComboBox localServerComboBox, MutableComboBoxModel localServerComboBoxModel, File preselected, String newSubfolderName, String title) {
        File newLocation;
        LocalServer ls;
        if (preselected == null && (ls = (LocalServer)localServerComboBox.getSelectedItem()).getDocumentRoot() != null && ls.getDocumentRoot().length() > 0) {
            preselected = new File(ls.getDocumentRoot());
        }
        if ((newLocation = Utils.browseLocationAction(parent, preselected, title)) == null) {
            return null;
        }
        File file = null;
        file = newSubfolderName == null ? newLocation : new File(newLocation, newSubfolderName);
        String projectLocation = file.getAbsolutePath();
        for (int i = 0; i < localServerComboBoxModel.getSize(); ++i) {
            LocalServer element = (LocalServer)localServerComboBoxModel.getElementAt(i);
            if (!projectLocation.equals(element.getSrcRoot())) continue;
            localServerComboBox.setSelectedIndex(i);
            break;
        }
        LocalServer localServer = new LocalServer(newLocation.getAbsolutePath(), projectLocation);
        localServerComboBoxModel.addElement(localServer);
        localServerComboBox.setSelectedItem(localServer);
        return newLocation;
    }

    public static void browsePhpInterpreter(Component parent, JTextField textField) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(Utils.class, (String)"LBL_SelectPhpInterpreter"));
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(LastUsedFolders.getOptionsPhpInterpreter());
        if (0 == chooser.showOpenDialog(parent)) {
            File phpInterpreter = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            LastUsedFolders.setOptionsPhpInterpreter(phpInterpreter);
            textField.setText(phpInterpreter.getAbsolutePath());
        }
    }

    public static void browsePhpUnit(Component parent, JTextField textField) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(Utils.class, (String)"LBL_SelectPhpUnit"));
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(LastUsedFolders.getOptionsPhpUnit());
        if (0 == chooser.showOpenDialog(parent)) {
            File phpUnit = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            LastUsedFolders.setOptionsPhpUnit(phpUnit);
            textField.setText(phpUnit.getAbsolutePath());
        }
    }

    public static void browseTestSources(JTextField textField, PhpProject phpProject) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(Utils.class, (String)"LBL_SelectUnitTestFolder", (Object)ProjectUtils.getInformation((Project)phpProject).getDisplayName()));
        chooser.setFileSelectionMode(1);
        chooser.setCurrentDirectory(FileUtil.toFile((FileObject)phpProject.getProjectDirectory()));
        if (0 == chooser.showOpenDialog(textField.getParent())) {
            File testsDirectory = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            textField.setText(testsDirectory.getAbsolutePath());
        }
    }

    public static String validateTestSources(PhpProject project, String testDirPath) {
        if (!StringUtils.hasText((String)testDirPath)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_FolderEmpty");
        }
        File testSourcesFile = new File(testDirPath);
        if (!testSourcesFile.isAbsolute()) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestNotAbsolute");
        }
        if (!testSourcesFile.isDirectory()) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestNotDirectory");
        }
        FileObject nbproject = project.getProjectDirectory().getFileObject("nbproject");
        FileObject testSourcesFo = FileUtil.toFileObject((File)testSourcesFile);
        if (testSourcesFile.equals(FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(project)))) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestEqualsSources");
        }
        if (FileUtil.isParentOf((FileObject)nbproject, (FileObject)testSourcesFo) || nbproject.equals(testSourcesFo)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestUnderneathNBMetadata");
        }
        if (!Utils.isFolderWritable(testSourcesFile)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestNotWritable");
        }
        return null;
    }

    public static String warnTestSources(PhpProject project, String testDirPath) {
        File testSourcesFile = new File(testDirPath);
        FileObject testSourcesFo = FileUtil.toFileObject((File)testSourcesFile);
        if (!FileUtil.isParentOf((FileObject)project.getProjectDirectory(), (FileObject)testSourcesFo)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestNotUnderneathProjectFolder");
        }
        return null;
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isValidFileName(String fileName) {
        assert (fileName != null);
        if (fileName.trim().length() == 0) {
            return false;
        }
        for (char ch : INVALID_FILENAME_CHARS) {
            if (fileName.indexOf(ch) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFileName(File file) {
        assert (file != null);
        for (File tmp = file; tmp != null && !tmp.exists(); tmp = tmp.getParentFile()) {
            if (tmp.isAbsolute() && tmp.getParentFile() == null) {
                return true;
            }
            if (Utils.isValidFileName(tmp.getName())) continue;
            return false;
        }
        return true;
    }

    public static String validateProjectDirectory(String projectPath, String type, boolean allowNonEmpty, boolean allowInRoot) {
        return Utils.validateProjectDirectory(new File(projectPath), type, allowNonEmpty, allowInRoot);
    }

    public static String validateProjectDirectory(File project, String type, boolean allowNonEmpty, boolean allowInRoot) {
        File projLoc;
        File cfl;
        assert (project != null);
        assert (type != null);
        if (!project.isAbsolute()) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + type + "NotAbsolute"));
        }
        if (!allowInRoot && Utilities.isUnix() && (cfl = Utils.getCanonicalFile(project)) != null && (cfl.getParentFile() == null || cfl.getParentFile().getParent() == null)) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + type + "InRootNotSupported"));
        }
        File destFolder = project.getAbsoluteFile();
        if (Utils.getCanonicalFile(destFolder) == null) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_Illegal" + type + "Location"));
        }
        for (projLoc = FileUtil.normalizeFile((File)destFolder); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !Utils.isFolderWritable(projLoc)) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + type + "FolderReadOnly"));
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_Illegal" + type + "Location"));
        }
        if (!allowNonEmpty) {
            File[] kids = destFolder.listFiles();
            if (destFolder.exists() && kids != null && kids.length > 0) {
                return NbBundle.getMessage(Utils.class, (String)("MSG_" + type + "FolderExists"));
            }
        }
        return null;
    }

    public static String validateSourcesAndCopyTarget(String sources, String copyTarget) {
        if (Utils.subdirectories(sources, copyTarget)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_SourcesEqualCopyTarget");
        }
        return null;
    }

    public static boolean subdirectories(String dir1, String dir2) {
        assert (dir1 != null);
        assert (dir2 != null);
        if (!dir1.endsWith(File.separator)) {
            dir1 = dir1 + File.separator;
        }
        if (!dir2.endsWith(File.separator)) {
            dir2 = dir2 + File.separator;
        }
        return dir1.startsWith(dir2) || dir2.startsWith(dir1);
    }

    public static String validateAsciiText(String text, String propertyName) {
        assert (propertyName != null);
        if (text == null) {
            return null;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Utils.isAsciiPrintable(text.charAt(i))) continue;
            return NbBundle.getMessage(Utils.class, (String)"MSG_NonAsciiCharacterFound", (Object)propertyName);
        }
        return null;
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isFolderWritable(File folder) {
        if (!folder.isDirectory()) {
            LOGGER.fine(String.format("%s is not a folder", folder));
            return false;
        }
        boolean windows = Utilities.isWindows();
        LOGGER.fine("On Windows: " + windows);
        boolean canWrite = folder.canWrite();
        LOGGER.fine(String.format("Folder %s is writable: %s", folder, canWrite));
        if (!windows) {
            return canWrite;
        }
        LOGGER.fine("Trying to create temp file");
        try {
            File tmpFile = File.createTempFile("netbeans", null, folder);
            LOGGER.fine(String.format("Temp file %s created", tmpFile));
            tmpFile.delete();
            LOGGER.fine(String.format("Temp file %s deleted", tmpFile));
        }
        catch (IOException exc) {
            LOGGER.log(Level.FINE, "Temp file NOT created", exc);
            return false;
        }
        return true;
    }

    public static String unifyPath(String path) {
        assert (path != null);
        return path.replace(File.separatorChar, '/');
    }

    public static void browseFolderFile(PhpVisibilityQuery phpVisibilityQuery, FileObject folder, JTextField textField) {
        String selected = Utils.browseFolderFile(phpVisibilityQuery, folder, textField.getText());
        if (selected != null) {
            textField.setText(selected);
        }
    }

    public static void browseFolderFile(PhpVisibilityQuery phpVisibilityQuery, File folder, JTextField textField) {
        Utils.browseFolderFile(phpVisibilityQuery, FileUtil.toFileObject((File)folder), textField);
    }

    public static String browseFolderFile(PhpVisibilityQuery phpVisibilityQuery, FileObject folder, String preselected) {
        FileObject selected = BrowseFolders.showDialog(phpVisibilityQuery, new FileObject[]{folder}, DataObject.class, Utils.securePreselected(preselected, true));
        if (selected != null) {
            return PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)folder), (File)FileUtil.toFile((FileObject)selected));
        }
        return null;
    }

    public static void browseSourceFile(PhpProject project, JTextField textField) {
        String selected = Utils.browseSource(project, textField.getText(), false);
        if (selected != null) {
            textField.setText(selected);
        }
    }

    public static String browseSourceFile(PhpProject project, String preselected) {
        return Utils.browseSource(project, preselected, false);
    }

    public static void browseSourceFolder(PhpProject project, JTextField textField) {
        String selected = Utils.browseSource(project, textField.getText(), true);
        if (selected != null) {
            textField.setText(selected);
        }
    }

    public static String browseSourceFolder(PhpProject project, String preselected) {
        return Utils.browseSource(project, preselected, true);
    }

    private static String browseSource(PhpProject project, String preselected, boolean selectDirectory) {
        FileObject rootFolder = ProjectPropertiesSupport.getSourcesDirectory(project);
        FileObject selected = BrowseFolders.showDialog(PhpVisibilityQuery.forProject(project), new FileObject[]{rootFolder}, selectDirectory ? DataFolder.class : DataObject.class, Utils.securePreselected(preselected, !selectDirectory));
        if (selected != null) {
            return PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)rootFolder), (File)FileUtil.toFile((FileObject)selected));
        }
        return null;
    }

    private static String securePreselected(String preselected, boolean removeExtension) {
        if (preselected == null) {
            return null;
        }
        String secure = null;
        if (preselected.length() > 0) {
            int idx;
            secure = Utils.unifyPath(preselected);
            if (removeExtension && (idx = secure.lastIndexOf(46)) != -1) {
                secure = secure.substring(0, idx);
            }
        }
        return secure;
    }

    public static void showGeneralOptionsPanel() {
        UiUtils.showOptions((String)"General");
    }

    public static class PhpVersionComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -203741202171115527L;

        public PhpVersionComboBoxModel() {
            this((PhpLanguageOptions.PhpVersion)null);
        }

        public PhpVersionComboBoxModel(PhpLanguageOptions.PhpVersion preselected) {
            super(PhpLanguageOptions.PhpVersion.values());
            if (preselected != null) {
                this.setSelectedItem((Object)preselected);
            } else {
                this.setSelectedItem((Object)ProjectPropertiesSupport.getDefaultPhpVersion());
            }
        }
    }
}

