/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.api;

import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.openide.filesystems.FileObject;

public final class PhpEditorExtender {
    private static final EditorExtender EMPTY_EDITOR_EXTENDER = new EmptyEditorExtender();

    private PhpEditorExtender() {
    }

    public static EditorExtender forFileObject(FileObject fo) {
        if (!PhpEditorExtender.isCurrentlyOpened(fo)) {
            return EMPTY_EDITOR_EXTENDER;
        }
        PhpProject phpProject = PhpProjectUtils.getPhpProject(fo);
        if (phpProject == null) {
            return EMPTY_EDITOR_EXTENDER;
        }
        EditorExtender editorExtender = (EditorExtender)phpProject.getLookup().lookup(EditorExtender.class);
        assert (editorExtender != null) : "Editor extender must be found for " + phpProject;
        return editorExtender;
    }

    private static boolean isCurrentlyOpened(FileObject fo) {
        JTextComponent component = EditorRegistry.lastFocusedComponent();
        if (component == null) {
            return false;
        }
        FileObject opened = NbEditorUtilities.getFileObject((Document)component.getDocument());
        if (opened == null) {
            return false;
        }
        return opened.equals(fo);
    }

    private static final class EmptyEditorExtender
    extends EditorExtender {
        private EmptyEditorExtender() {
        }

        public List<PhpBaseElement> getElementsForCodeCompletion(FileObject fo) {
            return Collections.emptyList();
        }

        public PhpClass getClass(FileObject fo, String variableName) {
            return null;
        }
    }
}

