/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ArrayTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ClassVariableImpl;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ObjectArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;
import org.netbeans.modules.debugger.jpda.models.SuperVariable;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

class AbstractObjectVariable
extends AbstractVariable
implements ObjectVariable {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private String genericType;
    private org.netbeans.api.debugger.jpda.Field[] fields;
    private org.netbeans.api.debugger.jpda.Field[] staticFields;
    private org.netbeans.api.debugger.jpda.Field[] inheritedFields;
    private volatile boolean refreshFields;
    private DebuggetStateListener stateChangeListener = new DebuggetStateListener();
    private volatile Super superClass;
    private int cloneNumber = 1;

    AbstractObjectVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, String string) {
        super(jPDADebuggerImpl, value, string);
        jPDADebuggerImpl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.stateChangeListener, (Object)((Object)jPDADebuggerImpl)));
    }

    AbstractObjectVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, String string, String string2) {
        this(jPDADebuggerImpl, value, string2);
        try {
            if (string != null) {
                this.genericType = AbstractObjectVariable.getTypeDescription(new PushbackReader(new StringReader(string), 1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getFieldsCount() {
        Value value = this.getInnerValue();
        if (value == null) {
            return 0;
        }
        if (value instanceof ArrayReference) {
            return ArrayReferenceWrapper.length0((ArrayReference)value);
        }
        if (this.fields == null || this.refreshFields) {
            this.initFields();
        }
        return this.fields.length;
    }

    public org.netbeans.api.debugger.jpda.Field getField(String string) {
        Field field;
        Value value = this.getInnerValue();
        if (value == null) {
            return null;
        }
        try {
            field = ReferenceTypeWrapper.fieldByName((ReferenceType)ValueWrapper.type(value), string);
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        if (field == null) {
            return null;
        }
        return this.getField(field, (ObjectReference)this.getInnerValue(), this.getID());
    }

    public org.netbeans.api.debugger.jpda.Field[] getFields(int n, int n2) {
        Value value = this.getInnerValue();
        if (value == null) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        try {
            if (value instanceof ArrayReference && (n > 0 || n2 < ArrayReferenceWrapper.length((ArrayReference)value))) {
                Type type = ValueWrapper.type(value);
                ReferenceType referenceType = (ReferenceType)type;
                if (n2 == 0) {
                    n2 = ArrayReferenceWrapper.length((ArrayReference)value);
                }
                org.netbeans.api.debugger.jpda.Field[] fieldArray = this.getFieldsOfArray((ArrayReference)value, ArrayTypeWrapper.componentTypeName((ArrayType)referenceType), this.getID(), n, n2);
                return fieldArray;
            }
            if (this.fields == null || this.refreshFields) {
                this.initFields();
            }
            if (n2 != 0) {
                n2 = Math.min(this.fields.length, n2);
                n = Math.min(this.fields.length, n);
                org.netbeans.api.debugger.jpda.Field[] fieldArray = new org.netbeans.api.debugger.jpda.Field[n2 - n];
                System.arraycopy(this.fields, n, fieldArray, 0, n2 - n);
                return fieldArray;
            }
            return this.fields;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
    }

    public org.netbeans.api.debugger.jpda.Field[] getAllStaticFields(int n, int n2) {
        Value value = this.getInnerValue();
        if (value == null || value instanceof ArrayReference) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (this.fields == null || this.refreshFields) {
            this.initFields();
        }
        if (n2 != 0) {
            n2 = Math.min(this.staticFields.length, n2);
            n = Math.min(this.staticFields.length, n);
            org.netbeans.api.debugger.jpda.Field[] fieldArray = new org.netbeans.api.debugger.jpda.Field[n2 - n];
            System.arraycopy(this.staticFields, n, fieldArray, 0, n2 - n);
            return fieldArray;
        }
        return this.staticFields;
    }

    public org.netbeans.api.debugger.jpda.Field[] getInheritedFields(int n, int n2) {
        Value value = this.getInnerValue();
        if (value == null || value instanceof ArrayReference) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (this.fields == null || this.refreshFields) {
            this.initFields();
        }
        if (n2 != 0) {
            n2 = Math.min(this.inheritedFields.length, n2);
            n = Math.min(this.inheritedFields.length, n);
            org.netbeans.api.debugger.jpda.Field[] fieldArray = new org.netbeans.api.debugger.jpda.Field[n2 - n];
            System.arraycopy(this.inheritedFields, n, fieldArray, 0, n2 - n);
            return fieldArray;
        }
        return this.inheritedFields;
    }

    public Super getSuper() {
        if (this.getInnerValue() == null) {
            return null;
        }
        if (this.superClass != null) {
            return this.superClass;
        }
        try {
            Type type = ValueWrapper.type(this.getInnerValue());
            if (!(type instanceof ClassType)) {
                return null;
            }
            ClassType classType = ClassTypeWrapper.superclass((ClassType)type);
            if (classType == null) {
                return null;
            }
            SuperVariable superVariable = new SuperVariable(this.getDebugger(), (ObjectReference)this.getInnerValue(), classType, this.getID());
            this.superClass = superVariable;
            return superVariable;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
    }

    public List<JPDAClassType> getAllInterfaces() {
        if (this.getInnerValue() == null) {
            return null;
        }
        try {
            Type type = ValueWrapper.type(this.getInnerValue());
            if (!(type instanceof ClassType)) {
                return null;
            }
            List<InterfaceType> list = ClassTypeWrapper.allInterfaces0((ClassType)type);
            if (list == null) {
                return null;
            }
            ArrayList<JPDAClassType> arrayList = new ArrayList<JPDAClassType>();
            for (InterfaceType interfaceType : list) {
                arrayList.add(new JPDAClassTypeImpl(this.getDebugger(), interfaceType));
            }
            return arrayList;
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
    }

    public String getToStringValue() throws InvalidExpressionException {
        Value value = this.getInnerValue();
        return AbstractObjectVariable.getToStringValue(value, this.getDebugger(), 0);
    }

    public String getToStringValue(int n) throws InvalidExpressionException {
        Value value = this.getInnerValue();
        return AbstractObjectVariable.getToStringValue(value, this.getDebugger(), n);
    }

    static String getToStringValue(Value value, JPDADebuggerImpl jPDADebuggerImpl, int n) throws InvalidExpressionException {
        if (value == null) {
            return null;
        }
        try {
            StringReference stringReference;
            Object object;
            if (!(ValueWrapper.type(value) instanceof ClassType)) {
                return AbstractVariable.getValue(value);
            }
            if (value instanceof CharValue) {
                return "'" + value.toString() + "'";
            }
            boolean bl = false;
            boolean bl2 = false;
            if (n > 0 && n < Integer.MAX_VALUE) {
                object = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(value), "toString", "()Ljava/lang/String;");
                stringReference = (StringReference)jPDADebuggerImpl.invokeMethod((ObjectReference)value, (Method)object, new Value[0], n + 1);
            } else if (value instanceof StringReference) {
                stringReference = (StringReference)value;
                bl = true;
            } else {
                object = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(value), "toString", "()Ljava/lang/String;");
                stringReference = (StringReference)jPDADebuggerImpl.invokeMethod((ObjectReference)value, (Method)object, new Value[0]);
            }
            if (stringReference == null) {
                return null;
            }
            object = StringReferenceWrapper.value(stringReference);
            if (n > 0 && n < Integer.MAX_VALUE && ((String)object).length() > n) {
                object = ((String)object).substring(0, n) + "...";
            }
            if (bl) {
                object = "\"" + (String)object + "\"";
            }
            return object;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            return classNotPreparedExceptionWrapper.getLocalizedMessage();
        }
    }

    public Variable invokeMethod(String string, String string2, Variable[] variableArray) throws NoSuchMethodException, InvalidExpressionException {
        return this.invokeMethod(null, string, string2, variableArray);
    }

    public Variable invokeMethod(JPDAThread jPDAThread, String string, String string2, Variable[] variableArray) throws NoSuchMethodException, InvalidExpressionException {
        try {
            int n;
            int n2;
            Object object;
            Value value = this.getInnerValue();
            if (value == null) {
                return null;
            }
            Method method = null;
            if (string2 != null) {
                method = ClassTypeWrapper.concreteMethodByName((ClassType)ValueWrapper.type(value), string, string2);
            } else {
                object = ReferenceTypeWrapper.methodsByName((ClassType)ValueWrapper.type(value), string);
                n2 = object.size();
                for (n = 0; n < n2; ++n) {
                    if (MethodWrapper.isAbstract((Method)object.get(n)) || MethodWrapper.argumentTypeNames((Method)object.get(n)).size() != 0) continue;
                    method = (Method)object.get(n);
                    break;
                }
            }
            if (method == null) {
                object = ReferenceTypeWrapper.methodsByName((ClassType)ValueWrapper.type(value), string);
                n2 = object.size();
                for (n = 0; n < n2; ++n) {
                    System.out.println(TypeComponentWrapper.signature((Method)object.get(n)));
                }
                throw new NoSuchMethodException(TypeWrapper.name(ValueWrapper.type(value)) + "." + string + " : " + string2);
            }
            object = new Value[variableArray.length];
            n2 = variableArray.length;
            for (n = 0; n < n2; ++n) {
                object[n] = ((AbstractVariable)variableArray[n]).getInnerValue();
            }
            value = this.getDebugger().invokeMethod((JPDAThreadImpl)jPDAThread, (ObjectReference)value, method, (Value[])object);
            if (value instanceof ObjectReference) {
                return new AbstractObjectVariable(this.getDebugger(), (ObjectReference)value, this.getID() + method + "^");
            }
            return new AbstractVariable(this.getDebugger(), value, this.getID() + method);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
    }

    public Variable evaluate(String string) throws InvalidExpressionException {
        return this.getDebugger().evaluate(string, this);
    }

    @Override
    public String getType() {
        if (this.genericType != null) {
            return this.genericType;
        }
        Value value = this.getInnerValue();
        if (value == null) {
            return "";
        }
        try {
            return TypeWrapper.name(ValueWrapper.type(value));
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
    }

    @Override
    public JPDAClassType getClassType() {
        Value value = this.getInnerValue();
        if (value == null) {
            return null;
        }
        try {
            Type type = ValueWrapper.type(value);
            if (type instanceof ReferenceType) {
                return new JPDAClassTypeImpl(this.getDebugger(), (ReferenceType)type);
            }
            return null;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return null;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AbstractObjectVariable && this.getID().equals(((AbstractObjectVariable)object).getID());
    }

    @Override
    public int hashCode() {
        return this.getID().hashCode();
    }

    @Override
    protected void setInnerValue(Value value) {
        super.setInnerValue(value);
        this.fields = null;
        this.staticFields = null;
        this.inheritedFields = null;
        this.superClass = null;
    }

    private static String getTypeDescription(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        switch (n) {
            case 90: {
                return "boolean";
            }
            case 66: {
                return "byte";
            }
            case 67: {
                return "char";
            }
            case 83: {
                return "short";
            }
            case 73: {
                return "int";
            }
            case 74: {
                return "long";
            }
            case 70: {
                return "float";
            }
            case 68: {
                return "double";
            }
            case 91: {
                int n2 = 1;
                while (true) {
                    if ((n = pushbackReader.read()) != 91) break;
                    ++n2;
                }
                pushbackReader.unread(n);
                return AbstractObjectVariable.getTypeDescription(pushbackReader) + " " + AbstractObjectVariable.brackets(n2);
            }
            case 76: {
                StringBuffer stringBuffer = new StringBuffer(50);
                while (true) {
                    if ((n = pushbackReader.read()) == 59) {
                        int n3 = stringBuffer.lastIndexOf("/");
                        return n3 == -1 ? stringBuffer.toString() : stringBuffer.substring(n3 + 1);
                    }
                    if (n == 60) {
                        int n4 = stringBuffer.lastIndexOf("/");
                        if (n4 != -1) {
                            stringBuffer.delete(0, n4 + 1);
                        }
                        stringBuffer.append("<");
                        while (true) {
                            String string = AbstractObjectVariable.getTypeDescription(pushbackReader);
                            stringBuffer.append(string);
                            n = pushbackReader.read();
                            if (n == 62) break;
                            pushbackReader.unread(n);
                            stringBuffer.append(',');
                        }
                        pushbackReader.read();
                        stringBuffer.append(">");
                        return stringBuffer.toString();
                    }
                    stringBuffer.append((char)n);
                }
            }
        }
        throw new IOException();
    }

    private static String brackets(int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        do {
            stringBuffer.append("[]");
        } while (--n > 0);
        return stringBuffer.toString();
    }

    private void initFields() {
        Type type;
        this.refreshFields = false;
        Value value = this.getInnerValue();
        if (value != null) {
            try {
                type = ValueWrapper.type(value);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                type = null;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                type = null;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                type = null;
            }
        } else {
            type = null;
        }
        if (!(value instanceof ObjectReference) || !(type instanceof ReferenceType)) {
            this.fields = new org.netbeans.api.debugger.jpda.Field[0];
            this.staticFields = new org.netbeans.api.debugger.jpda.Field[0];
            this.inheritedFields = new org.netbeans.api.debugger.jpda.Field[0];
        } else {
            try {
                ObjectReference objectReference = (ObjectReference)value;
                ReferenceType referenceType = (ReferenceType)type;
                if (objectReference instanceof ArrayReference) {
                    this.fields = this.getFieldsOfArray((ArrayReference)objectReference, ArrayTypeWrapper.componentTypeName((ArrayType)referenceType), this.getID(), 0, ArrayReferenceWrapper.length((ArrayReference)objectReference));
                    this.staticFields = new org.netbeans.api.debugger.jpda.Field[0];
                    this.inheritedFields = new org.netbeans.api.debugger.jpda.Field[0];
                } else {
                    this.initFieldsOfClass(objectReference, referenceType, this.getID());
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                // empty catch block
            }
        }
    }

    private org.netbeans.api.debugger.jpda.Field[] getFieldsOfArray(ArrayReference arrayReference, String string, String string2, int n, int n2) {
        List<Value> list;
        try {
            list = ArrayReferenceWrapper.getValues(arrayReference, n, n2 - n);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        int n3 = list.size();
        org.netbeans.api.debugger.jpda.Field[] fieldArray = new org.netbeans.api.debugger.jpda.Field[n3];
        for (int i = 0; i < n3; ++i) {
            Value value = list.get(i);
            fieldArray[i] = value instanceof ObjectReference ? new ObjectArrayFieldVariable(this.getDebugger(), (ObjectReference)value, string, this, n + i, n2 - 1, string2) : new ArrayFieldVariable(this.getDebugger(), (PrimitiveValue)value, string, this, n + i, n2 - 1, string2);
        }
        return fieldArray;
    }

    private void initFieldsOfClass(ObjectReference objectReference, ReferenceType referenceType, String string) {
        ArrayList<org.netbeans.api.debugger.jpda.Field> arrayList = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        ArrayList<org.netbeans.api.debugger.jpda.Field> arrayList2 = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        ArrayList<org.netbeans.api.debugger.jpda.Field> arrayList3 = new ArrayList<org.netbeans.api.debugger.jpda.Field>();
        try {
            List<Field> list = ReferenceTypeWrapper.allFields0(referenceType);
            HashSet<Field> hashSet = new HashSet<Field>(ReferenceTypeWrapper.fields0(referenceType));
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Field field = list.get(i);
                org.netbeans.api.debugger.jpda.Field field2 = this.getField(field, objectReference, this.getID());
                if (TypeComponentWrapper.isStatic(field)) {
                    arrayList2.add(field2);
                    continue;
                }
                if (hashSet.contains(field)) {
                    arrayList.add(field2);
                    continue;
                }
                arrayList3.add(field2);
            }
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            arrayList.clear();
            arrayList2.clear();
            arrayList3.clear();
        }
        this.fields = arrayList.toArray(new org.netbeans.api.debugger.jpda.Field[arrayList.size()]);
        this.inheritedFields = arrayList3.toArray(new org.netbeans.api.debugger.jpda.Field[arrayList3.size()]);
        this.staticFields = arrayList2.toArray(new org.netbeans.api.debugger.jpda.Field[arrayList2.size()]);
    }

    org.netbeans.api.debugger.jpda.Field getField(Field field, ObjectReference objectReference, String string) {
        if (field.signature().length() == 1) {
            return new FieldVariable(this.getDebugger(), field, string, objectReference);
        }
        return new ObjectFieldVariable(this.getDebugger(), field, string, JPDADebuggerImpl.getGenericSignature(field), objectReference);
    }

    public List<ObjectVariable> getReferringObjects(long l) {
        Value value = this.getJDIValue();
        if (value instanceof ObjectReference) {
            List<ObjectReference> list;
            final String string = Long.toString(this.getUniqueID());
            try {
                list = ObjectReferenceWrapper.referringObjects((ObjectReference)value, l);
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return Collections.emptyList();
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return Collections.emptyList();
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                return Collections.emptyList();
            }
            return new AbstractList<ObjectVariable>(){

                @Override
                public ObjectVariable get(int n) {
                    ObjectReference objectReference = (ObjectReference)list.get(n);
                    if (objectReference instanceof ClassObjectReference) {
                        ClassObjectReference classObjectReference = (ClassObjectReference)objectReference;
                        return new ClassVariableImpl(AbstractObjectVariable.this.getDebugger(), classObjectReference, string + " referrer " + n);
                    }
                    return new AbstractObjectVariable(AbstractObjectVariable.this.getDebugger(), objectReference, string + " referrer " + n);
                }

                @Override
                public int size() {
                    return list.size();
                }
            };
        }
        return Collections.emptyList();
    }

    public long getUniqueID() {
        Value value = this.getJDIValue();
        if (!(value instanceof ObjectReference)) {
            return 0L;
        }
        try {
            return ObjectReferenceWrapper.uniqueID((ObjectReference)value);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return 0L;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return 0L;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return 0L;
        }
    }

    @Override
    public Variable clone() {
        AbstractObjectVariable abstractObjectVariable = new AbstractObjectVariable(this.getDebugger(), this.getJDIValue(), this.getID() + "_clone" + this.cloneNumber++);
        abstractObjectVariable.genericType = this.genericType;
        return abstractObjectVariable;
    }

    @Override
    public String toString() {
        return "ObjectVariable ";
    }

    private class DebuggetStateListener
    implements PropertyChangeListener {
        private DebuggetStateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            if ("state".equals(propertyChangeEvent.getPropertyName()) && (object = propertyChangeEvent.getNewValue()) instanceof Integer && 2 == (Integer)object) {
                AbstractObjectVariable.this.refreshFields = true;
            }
        }
    }
}

