/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ClassTypeWrapper {
    private ClassTypeWrapper() {
    }

    public static List<InterfaceType> allInterfaces0(ClassType classType) throws ClassNotPreparedExceptionWrapper {
        try {
            return classType.allInterfaces();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return Collections.emptyList();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return Collections.emptyList();
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
    }

    public static List<InterfaceType> allInterfaces(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        try {
            return classType.allInterfaces();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
    }

    public static Method concreteMethodByName(ClassType classType, String string, String string2) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        try {
            return classType.concreteMethodByName(string, string2);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
    }

    public static List<InterfaceType> interfaces0(ClassType classType) throws ClassNotPreparedExceptionWrapper {
        try {
            return classType.interfaces();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return Collections.emptyList();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return Collections.emptyList();
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
    }

    public static List<InterfaceType> interfaces(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        try {
            return classType.interfaces();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
    }

    public static Value invokeMethod(ClassType classType, ThreadReference threadReference, Method method, List<? extends Value> list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        try {
            try {
                return classType.invokeMethod(threadReference, method, list, n);
            }
            catch (InternalException internalException) {
                try {
                    if (internalException.errorCode() == 502) {
                        InternalException internalException2 = (InternalException)Exceptions.attachLocalizedMessage((Throwable)internalException, (String)NbBundle.getMessage(JPDADebuggerImpl.class, (String)"JDWPError502"));
                        Exceptions.printStackTrace((Throwable)internalException2);
                        return null;
                    }
                    throw internalException;
                }
                catch (InternalException internalException3) {
                    JDIExceptionReporter.report(internalException3);
                    throw new InternalExceptionWrapper(internalException3);
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
    }

    public static boolean isEnum0(ClassType classType) {
        try {
            return classType.isEnum();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return false;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return false;
        }
    }

    public static boolean isEnum(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        try {
            return classType.isEnum();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
    }

    public static ObjectReference newInstance(ClassType classType, ThreadReference threadReference, Method method, List<? extends Value> list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        try {
            return classType.newInstance(threadReference, method, list, n);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
    }

    public static void setValue(ClassType classType, Field field, Value value) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        try {
            classType.setValue(field, value);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
    }

    public static List<ClassType> subclasses0(ClassType classType) {
        try {
            return classType.subclasses();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            return Collections.emptyList();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return Collections.emptyList();
        }
    }

    public static List<ClassType> subclasses(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        try {
            return classType.subclasses();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
    }

    public static ClassType superclass(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        try {
            return classType.superclass();
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
    }
}

