/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConditionsPanel
extends JPanel {
    private static final int MAX_SAVED_CONDITIONS = 10;
    private JTextField tfConditionFieldForUI;
    private JComboBox cbHitStyle;
    private JCheckBox cbWhenHitCount;
    private JCheckBox classExcludeFilterCheckBox;
    private JLabel classExcludeFilterLabel;
    private JTextField classExcludeFilterTextField;
    private JCheckBox classFilterCheckBox;
    private JLabel classIncludeFilterLabel;
    private JTextField classIncludeFilterTextField;
    private JCheckBox conditionCheckBox;
    private JComboBox conditionComboBox;
    private JPanel panelHitCountFilter;
    private JScrollPane spCondition;
    private JEditorPane tfCondition;
    private JTextField tfHitCountFilter;

    public ConditionsPanel(String string) {
        this.initComponents();
        HelpCtx.setHelpIDString((JComponent)this.tfCondition, (String)string);
        this.tfConditionFieldForUI = new JTextField();
        this.tfConditionFieldForUI.setEnabled(false);
        this.tfConditionFieldForUI.setToolTipText(this.tfCondition.getToolTipText());
        this.classFilterCheckBoxActionPerformed(null);
        this.conditionCheckBoxActionPerformed(null);
        this.cbWhenHitCountActionPerformed(null);
        int n = this.tfConditionFieldForUI.getPreferredSize().height;
        Dimension dimension = this.spCondition.getPreferredSize();
        if (dimension.height > n) {
            n = dimension.height;
            this.tfConditionFieldForUI.setPreferredSize(new Dimension(this.tfConditionFieldForUI.getPreferredSize().width, n));
        }
        this.spCondition.setPreferredSize(dimension);
        this.spCondition.setMinimumSize(dimension);
        this.tfHitCountFilter.setPreferredSize(new Dimension(8 * this.tfHitCountFilter.getFontMetrics(this.tfHitCountFilter.getFont()).charWidth('8'), this.tfHitCountFilter.getPreferredSize().height));
        this.cbHitStyle.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.equals"), NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.greater"), NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.multiple")}));
        this.conditionComboBox.setEditor(new ConditionComboBoxEditor());
        Object[] objectArray = ConditionsPanel.getSavedConditions();
        this.conditionComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
    }

    private static Object[] getSavedConditions() {
        return Properties.getDefault().getProperties("debugger.jpda").getArray("BPConditions", new Object[0]);
    }

    public void showCondition(boolean bl) {
        this.conditionCheckBox.setVisible(bl);
        if (bl) {
            this.conditionCheckBoxActionPerformed(null);
        } else {
            this.conditionComboBox.setVisible(bl);
        }
    }

    public void showClassFilter(boolean bl) {
        this.classFilterCheckBox.setVisible(bl);
        this.classIncludeFilterLabel.setVisible(bl);
        this.classIncludeFilterTextField.setVisible(bl);
        this.classExcludeFilterLabel.setVisible(bl);
        this.classExcludeFilterTextField.setVisible(bl);
        this.classExcludeFilterCheckBox.setVisible(false);
    }

    public void showExclusionClassFilter(boolean bl) {
        this.showClassFilter(false);
        if (bl) {
            this.classExcludeFilterCheckBox.setVisible(bl);
            this.classExcludeFilterTextField.setVisible(bl);
        }
        this.classExcludeFilterCheckBoxActionPerformed(null);
    }

    public void setClassMatchFilter(String[] stringArray) {
        String string = this.getFilterStr(stringArray);
        this.classIncludeFilterTextField.setText(string);
        this.classFilterCheckBox.setSelected(string.length() > 0 || this.classExcludeFilterTextField.getText().length() > 0);
        this.classFilterCheckBoxActionPerformed(null);
    }

    public void setClassExcludeFilter(String[] stringArray) {
        String string = this.getFilterStr(stringArray);
        this.classExcludeFilterTextField.setText(string);
        if (this.classFilterCheckBox.isVisible()) {
            this.classFilterCheckBox.setSelected(string.length() > 0 || this.classIncludeFilterTextField.getText().length() > 0);
            this.classFilterCheckBoxActionPerformed(null);
        }
        if (this.classExcludeFilterCheckBox.isVisible()) {
            this.classExcludeFilterCheckBox.setSelected(string.length() > 0);
            this.classExcludeFilterCheckBoxActionPerformed(null);
        }
    }

    public void setCondition(String string) {
        this.tfCondition.setText(string);
        this.conditionCheckBox.setSelected(string.length() > 0);
        this.conditionCheckBoxActionPerformed(null);
    }

    public void setHitCountFilteringStyle(Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE) {
        this.cbHitStyle.setSelectedIndex(hIT_COUNT_FILTERING_STYLE != null ? hIT_COUNT_FILTERING_STYLE.ordinal() : 0);
    }

    public void setHitCount(int n) {
        if (n != 0) {
            this.cbWhenHitCount.setSelected(true);
            this.tfHitCountFilter.setText(Integer.toString(n));
        } else {
            this.cbWhenHitCount.setSelected(false);
            this.tfHitCountFilter.setText("");
        }
        this.cbWhenHitCountActionPerformed(null);
    }

    public void setupConditionPaneContext(String string, int n) {
        WatchPanel.setupContext(this.tfCondition, string, n);
    }

    public void setupConditionPaneContext() {
        WatchPanel.setupContext(this.tfCondition, null);
    }

    private String getFilterStr(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    static String[] getFilter(String string) {
        String[] stringArray;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (stringArray.length() <= 0) continue;
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getClassMatchFilter() {
        String string = this.classFilterCheckBox.isSelected() ? this.classIncludeFilterTextField.getText().trim() : "";
        return ConditionsPanel.getFilter(string);
    }

    public String[] getClassExcludeFilter() {
        String string = this.classFilterCheckBox.isVisible() && this.classFilterCheckBox.isSelected() || this.classExcludeFilterCheckBox.isVisible() && this.classExcludeFilterCheckBox.isSelected() ? this.classExcludeFilterTextField.getText().trim() : "";
        return ConditionsPanel.getFilter(string);
    }

    public String getCondition() {
        if (this.conditionCheckBox.isSelected()) {
            String string = this.tfCondition.getText().trim();
            if (string.length() > 0) {
                Object[] objectArray = ConditionsPanel.getSavedConditions();
                Object[] objectArray2 = null;
                boolean bl = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (!string.equals(object)) continue;
                    bl = true;
                    objectArray2 = objectArray;
                    if (i <= 0) break;
                    System.arraycopy(objectArray2, 0, objectArray2, 1, i);
                    objectArray2[0] = string;
                    break;
                }
                if (!bl) {
                    if (objectArray.length < 10) {
                        objectArray2 = new Object[objectArray.length + 1];
                        objectArray2[0] = string;
                        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                    } else {
                        objectArray2 = objectArray;
                        System.arraycopy(objectArray2, 0, objectArray2, 1, objectArray2.length - 1);
                        objectArray2[0] = string;
                    }
                }
                Properties.getDefault().getProperties("debugger.jpda").setArray("BPConditions", objectArray2);
            }
            return string;
        }
        return "";
    }

    public Breakpoint.HIT_COUNT_FILTERING_STYLE getHitCountFilteringStyle() {
        if (!this.cbWhenHitCount.isSelected()) {
            return null;
        }
        return Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[this.cbHitStyle.getSelectedIndex()];
    }

    public int getHitCount() {
        if (!this.cbWhenHitCount.isSelected()) {
            return 0;
        }
        String string = this.tfHitCountFilter.getText().trim();
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String valiadateMsg() {
        String string = this.tfHitCountFilter.getText().trim();
        if (this.cbWhenHitCount.isSelected()) {
            if (string.length() > 0) {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_Bad_Hit_Count_Filter_Spec", (Object)string);
                }
                if (n <= 0) {
                    return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_NonPositive_Hit_Count_Filter_Spec");
                }
            } else {
                return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_No_Hit_Count_Filter_Spec");
            }
        }
        if (this.conditionCheckBox.isSelected() && this.tfCondition.getText().trim().length() == 0) {
            return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_No_Condition_Spec");
        }
        return null;
    }

    static String createClassPatternTip(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(string);
        stringBuffer.append("<br>");
        stringBuffer.append(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_Class_Pattern_Help_1"));
        stringBuffer.append("<br>");
        stringBuffer.append(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_Class_Pattern_Help_2"));
        stringBuffer.append("<br>");
        stringBuffer.append(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_Class_Pattern_Help_3"));
        return stringBuffer.toString();
    }

    private void initComponents() {
        this.spCondition = new JScrollPane();
        this.tfCondition = new JEditorPane("text/x-java", "");
        this.classFilterCheckBox = new JCheckBox();
        this.classIncludeFilterLabel = new JLabel();
        this.classIncludeFilterTextField = new JTextField();
        this.classExcludeFilterLabel = new JLabel();
        this.classExcludeFilterCheckBox = new JCheckBox();
        this.classExcludeFilterTextField = new JTextField();
        this.conditionCheckBox = new JCheckBox();
        this.panelHitCountFilter = new JPanel();
        this.tfHitCountFilter = new JTextField();
        this.cbHitStyle = new JComboBox();
        this.cbWhenHitCount = new JCheckBox();
        this.conditionComboBox = new JComboBox();
        this.spCondition = WatchPanel.createScrollableLineEditor(this.tfCondition);
        this.spCondition.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.spCondition.toolTipText"));
        this.tfCondition.setContentType("text/x-java");
        this.tfCondition.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.tfCondition.toolTipText"));
        this.spCondition.setViewportView(this.tfCondition);
        this.tfCondition.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSN_ConditionTF"));
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ConditionsPanel.class, (String)"L_Conditions_Breakpoint_BorderTitle")));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.classFilterCheckBox, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.classFilterCheckBox.text"));
        this.classFilterCheckBox.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_CB_Classes_Filter_Throwing"));
        this.classFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConditionsPanel.this.classFilterCheckBoxActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.classFilterCheckBox, gridBagConstraints);
        this.classIncludeFilterLabel.setLabelFor(this.classIncludeFilterTextField);
        Mnemonics.setLocalizedText((JLabel)this.classIncludeFilterLabel, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.classIncludeFilterLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 3);
        this.add((Component)this.classIncludeFilterLabel, gridBagConstraints);
        this.classIncludeFilterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_IncludeClasses_LBL"));
        this.classIncludeFilterTextField.setToolTipText(ConditionsPanel.createClassPatternTip(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_CB_Classes_Matched")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.classIncludeFilterTextField, gridBagConstraints);
        this.classExcludeFilterLabel.setLabelFor(this.classExcludeFilterTextField);
        Mnemonics.setLocalizedText((JLabel)this.classExcludeFilterLabel, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.classExcludeFilterLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 3);
        this.add((Component)this.classExcludeFilterLabel, gridBagConstraints);
        this.classExcludeFilterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_ExcludeClasses_LBL"));
        Mnemonics.setLocalizedText((AbstractButton)this.classExcludeFilterCheckBox, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.classExcludeFilterLabel.text"));
        this.classExcludeFilterCheckBox.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_CB_Classes_Excluded"));
        this.classExcludeFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classExcludeFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConditionsPanel.this.classExcludeFilterCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.classExcludeFilterCheckBox, gridBagConstraints);
        this.classExcludeFilterTextField.setToolTipText(ConditionsPanel.createClassPatternTip(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_CB_Classes_Excluded")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.classExcludeFilterTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.conditionCheckBox, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.conditionCheckBox.text"));
        this.conditionCheckBox.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_TF_Line_Breakpoint_Condition"));
        this.conditionCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConditionsPanel.this.conditionCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.conditionCheckBox, gridBagConstraints);
        this.panelHitCountFilter.setLayout(new GridBagLayout());
        this.tfHitCountFilter.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_TF_Hit_Count"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.tfHitCountFilter, gridBagConstraints);
        this.tfHitCountFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSN_HitCountTF"));
        this.cbHitStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"equals to", "is greater then", "is multiple of"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        this.panelHitCountFilter.add((Component)this.cbHitStyle, gridBagConstraints);
        this.cbHitStyle.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSN_CB_HitCount"));
        this.cbHitStyle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_CB_HitCount"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbWhenHitCount, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.text"));
        this.cbWhenHitCount.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_TF_Hit_Count"));
        this.cbWhenHitCount.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbWhenHitCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConditionsPanel.this.cbWhenHitCountActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.cbWhenHitCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelHitCountFilter, gridBagConstraints);
        this.conditionComboBox.setEditable(true);
        this.conditionComboBox.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.spCondition.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 3, 3, 3);
        this.add((Component)this.conditionComboBox, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_Conditions"));
    }

    private void classExcludeFilterCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.classExcludeFilterTextField.setEnabled(this.classExcludeFilterCheckBox.isSelected());
    }

    private void cbWhenHitCountActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.cbWhenHitCount.isSelected();
        this.cbHitStyle.setEnabled(bl);
        this.tfHitCountFilter.setEnabled(bl);
    }

    private void conditionCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.conditionCheckBox.isSelected();
        this.conditionComboBox.setEnabled(bl);
        this.conditionComboBox.setEditor(new ConditionComboBoxEditor());
        this.revalidate();
        this.repaint();
    }

    private void classFilterCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.classFilterCheckBox.isSelected();
        this.classIncludeFilterTextField.setEnabled(bl);
        this.classExcludeFilterTextField.setEnabled(bl);
    }

    private final class ConditionComboBoxEditor
    implements ComboBoxEditor {
        private ConditionComboBoxEditor() {
        }

        @Override
        public Component getEditorComponent() {
            if (!ConditionsPanel.this.conditionCheckBox.isSelected()) {
                return ConditionsPanel.this.tfConditionFieldForUI;
            }
            return ConditionsPanel.this.spCondition;
        }

        @Override
        public void setItem(Object object) {
            if (object != null) {
                ConditionsPanel.this.tfCondition.setText(object.toString());
            } else {
                ConditionsPanel.this.tfCondition.setText("");
            }
        }

        @Override
        public Object getItem() {
            return ConditionsPanel.this.tfCondition.getText();
        }

        @Override
        public void selectAll() {
            ConditionsPanel.this.tfCondition.selectAll();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
        }
    }
}

