/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;

public class SmartSteppingImpl
extends SmartSteppingCallback
implements PropertyChangeListener {
    private Set exclusionPatterns = new HashSet();
    private SmartSteppingFilter smartSteppingFilter;
    private SourcePath engineContext;

    public void initFilter(SmartSteppingFilter smartSteppingFilter) {
        this.smartSteppingFilter = smartSteppingFilter;
    }

    public boolean stopHere(ContextProvider contextProvider, JPDAThread jPDAThread, SmartSteppingFilter smartSteppingFilter) {
        String string;
        int n;
        String string2 = jPDAThread.getClassName();
        if (string2 == null) {
            return false;
        }
        SourcePath sourcePath = this.getEngineContext(contextProvider);
        boolean bl = sourcePath.sourceAvailable(jPDAThread, null, false);
        if (bl) {
            return true;
        }
        String string3 = string2.replace('.', '/');
        while ((n = (string = string3).lastIndexOf(47)) >= 0 && !sourcePath.sourceAvailable(string3 = string.substring(0, n), false)) {
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string.replace('/', '.') + ".*");
        this.addExclusionPatterns(hashSet);
        return false;
    }

    private void addExclusionPatterns(Set set) {
        this.smartSteppingFilter.addExclusionPatterns(set);
        this.exclusionPatterns.addAll(set);
    }

    private void removeExclusionPatterns() {
        this.smartSteppingFilter.removeExclusionPatterns(this.exclusionPatterns);
        this.exclusionPatterns = new HashSet();
    }

    private SourcePath getEngineContext(ContextProvider contextProvider) {
        if (this.engineContext == null) {
            this.engineContext = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
            this.engineContext.addPropertyChangeListener(this);
        }
        return this.engineContext;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "sourceRoots") {
            this.removeExclusionPatterns();
        }
    }
}

