/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.ui.PullUpAction;
import org.netbeans.modules.refactoring.java.ui.PullUpPanel;
import org.netbeans.modules.refactoring.java.ui.PushDownRefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PullUpRefactoringUI
implements RefactoringUI {
    private final PullUpRefactoring refactoring;
    private final Set initialMembers = new HashSet();
    private PullUpPanel panel;
    private String description;

    public PullUpRefactoringUI(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        TreePathHandle treePathHandle2 = PushDownRefactoringUI.resolveSelection(treePathHandle, compilationInfo);
        if (treePathHandle2 != null) {
            Element element = treePathHandle2.resolveElement(compilationInfo);
            this.initialMembers.add(MemberInfo.create(element, compilationInfo));
            if (!(element instanceof TypeElement)) {
                element = compilationInfo.getElementUtilities().enclosingTypeElement(element);
            }
            TreePath treePath = compilationInfo.getTrees().getPath(element);
            TreePathHandle treePathHandle3 = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo);
            this.description = ElementHeaders.getHeader((TreePath)treePath, (CompilationInfo)compilationInfo, (String)"%name%");
            this.refactoring = new PullUpRefactoring(treePathHandle3);
            this.refactoring.getContext().add((Object)compilationInfo.getClasspathInfo());
        } else {
            this.refactoring = new PullUpRefactoring(treePathHandle);
        }
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            this.panel = new PullUpPanel(this.refactoring, this.initialMembers, changeListener);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(PullUpAction.class, (String)"DSC_PullUp", (Object)this.description);
    }

    public String getName() {
        return NbBundle.getMessage(PullUpAction.class, (String)"LBL_PullUp");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PullUpRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.refactoring.setTargetType((ElementHandle<TypeElement>)this.panel.getTargetType().getElementHandle());
        this.refactoring.setMembers(this.panel.getMembers());
    }
}

