/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class NameAndTypeUsageMarker
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
AttributeVisitor {
    private static final Object USED = new Object();

    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.attributesAccept(this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.visitRefConstant(clazz, fieldrefConstant);
    }

    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        this.visitRefConstant(clazz, interfaceMethodrefConstant);
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.visitRefConstant(clazz, methodrefConstant);
    }

    private void visitRefConstant(Clazz clazz, RefConstant refConstant) {
        this.markNameAndTypeConstant(clazz, refConstant.u2nameAndTypeIndex);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        if (enclosingMethodAttribute.u2nameAndTypeIndex != 0) {
            this.markNameAndTypeConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex);
        }
    }

    private void markNameAndTypeConstant(Clazz clazz, int n) {
        NameAndTypeUsageMarker.markAsUsed((NameAndTypeConstant)((ProgramClass)clazz).getConstant(n));
    }

    private static void markAsUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(USED);
    }

    static boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == USED;
    }
}

