/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.openide.util.RequestProcessor;

public final class ExclusiveAccess {
    private static final ExclusiveAccess INSTANCE = new ExclusiveAccess();
    private final RequestProcessor rp = new RequestProcessor("Spring config file access thread", 1, false);
    private final ReentrantLock lock = new ReentrantLock();

    public static ExclusiveAccess getInstance() {
        return INSTANCE;
    }

    public AsyncTask createAsyncTask(Runnable run) {
        return new AsyncTask(this.rp.create((Runnable)new TaskWrapper(run), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V runSyncTask(Callable<V> task) throws Exception {
        this.lock.lock();
        try {
            V v = task.call();
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCurrentThreadAccess() {
        return this.lock.isHeldByCurrentThread();
    }

    private final class TaskWrapper
    implements Runnable {
        private final Runnable delegate;

        public TaskWrapper(Runnable delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExclusiveAccess.this.lock.lock();
            try {
                this.delegate.run();
            }
            finally {
                ExclusiveAccess.this.lock.unlock();
            }
        }
    }

    public static final class AsyncTask {
        private final RequestProcessor.Task task;

        AsyncTask(RequestProcessor.Task task) {
            this.task = task;
        }

        public void schedule(int delay) {
            this.task.schedule(delay);
        }

        public boolean cancel() {
            return this.task.cancel();
        }

        public boolean isFinished() {
            return this.task.isFinished();
        }
    }
}

