/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.wizard;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.projecttemplates.FileCreator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public final class ProjectXmlCreator
extends FileCreator {
    private final String projectName;
    private final StringBuilder sb = new StringBuilder();
    private ProjectKind kind;

    public ProjectXmlCreator(String projectName, ProjectKind kind) {
        super("nbproject", "project.xml", false);
        this.projectName = projectName;
        this.kind = kind;
    }

    public DataObject create(FileObject project, Map<String, String> params) throws IOException {
        return DataObject.find((FileObject)this.create(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject create(FileObject project) throws IOException {
        this.sb.setLength(0);
        this.sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.sb.append("<project xmlns=\"http://www.netbeans.org/ns/project/1\">\n");
        this.write(1, "<type>org.netbeans.modules.javacard.JCPROJECT</type>");
        this.write(1, "<configuration>");
        this.write(2, "<data xmlns=\"http://www.netbeans.org/ns/javacard-project/3\">");
        this.write(2, "<!-- Do not use Project Properties customizer when editing this file manually. -->");
        this.write(3, "<name>" + this.projectName + "</name>");
        this.write(3, "<properties>");
        this.write(4, "<property name=\"javacard.project.subtype\">" + this.kind + "</property>");
        this.write(3, "</properties>");
        this.write(3, "<source-roots>");
        this.write(4, "<root id=\"src.dir\"/>");
        this.write(3, "</source-roots>");
        this.write(3, "<dependencies>");
        this.write(3, "</dependencies>");
        this.write(2, "</data>");
        this.write(1, "</configuration>");
        this.write(0, "</project>");
        FileObject projectXml = FileUtil.createData((FileObject)project, (String)"nbproject/project.xml");
        FileLock lock = projectXml.lock();
        BufferedOutputStream out = new BufferedOutputStream(projectXml.getOutputStream(lock));
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(out);
            writer.println(this.sb.toString());
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
            ((OutputStream)out).close();
            lock.releaseLock();
        }
        return projectXml;
    }

    void write(int indent, String toWrite) {
        char[] c = new char[indent * 4];
        Arrays.fill(c, ' ');
        this.sb.append(c);
        this.sb.append(toWrite);
        this.sb.append('\n');
    }
}

