/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.javacard.common.ListenerProxy;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.Dependencies;
import org.netbeans.modules.javacard.project.deps.Dependency;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.xml.sax.SAXException;

final class DependenciesClasspathImpl
extends ListenerProxy<JCProject>
implements ClassPathImplementation,
ChangeListener {
    private final Set<DependencyPathResourceImplementation> resources = new TreeSet<DependencyPathResourceImplementation>();
    volatile boolean attached;

    DependenciesClasspathImpl(JCProject project) {
        super((Object)project);
    }

    protected void attach(JCProject obj, PropertyChangeListener precreatedListener) {
        this.getDeps();
        obj.addDependencyChangeListener(this);
        this.attached = true;
    }

    synchronized Dependencies getDeps() {
        try {
            return ((JCProject)this.get()).syncGetDependencies();
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    protected void detach(JCProject obj, PropertyChangeListener precreatedListener) {
        obj.removeDependencyChangeListener(this);
        this.resources.clear();
        this.attached = false;
    }

    protected void onChange(String prop, Object old, Object nue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        if (!this.attached) {
            DependenciesClasspathImpl dependenciesClasspathImpl = this;
            synchronized (dependenciesClasspathImpl) {
                List<? extends PathResourceImplementation> l = this.refresh();
                this.resources.clear();
                return l;
            }
        }
        DependenciesClasspathImpl dependenciesClasspathImpl = this;
        synchronized (dependenciesClasspathImpl) {
            return new ArrayList<DependencyPathResourceImplementation>(this.resources);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized List<? extends PathResourceImplementation> refresh() {
        TreeSet<DependencyPathResourceImplementation> nue;
        TreeSet<DependencyPathResourceImplementation> old;
        List<Dependency> l = this.getDeps().all();
        DependenciesClasspathImpl dependenciesClasspathImpl = this;
        synchronized (dependenciesClasspathImpl) {
            old = new TreeSet<DependencyPathResourceImplementation>(this.resources);
            nue = new TreeSet<DependencyPathResourceImplementation>();
            for (int i = 0; i < l.size(); ++i) {
                nue.add(new DependencyPathResourceImplementation(l.get(i), i));
            }
            if (((Object)this.resources).equals(nue)) {
                return new ArrayList<DependencyPathResourceImplementation>(this.resources);
            }
            HashSet<DependencyPathResourceImplementation> removed = new HashSet<DependencyPathResourceImplementation>(old);
            removed.removeAll(nue);
            HashSet added = new HashSet(nue);
            added.removeAll(old);
            for (DependencyPathResourceImplementation d : removed) {
                this.resources.remove(d);
            }
            for (DependencyPathResourceImplementation d : added) {
                this.resources.add(d);
            }
        }
        ArrayList result = new ArrayList(nue);
        this.fire("resources", old, result);
        return result;
    }

    final ResolvedDependencies rd() {
        ResolvedDependencies result = null;
        Dependencies d = this.getDeps();
        if (d != null) {
            result = ((JCProject)this.get()).createResolvedDependencies(d);
        }
        return result;
    }

    private final class DependencyPathResourceImplementation
    implements PathResourceImplementation,
    Comparable<DependencyPathResourceImplementation> {
        private final Dependency dep;
        private final int index;

        DependencyPathResourceImplementation(Dependency dep, int index) {
            this.dep = dep;
            this.index = index;
        }

        public String toString() {
            return super.toString() + "[" + this.dep.getID() + ":" + Arrays.asList(this.getRoots()) + "]";
        }

        public URL[] getRoots() {
            ResolvedDependencies rd = DependenciesClasspathImpl.this.rd();
            if (rd == null) {
                return new URL[0];
            }
            ResolvedDependency d = rd.get(this.dep.getID());
            if (d == null) {
                Logger.getLogger(DependenciesClasspathImpl.class.getName()).log(Level.WARNING, "Unresolvable dependency {0} in {1}", new Object[]{this.dep, DependenciesClasspathImpl.this.get()});
                return new URL[0];
            }
            assert (d != null) : "Dependency " + this.dep + " resolves to null";
            ArrayList<URL> urls = new ArrayList<URL>();
            File f = d.resolveFile(ArtifactKind.ORIGIN);
            if (f != null) {
                if (d.getKind().isProjectDependency()) {
                    Project p;
                    FileObject fo = FileUtil.toFileObject((File)f);
                    if (fo != null && (p = FileOwnerQuery.getOwner((FileObject)fo)) != null) {
                        try {
                            URL url = p.getProjectDirectory().getURL();
                            AntArtifactProvider prov = (AntArtifactProvider)p.getLookup().lookup(AntArtifactProvider.class);
                            for (AntArtifact a : prov.getBuildArtifacts()) {
                                URI[] uris;
                                if (!"jar".equals(a.getType())) continue;
                                for (URI u : uris = a.getArtifactLocations()) {
                                    url = new URL(u.toString());
                                    if (!FileUtil.isArchiveFile((URL)url)) continue;
                                    url = FileUtil.getArchiveRoot((URL)url);
                                    urls.add(url);
                                }
                            }
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (FileStateInvalidException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                } else if (f != null) {
                    try {
                        URL url = f.toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)url)) {
                            url = FileUtil.getArchiveRoot((URL)url);
                        }
                        urls.add(url);
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return urls.toArray(new URL[urls.size()]);
        }

        public ClassPathImplementation getContent() {
            return DependenciesClasspathImpl.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public int compareTo(DependencyPathResourceImplementation o) {
            return this.index - o.index;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyPathResourceImplementation other = (DependencyPathResourceImplementation)obj;
            if (!(this.dep == other.dep || this.dep != null && this.dep.equals(other.dep))) {
                return false;
            }
            return this.index == other.index;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.dep != null ? this.dep.hashCode() : 0);
            hash = 71 * hash + this.index;
            return hash;
        }
    }
}

