/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadInfo;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.perfan.stack.impl.FunctionCallImpl;
import org.netbeans.modules.dlight.threads.api.Datarace;

public final class DataraceImpl
implements Datarace {
    private final int id;
    private final long address;
    private String stringAddress;
    private final List<ThreadDump> dumps;
    private static final Pattern RACE_PATTERN = Pattern.compile("Race\\s+#(\\d+),\\s+Vaddr:\\s+(0x(.+)|\\(Multiple\\s+Addresses\\)|Multiple\\s+addresses)");
    private static final Pattern DUMP_PATTERN = Pattern.compile("\\s+Trace\\s+\\d+");
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile(" *Access +\\d+: +(Read|Write) *");

    public DataraceImpl(int id, long address, List<ThreadDump> dumps) {
        this.id = id;
        this.address = address;
        this.dumps = dumps;
    }

    void setStringAddress(String address) {
        this.stringAddress = address;
    }

    public long getAddress() {
        return this.address;
    }

    public String stringAddress() {
        return this.stringAddress;
    }

    public List<ThreadDump> getThreadDumps() {
        return this.dumps;
    }

    public String toString() {
        return "Datarace #" + this.id;
    }

    public static List<DataraceImpl> fromErprint(String[] lines) {
        ArrayList<DataraceImpl> dataraces = new ArrayList<DataraceImpl>();
        ListIterator<String> it = Arrays.asList(lines).listIterator();
        while (it.hasNext()) {
            Matcher m = RACE_PATTERN.matcher(it.next());
            if (!m.matches()) continue;
            dataraces.add(DataraceImpl.parseDatarace(it, m));
        }
        return dataraces;
    }

    private static DataraceImpl parseDatarace(ListIterator<String> it, Matcher firstLineMatch) {
        int id = -1;
        try {
            id = Integer.parseInt(firstLineMatch.group(1));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        long vaddr = -1L;
        String stringAddress = firstLineMatch.group(2);
        if (firstLineMatch.group(3) != null) {
            try {
                vaddr = Long.parseLong(firstLineMatch.group(3), 16);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        ArrayList<ThreadDump> dumps = new ArrayList<ThreadDump>();
        while (it.hasNext()) {
            String line = it.next();
            Matcher m = DUMP_PATTERN.matcher(line);
            if (m.matches()) {
                dumps.add(DataraceImpl.parseThreadDump(it, m));
                continue;
            }
            if (dumps.isEmpty()) continue;
            break;
        }
        DataraceImpl dataRace = new DataraceImpl(id, vaddr, dumps);
        dataRace.setStringAddress(stringAddress);
        return dataRace;
    }

    private static ThreadDump parseThreadDump(ListIterator<String> it, Matcher firstLineMatch) {
        ArrayList<ThreadSnapshot> threads = new ArrayList<ThreadSnapshot>();
        while (it.hasNext()) {
            String line = it.next();
            Matcher m = SNAPSHOT_PATTERN.matcher(line);
            if (m.matches()) {
                threads.add(DataraceImpl.parseThreadSnapshot(it, m));
                continue;
            }
            it.previous();
            break;
        }
        return new ThreadDumpImpl(threads);
    }

    private static ThreadSnapshot parseThreadSnapshot(ListIterator<String> it, Matcher firstLineMatch) {
        ThreadSnapshot.MemoryAccessType memAccessType = ThreadSnapshot.MemoryAccessType.valueOf((String)firstLineMatch.group(1).toUpperCase());
        List<FunctionCall> stack = FunctionCallImpl.parseStack(it);
        return new ThreadSnapshotImpl(stack, null, memAccessType);
    }

    private static class ThreadSnapshotImpl
    implements ThreadSnapshot {
        private final List<FunctionCall> stack;
        private final ThreadInfo threadInfo;
        private final ThreadSnapshot.MemoryAccessType memoryAccessType;

        public ThreadSnapshotImpl(List<FunctionCall> stack, ThreadInfo threadInfo, ThreadSnapshot.MemoryAccessType memoryAccessType) {
            this.stack = stack;
            this.threadInfo = threadInfo;
            this.memoryAccessType = memoryAccessType;
        }

        public List<FunctionCall> getStack() {
            return this.stack;
        }

        public ThreadInfo getThreadInfo() {
            return this.threadInfo;
        }

        public ThreadState.MSAState getState() {
            return ThreadState.MSAState.Running;
        }

        public ThreadSnapshot.MemoryAccessType getMemoryAccessType() {
            return this.memoryAccessType;
        }

        public long getTimestamp() {
            return 0L;
        }
    }

    private static class ThreadDumpImpl
    implements ThreadDump {
        private final List<ThreadSnapshot> threads;

        public ThreadDumpImpl(List<ThreadSnapshot> threads) {
            this.threads = threads;
        }

        public long getTimestamp() {
            return -1L;
        }

        public List<ThreadSnapshot> getThreadStates() {
            return this.threads;
        }
    }
}

