/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerStartException;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.actions.AttachTableColumn;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessList;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessListReader;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class GdbAttachPanel
extends JPanel
implements ProcessListReader {
    private ProcessList procList = null;
    private final AttachTableModel processModel = new AttachTableModel();
    private Controller controller = null;
    private static String lastFilterValue = "";
    private static boolean showAll = false;
    private boolean updateColumns = true;
    private JCheckBox allCheckBox;
    private JTextField filterField;
    private JLabel filterLabel;
    private JComboBox hostComboBox;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel procLabel;
    private JTable processTable;
    private JComboBox projectCB;
    private JLabel projectLabel;

    public GdbAttachPanel() {
        this.initComponents();
        this.postComponentsInit();
        this.updateProcessList(true);
    }

    private void postComponentsInit() {
        for (ServerRecord serverRecord : ServerList.getRecords()) {
            this.hostComboBox.addItem(serverRecord);
        }
        this.filterField.setText(lastFilterValue);
        this.allCheckBox.setSelected(showAll);
        GdbAttachPanel.fillProjectsCombo(this.projectCB);
        this.hostComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    GdbAttachPanel.this.hostComboBoxItemStateChanged(evt);
                }
            }
        });
        this.filterField.getDocument().addDocumentListener(new AnyChangeDocumentListener(){

            @Override
            public void documentChanged(DocumentEvent e) {
                GdbAttachPanel.this.filterTextChanged();
            }
        });
    }

    private ExecutionEnvironment getCurrentExecutionEnvironment() {
        return ((ServerRecord)this.hostComboBox.getSelectedItem()).getExecutionEnvironment();
    }

    private synchronized void filterTextChanged() {
        lastFilterValue = this.filterField.getText();
        this.updateProcessList(false);
    }

    private void setupColumns() {
        this.processModel.setColumnCount(0);
        for (AttachTableColumn hdr : this.procList.getColumnHeaders()) {
            this.processModel.addColumn(hdr);
        }
        int size = this.processTable.getColumnModel().getColumnCount();
        for (int i = 0; i < size; ++i) {
            TableColumn column = this.processTable.getColumnModel().getColumn(i);
            if (column.getIdentifier() == null || !column.getIdentifier().equals(this.procList.getArgsHeader())) continue;
            column.setPreferredWidth(300);
            column.setMinWidth(75);
            break;
        }
    }

    public static void fillProjectsCombo(JComboBox comboBox) {
        Project main = OpenProjects.getDefault().getMainProject();
        for (Project proj : OpenProjects.getDefault().getOpenProjects()) {
            if (proj.getLookup().lookup(ConfigurationDescriptorProvider.class) == null) continue;
            ProjectInformation pinfo = ProjectUtils.getInformation((Project)proj);
            ProjectCBItem pi = new ProjectCBItem(pinfo);
            comboBox.addItem(pi);
            if (main == null || proj != main) continue;
            comboBox.setSelectedItem(pi);
        }
    }

    private void updateProcessList(boolean createPS) {
        if (createPS) {
            this.procList = new ProcessList(this.getCurrentExecutionEnvironment());
            this.updateColumns = true;
        }
        if (showAll) {
            this.procList.requestFull(this.getFilterRE(), this);
        } else {
            this.procList.requestSimple(this.getFilterRE(), this);
        }
    }

    Controller getController() {
        if (this.controller == null) {
            this.controller = new GdbAttachController();
        }
        return this.controller;
    }

    @Override
    public void processListCallback(final List<Vector<String>> rows) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GdbAttachPanel.this.updateColumns) {
                    GdbAttachPanel.this.setupColumns();
                    GdbAttachPanel.this.updateColumns = false;
                }
                GdbAttachPanel.this.processModel.setRowCount(0);
                for (Vector obj : rows) {
                    GdbAttachPanel.this.processModel.addRow(obj);
                }
            }
        });
    }

    private Pattern getFilterRE() {
        if (lastFilterValue.isEmpty()) {
            return null;
        }
        try {
            return Pattern.compile(lastFilterValue);
        }
        catch (PatternSyntaxException pse) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbAttachPanel.class, (String)"ERR_BadFilterPattern")));
            return null;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.processTable = new JTable();
        this.filterLabel = new JLabel();
        this.procLabel = new JLabel();
        this.projectLabel = new JLabel();
        this.projectCB = new JComboBox();
        this.allCheckBox = new JCheckBox();
        this.filterField = new JTextField();
        this.hostComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.processTable.setModel(this.processModel);
        this.processTable.setColumnSelectionAllowed(false);
        this.processTable.setRowSelectionAllowed(true);
        this.processTable.setShowVerticalLines(false);
        this.jScrollPane1.setViewportView(this.processTable);
        this.filterLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachFilterMNEM").charAt(0));
        this.filterLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachFilterLabel"));
        this.procLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachProcessMNEM").charAt(0));
        this.procLabel.setLabelFor(this.jScrollPane1);
        this.procLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachProcessLabel"));
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/attach/Bundle").getString("GdbAttachProjectMNEM").charAt(0));
        this.projectLabel.setLabelFor(this.projectCB);
        this.projectLabel.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachProjectLabel"));
        this.allCheckBox.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachPanel.allCheckBox.text"));
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GdbAttachPanel.this.allCheckBoxActionPerformed(evt);
            }
        });
        this.hostComboBox.setRenderer(new MyDevHostListCellRenderer());
        this.jLabel1.setText(NbBundle.getMessage(GdbAttachPanel.class, (String)"GdbAttachPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.projectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectCB, 0, 532, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.allCheckBox).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hostComboBox, 0, 547, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterField, -1, 545, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.procLabel).addContainerGap()).addComponent(this.jScrollPane1, -1, 588, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostComboBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.filterField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.procLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 201, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectCB, -2, -1, -2))));
    }

    private void allCheckBoxActionPerformed(ActionEvent evt) {
        showAll = this.allCheckBox.isSelected();
        this.updateProcessList(false);
    }

    private void hostComboBoxItemStateChanged(ItemEvent evt) {
        this.updateProcessList(true);
    }

    static class MyDevHostListCellRenderer
    extends DefaultListCellRenderer {
        MyDevHostListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ServerRecord rec = (ServerRecord)value;
            label.setText(rec.getServerDisplayName());
            return label;
        }
    }

    public static abstract class AnyChangeDocumentListener
    implements DocumentListener {
        public abstract void documentChanged(DocumentEvent var1);

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }
    }

    private class GdbAttachController
    implements Controller {
        private GdbAttachController() {
        }

        public boolean cancel() {
            return true;
        }

        public boolean ok() {
            int row = GdbAttachPanel.this.processTable.getSelectedRow();
            if (row >= 0) {
                String pid = GdbAttachPanel.this.processModel.getValueAt(row, 1).toString();
                ProjectCBItem pi = (ProjectCBItem)GdbAttachPanel.this.projectCB.getSelectedItem();
                if (pi != null) {
                    try {
                        GdbDebugger.attach(Integer.valueOf(pid), pi.getProjectInformation(), GdbAttachPanel.this.getCurrentExecutionEnvironment());
                    }
                    catch (DebuggerStartException dse) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbAttachPanel.class, (String)"ERR_UnexpecedAttachFailure", (Object)pid)));
                    }
                }
            }
            return true;
        }

        public boolean isValid() {
            return GdbAttachPanel.this.projectCB.getItemCount() > 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }

    static class AttachTableModel
    extends DefaultTableModel {
        AttachTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public static class ProjectCBItem {
        private ProjectInformation pinfo;

        public ProjectCBItem(ProjectInformation pinfo) {
            this.pinfo = pinfo;
        }

        public String toString() {
            return this.pinfo.getDisplayName();
        }

        public Project getProject() {
            return this.pinfo.getProject();
        }

        public ProjectInformation getProjectInformation() {
            return this.pinfo;
        }
    }
}

