/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.cnd.debugger.common.CallStackFrame;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.openide.text.Annotation;
import org.openide.util.RequestProcessor;

public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private GdbDebugger currentDebugger;
    private final Collection<Annotation> stackAnnotations = new LinkedList<Annotation>();
    private final Set<String> annotatedAddresses = new HashSet<String>();
    private final RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private List<GdbCallStackFrame> stackToAnnotate;

    public CurrentThreadAnnotationListener() {
        this.updateCurrentDebugger();
        assert (this.currentDebugger == null || !Boolean.getBoolean("gdb.assertions.enabled"));
    }

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("currentEngine")) {
            this.updateCurrentDebugger();
            this.annotate(false);
        } else if (e.getPropertyName().equals("currentThread")) {
            this.annotate(false);
        } else if (e.getPropertyName().equals("currentCallStackFrame")) {
            this.annotate(false);
        } else if (e.getPropertyName().equals("state")) {
            this.annotate(false);
        } else if (e.getPropertyName().equals("dis_update")) {
            this.annotate((Boolean)e.getOldValue());
        }
    }

    private void updateCurrentDebugger() {
        GdbDebugger newDebugger = GdbDebugger.getGdbDebugger();
        if (this.currentDebugger == newDebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (newDebugger != null) {
            newDebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.currentDebugger = newDebugger;
    }

    private void annotate(boolean dis) {
        if (this.currentDebugger == null) {
            return;
        }
        if (!this.currentDebugger.isStopped()) {
            this.removeAnnotations();
            return;
        }
        this.currentDebugger.showCurrentSource(dis);
        this.annotateCallStack(this.currentDebugger.getCallStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create(new Runnable(){

                    @Override
                    public void run() {
                        CurrentThreadAnnotationListener.this.clearAnnotations();
                    }
                });
            }
        }
        this.taskRemove.schedule(500);
    }

    private void clearAnnotations() {
        for (Annotation ann : this.stackAnnotations) {
            EditorContextBridge.removeAnnotation((Annotation)ann);
        }
        this.stackAnnotations.clear();
        this.annotatedAddresses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(List<GdbCallStackFrame> stack) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.stackToAnnotate = stack;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ArrayList stack;
                        RequestProcessor requestProcessor = CurrentThreadAnnotationListener.this.rp;
                        synchronized (requestProcessor) {
                            if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                                return;
                            }
                            stack = new ArrayList(CurrentThreadAnnotationListener.this.stackToAnnotate);
                            CurrentThreadAnnotationListener.this.stackToAnnotate = null;
                        }
                        CurrentThreadAnnotationListener.this.clearAnnotations();
                        if (stack.isEmpty()) {
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CurrentThreadAnnotationListener.this.annotateFrame((GdbCallStackFrame)((Object)stack.get(0)), "CurrentPC");
                            }
                        });
                        int end = stack.size();
                        for (int i = 1; i < end; ++i) {
                            CurrentThreadAnnotationListener.this.annotateFrame((GdbCallStackFrame)((Object)stack.get(i)), "CallSite");
                        }
                    }
                });
            }
        }
        this.taskAnnotate.schedule(50);
    }

    private void annotateFrame(GdbCallStackFrame csf, String annotationType) {
        Annotation disa;
        if (!this.annotatedAddresses.add(csf.getAddr())) {
            return;
        }
        final Annotation da = EditorContextBridge.annotate((CallStackFrame)csf, (String)annotationType);
        if (da != null) {
            this.stackAnnotations.add(da);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    da.moveToFront();
                }
            });
        }
        if ((disa = EditorContextBridge.annotateDis((CallStackFrame)csf, (String)annotationType)) != null) {
            this.stackAnnotations.add(disa);
        }
    }
}

