/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class MemberBindingFilter<T extends Element>
extends Filter<T> {
    private static final String NON_BINDING_MEMBER_ANNOTATION = "javax.enterprise.inject.Nonbinding";
    private WebBeansModelImplementation myImpl;
    private List<AnnotationMirror> myBindingAnnotations;
    private Class<T> myClass;

    private MemberBindingFilter(Class<T> clazz) {
        this.myClass = clazz;
    }

    static <T extends Element> MemberBindingFilter<T> get(Class<T> clazz) {
        MemberBindingFilter.assertElement(clazz);
        if (clazz.equals(Element.class)) {
            return new MemberBindingFilter<Element>(Element.class);
        }
        if (clazz.equals(TypeElement.class)) {
            return new MemberBindingFilter<TypeElement>(TypeElement.class);
        }
        return null;
    }

    void init(List<AnnotationMirror> list, WebBeansModelImplementation webBeansModelImplementation) {
        this.myImpl = webBeansModelImplementation;
        this.myBindingAnnotations = list;
    }

    @Override
    void filter(Set<T> set) {
        super.filter(set);
        if (set.size() == 0) {
            return;
        }
        for (AnnotationMirror annotationMirror : this.getBindingAnnotations()) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            Set<ExecutableElement> set2 = this.collectBindingMembers(annotationMirror);
            this.checkMembers(map, set2, set);
        }
    }

    Class<T> getElementClass() {
        return this.myClass;
    }

    private void checkMembers(Map<? extends ExecutableElement, ? extends AnnotationValue> map, Set<ExecutableElement> set, Set<T> set2) {
        MemberCheckerFilter<T> memberCheckerFilter = MemberCheckerFilter.get(this.getElementClass());
        memberCheckerFilter.init(map, set, this.getImplementation());
        memberCheckerFilter.filter(set2);
    }

    private Set<ExecutableElement> collectBindingMembers(AnnotationMirror annotationMirror) {
        DeclaredType declaredType = annotationMirror.getAnnotationType();
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        List<? extends Element> list = typeElement.getEnclosedElements();
        HashSet<ExecutableElement> hashSet = new HashSet<ExecutableElement>();
        for (Element element : list) {
            ExecutableElement executableElement;
            if (!(element instanceof ExecutableElement) || !this.isBindingMember(executableElement = (ExecutableElement)element)) continue;
            hashSet.add(executableElement);
        }
        return hashSet;
    }

    private boolean isBindingMember(ExecutableElement executableElement) {
        List<? extends AnnotationMirror> list = this.getImplementation().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(executableElement);
        for (AnnotationMirror annotationMirror : list) {
            Name name = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!NON_BINDING_MEMBER_ANNOTATION.contentEquals(name)) continue;
            return false;
        }
        return true;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private List<AnnotationMirror> getBindingAnnotations() {
        return this.myBindingAnnotations;
    }
}

