/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.management.api.ExecutionContextEvent;
import org.netbeans.modules.dlight.management.api.ExecutionContextListener;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.impl.DataCollectorProvider;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.Exceptions;

final class ExecutionContext {
    private static final Object lock = new Object();
    private static final Logger log = DLightLogger.getLogger(ExecutionContext.class);
    private final DLightTarget target;
    private final DLightTargetExecutionEnvProviderCollection envProvider;
    private final List<DLightTool> tools;
    private List<ExecutionContextListener> listeners = null;
    private volatile boolean validationInProgress = false;
    private DLightConfiguration dlightConfiguration;

    ExecutionContext(DLightTarget target, DLightConfiguration dlightConfiguration) {
        this.target = target;
        this.dlightConfiguration = dlightConfiguration;
        this.tools = Collections.unmodifiableList(dlightConfiguration.getToolsSet());
        DataCollectorProvider.getInstance().reset();
        this.envProvider = new DLightTargetExecutionEnvProviderCollection();
    }

    void clear() {
        this.envProvider.clear();
    }

    DLightTarget getTarget() {
        return this.target;
    }

    DLightConfiguration getDLightConfiguration() {
        return this.dlightConfiguration;
    }

    void addDLightTargetExecutionEnviromentProvider(DLightTarget.ExecutionEnvVariablesProvider executionEnvProvider) {
        this.envProvider.add(executionEnvProvider);
    }

    DLightTarget.ExecutionEnvVariablesProvider getDLightTargetExecutionEnvProvider() {
        return this.envProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListeners(List<ExecutionContextListener> listeners) {
        Object object = lock;
        synchronized (object) {
            this.listeners = listeners;
        }
    }

    void validateTools() {
        this.validateTools(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void validateTools(boolean performRequiredActions, List<DLightTool> toolsToValidate) {
        ValidationStatus collectorCurrentStatus;
        DLightLogger.assertNonUiThread();
        Object object = lock;
        synchronized (object) {
            if (this.validationInProgress) {
                return;
            }
            this.validationInProgress = true;
        }
        HashMap<Object, Future> tasks = new HashMap<Object, Future>();
        HashMap<Object, ValidationStatus> states = new HashMap<Object, ValidationStatus>();
        ArrayList<DataCollector> collectors = new ArrayList<DataCollector>();
        if (this.getDLightConfiguration().getConfigurationOptions(false).areCollectorsTurnedOn()) {
            for (DLightTool tool : toolsToValidate) {
                List toolCollectors = this.getDLightConfiguration().getConfigurationOptions(false).getCollectors(tool);
                for (DataCollector c : toolCollectors) {
                    if (collectors.contains(c)) continue;
                    collectors.add(c);
                }
            }
        }
        ArrayList<IndicatorDataProvider> idps = new ArrayList<IndicatorDataProvider>();
        for (DLightTool tool : toolsToValidate) {
            List tool_idps = this.getDLightConfiguration().getConfigurationOptions(false).getIndicatorDataProviders(tool);
            for (IndicatorDataProvider idp : tool_idps) {
                if (idp instanceof DataCollector && collectors.contains((DataCollector)idp) || idps.contains(idp)) continue;
                idps.add(idp);
            }
        }
        for (final DataCollector c : collectors) {
            collectorCurrentStatus = c.getValidationStatus();
            states.put(c, collectorCurrentStatus);
            tasks.put(c, DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    return c.validate((Object)ExecutionContext.this.target);
                }
            }, (String)("Data Collector " + c.getName() + " validation")));
        }
        for (final IndicatorDataProvider idp : idps) {
            collectorCurrentStatus = idp.getValidationStatus();
            states.put(idp, collectorCurrentStatus);
            tasks.put(idp, DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    return idp.validate((Object)ExecutionContext.this.target);
                }
            }, (String)("Indicator Data Provider " + idp.getName() + " validation")));
        }
        boolean changed = false;
        boolean willReiterate = true;
        while (willReiterate) {
            ArrayList toValidate = new ArrayList(tasks.keySet());
            willReiterate = false;
            for (final Validateable validatable : toValidate) {
                Future task = (Future)tasks.get(validatable);
                try {
                    boolean thisValidatableStateChaged;
                    ValidationStatus vNewStatus = (ValidationStatus)task.get();
                    boolean bl = thisValidatableStateChaged = !vNewStatus.equals(states.get(validatable));
                    if (performRequiredActions) {
                        if (!vNewStatus.isKnown()) {
                            Collection actions = vNewStatus.getRequiredActions();
                            if (actions != null) {
                                for (AsynchronousAction a : actions) {
                                    try {
                                        a.invoke();
                                    }
                                    catch (Exception ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            }
                            boolean bl2 = thisValidatableStateChaged = !(vNewStatus = (ValidationStatus)(task = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                                @Override
                                public ValidationStatus call() throws Exception {
                                    return validatable.validate((Object)ExecutionContext.this.target);
                                }
                            }, (String)(validatable + " validation"))).get()).equals(states.get(validatable));
                        }
                        if (!vNewStatus.isKnown() && thisValidatableStateChaged) {
                            states.put(validatable, vNewStatus);
                            tasks.put(validatable, task);
                            willReiterate = true;
                        } else {
                            tasks.remove(validatable);
                            states.remove(validatable);
                        }
                    }
                    if (changed || !thisValidatableStateChaged) continue;
                    changed = true;
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (changed) {
            this.notifyListeners(new ExecutionContextEvent(this, ExecutionContextEvent.Type.TOOLS_CHANGED_EVENT, this));
        }
        this.validationInProgress = false;
    }

    void validateTools(boolean performRequiredActions) {
        this.validateTools(performRequiredActions, this.getTools());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(ExecutionContextEvent event) {
        ExecutionContextListener[] lls = null;
        Object object = lock;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            lls = this.listeners.toArray(new ExecutionContextListener[0]);
        }
        for (ExecutionContextListener l : lls) {
            l.contextChanged(event);
        }
    }

    List<Indicator<?>> getIndicators() {
        ArrayList result = new ArrayList();
        Collection activeToolNames = this.getDLightConfiguration().getConfigurationOptions(false).getActiveToolNames();
        for (DLightTool tool : this.tools) {
            if (activeToolNames != null && !activeToolNames.contains(tool.getID())) continue;
            result.addAll(DLightToolAccessor.getDefault().getIndicators(tool));
        }
        return result;
    }

    DLightTool getToolByName(String toolName) {
        Collection activeToolNames = this.getDLightConfiguration().getConfigurationOptions(false).getActiveToolNames();
        for (DLightTool tool : this.tools) {
            if (activeToolNames != null && (!activeToolNames.contains(tool.getID()) || !tool.getName().equals(toolName))) continue;
            return tool;
        }
        return null;
    }

    DLightTool getToolByID(String toolId) {
        Collection activeToolNames = this.getDLightConfiguration().getConfigurationOptions(false).getActiveToolNames();
        for (DLightTool tool : this.tools) {
            if (activeToolNames != null && (!activeToolNames.contains(toolId) || !tool.getID().equals(toolId))) continue;
            return tool;
        }
        return null;
    }

    List<DLightTool> getTools() {
        ArrayList<DLightTool> result = new ArrayList<DLightTool>();
        Collection activeToolNames = this.getDLightConfiguration().getConfigurationOptions(false).getActiveToolNames();
        for (DLightTool tool : this.tools) {
            if ((!tool.isEnabled() || activeToolNames != null && !activeToolNames.contains(tool.getID())) && (tool.isEnabled() || activeToolNames == null || !activeToolNames.contains(tool.getID()))) continue;
            result.add(tool);
        }
        return result;
    }

    private static final class DLightTargetExecutionEnvProviderCollection
    implements DLightTarget.ExecutionEnvVariablesProvider {
        private Set<DLightTarget.ExecutionEnvVariablesProvider> providers = new HashSet<DLightTarget.ExecutionEnvVariablesProvider>();

        DLightTargetExecutionEnvProviderCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            DLightTargetExecutionEnvProviderCollection dLightTargetExecutionEnvProviderCollection = this;
            synchronized (dLightTargetExecutionEnvProviderCollection) {
                this.providers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(DLightTarget.ExecutionEnvVariablesProvider provider) {
            DLightTargetExecutionEnvProviderCollection dLightTargetExecutionEnvProviderCollection = this;
            synchronized (dLightTargetExecutionEnvProviderCollection) {
                this.providers.add(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupEnvironment(DLightTarget target, MacroMap env) throws ConnectException {
            DLightTarget.ExecutionEnvVariablesProvider[] pp = null;
            DLightTargetExecutionEnvProviderCollection dLightTargetExecutionEnvProviderCollection = this;
            synchronized (dLightTargetExecutionEnvProviderCollection) {
                pp = this.providers.toArray(new DLightTarget.ExecutionEnvVariablesProvider[0]);
            }
            for (DLightTarget.ExecutionEnvVariablesProvider provider : pp) {
                provider.setupEnvironment(target, env);
            }
        }
    }
}

