/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public final class HtmlCaretAwareSourceTask
extends ParserResultTask<HtmlParserResult> {
    private static final Logger LOGGER = Logger.getLogger(HtmlCaretAwareSourceTask.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.INFO);
    private static final String SOURCE_DOCUMENT_PROPERTY_NAME = Source.class.getName();

    public static synchronized Source forDocument(Document doc) {
        Source source = (Source)doc.getProperty(SOURCE_DOCUMENT_PROPERTY_NAME);
        if (source == null) {
            source = new Source();
            doc.putProperty(SOURCE_DOCUMENT_PROPERTY_NAME, source);
        }
        return source;
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public void run(HtmlParserResult result, SchedulerEvent event) {
        if (event == null) {
            if (LOG) {
                LOGGER.log(Level.INFO, "ParserResultTask.run(...) called with null SchedulerEvent argument.");
            }
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (doc != null) {
            HtmlCaretAwareSourceTask.forDocument(doc).parsed((Parser.Result)result, event);
        }
    }

    public static interface SourceListener {
        public void parsed(Parser.Result var1, SchedulerEvent var2);
    }

    public static class Source {
        private Vector<SourceListener> listeners = new Vector();

        protected void parsed(Parser.Result ci, SchedulerEvent event) {
            for (SourceListener listener : this.listeners) {
                listener.parsed(ci, event);
            }
        }

        public void addChangeListener(SourceListener l) {
            this.listeners.add(l);
        }

        public void removeChangeListener(SourceListener l) {
            this.listeners.remove(l);
        }
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            String mimeType = snapshot.getMimeType();
            if (mimeType.equals("text/html")) {
                return Collections.singletonList(new HtmlCaretAwareSourceTask());
            }
            return Collections.emptyList();
        }
    }
}

