/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorDefaultCommand
extends PropertyEditorUserCode
implements PropertyEditorElement,
CleanUp {
    private static final String NONE_ITEM = NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"LBL_SELECTCOMMAND_NONE");
    private List<String> tags = new ArrayList<String>();
    private Map<String, DesignComponent> values = new TreeMap<String, DesignComponent>();
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private TypeID parentTypeID;

    private PropertyEditorDefaultCommand(TypeID parentTypeID) {
        super(NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"LBL_DEF_COMMAND_UCLABEL"));
        this.parentTypeID = parentTypeID;
    }

    public static PropertyEditorDefaultCommand createInstance() {
        return new PropertyEditorDefaultCommand(null);
    }

    public static PropertyEditorDefaultCommand createInstance(TypeID parentTypeID) {
        return new PropertyEditorDefaultCommand(parentTypeID);
    }

    @Override
    public void clean(DesignComponent component) {
        super.cleanUp(component);
        this.tags = null;
        this.values = null;
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.parentTypeID = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"LBL_DEF_COMMAND_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor();
        this.radioButton.addActionListener(this.customEditor);
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public void setAsText(String text) {
        this.saveValue(text);
    }

    @Override
    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return NONE_ITEM;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return this.getDecodeValue(value);
    }

    @Override
    public Boolean canEditAsText() {
        return null;
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        this.customEditor.updateModel();
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.setValue(null);
        } else {
            this.customEditor.setValue(value);
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String text) {
        if (text.length() > 0) {
            if (NONE_ITEM.equals(text)) {
                super.setValue((Object)NULL_VALUE);
            } else {
                final DesignComponent command = this.values.get(text);
                if (command != null) {
                    final DesignComponent[] itemCommandSource = new DesignComponent[]{this.getItemCommandEvenSource(text)};
                    if (itemCommandSource[0] == null && this.component != null && this.component.get() != null) {
                        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().writeAccess(new Runnable(){

                            @Override
                            public void run() {
                                itemCommandSource[0] = MidpDocumentSupport.attachCommandToItem((DesignComponent)PropertyEditorDefaultCommand.this.component.get(), command);
                            }
                        });
                    }
                    super.setValue((Object)PropertyValue.createComponentReference((DesignComponent)itemCommandSource[0]));
                }
            }
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public String[] getTags() {
        this.tags.clear();
        if (this.isCurrentValueAUserCodeType()) {
            this.tags.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            this.tags.add(NONE_ITEM);
            this.values.clear();
            this.values.put(NONE_ITEM, null);
            if (this.component != null && this.component.get() != null) {
                final DesignComponent itemComponent = (DesignComponent)this.component.get();
                itemComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        DesignComponent parentComponent = itemComponent.getParentComponent();
                        if (parentComponent != null) {
                            List formCmdESValues = parentComponent.readProperty("commands").getArray();
                            ArrayList<DesignComponent> formCommands = new ArrayList<DesignComponent>(formCmdESValues.size());
                            for (PropertyValue esValue : formCmdESValues) {
                                PropertyValue ordinaryValue;
                                DesignComponent command = esValue.getComponent().readProperty("command").getComponent();
                                if (command == null || !MidpTypes.getBoolean(ordinaryValue = command.readProperty("ordinary"))) continue;
                                formCommands.add(command);
                            }
                            Collection components = MidpDocumentSupport.getCategoryComponent(itemComponent.getDocument(), CommandsCategoryCD.TYPEID).getComponents();
                            ArrayList<DesignComponent> commands = new ArrayList<DesignComponent>(components.size());
                            for (DesignComponent command : components) {
                                PropertyValue ordinaryValue = command.readProperty("ordinary");
                                if (!MidpTypes.getBoolean(ordinaryValue)) continue;
                                commands.add(command);
                            }
                            commands.removeAll(formCommands);
                            for (DesignComponent command : commands) {
                                String displayName = PropertyEditorDefaultCommand.this.getComponentDisplayName(command);
                                PropertyEditorDefaultCommand.this.tags.add(displayName);
                                PropertyEditorDefaultCommand.this.values.put(displayName, command);
                            }
                        }
                    }
                });
            }
        }
        return this.tags.toArray(new String[this.tags.size()]);
    }

    private String getComponentDisplayName(DesignComponent component) {
        return MidpValueSupport.getHumanReadableString(component);
    }

    private String getDecodeValue(final PropertyValue value) {
        final String[] decodeValue = new String[1];
        if (this.component != null && this.component.get() != null) {
            DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
            document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    decodeValue[0] = PropertyEditorDefaultCommand.this.getComponentDisplayName(value.getComponent());
                }
            });
        }
        return decodeValue[0];
    }

    private DesignComponent getItemCommandEvenSource(final String name) {
        final DesignComponent[] itemCommandEvenSource = new DesignComponent[1];
        if (this.component != null && this.component.get() != null) {
            final DesignComponent itemComponent = (DesignComponent)this.component.get();
            itemComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent command = (DesignComponent)PropertyEditorDefaultCommand.this.values.get(name);
                    List itemESValues = itemComponent.readProperty("commands").getArray();
                    for (PropertyValue esValue : itemESValues) {
                        DesignComponent existingES = esValue.getComponent();
                        if (!existingES.readProperty("command").getComponent().equals(command)) continue;
                        itemCommandEvenSource[0] = existingES;
                        break;
                    }
                }
            });
        }
        return itemCommandEvenSource[0];
    }

    @Override
    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            final DesignComponent[] parent = new DesignComponent[1];
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    parent[0] = _component.getParentComponent();
                }
            });
            if (parent[0] != null && this.parentTypeID.equals((Object)parent[0].getType())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JComboBox combobox;

        void cleanUp() {
            if (this.combobox != null) {
                this.combobox.removeActionListener(this);
                this.combobox = null;
            }
            this.removeAll();
        }

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.combobox = new JComboBox();
            this.combobox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"ACSN_DefaultCommandChooser"));
            this.combobox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorDefaultCommand.class, (String)"ACSD_DefaultCommandChooser"));
            this.combobox.setModel(new DefaultComboBoxModel());
            this.combobox.addActionListener(this);
            this.add((Component)this.combobox, "Center");
        }

        public void setValue(final PropertyValue value) {
            if (value == null) {
                this.combobox.setSelectedItem(NONE_ITEM);
                return;
            }
            final PropertyValue[] cmdValue = new PropertyValue[1];
            if (PropertyEditorDefaultCommand.this.component != null && PropertyEditorDefaultCommand.this.component.get() != null) {
                DesignDocument document = ((DesignComponent)PropertyEditorDefaultCommand.this.component.get()).getDocument();
                document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        cmdValue[0] = value.getComponent().readProperty("command");
                    }
                });
            }
            if (cmdValue[0] == null) {
                return;
            }
            DesignComponent command = cmdValue[0].getComponent();
            for (String key : PropertyEditorDefaultCommand.this.values.keySet()) {
                DesignComponent tmpCommand = (DesignComponent)PropertyEditorDefaultCommand.this.values.get(key);
                if (tmpCommand == null || !tmpCommand.equals(command)) continue;
                this.combobox.setSelectedItem(key);
                break;
            }
        }

        public String getText() {
            return (String)this.combobox.getSelectedItem();
        }

        public void updateModel() {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.combobox.getModel();
            model.removeAllElements();
            for (String tag : PropertyEditorDefaultCommand.this.tags) {
                model.addElement(tag);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PropertyEditorDefaultCommand.this.radioButton.setSelected(true);
        }
    }
}

