/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.points;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeNamePresenter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPresenter;
import org.netbeans.modules.vmd.api.inspector.InspectorPositionPresenter;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeletePresenter;
import org.netbeans.modules.vmd.midp.components.MidpVersionDescriptor;
import org.netbeans.modules.vmd.midp.components.handlers.PreviousScreenEventHandlerCD;
import org.netbeans.modules.vmd.midp.components.points.PointCD;

public final class DisplayCD
extends ComponentDescriptor {
    public static final TypeID TYPEID = new TypeID(TypeID.Kind.COMPONENT, "#Display");

    public TypeDescriptor getTypeDescriptor() {
        return new TypeDescriptor(PointCD.TYPEID, TYPEID, true, true);
    }

    public VersionDescriptor getVersionDescriptor() {
        return MidpVersionDescriptor.MIDP;
    }

    public List<PropertyDescriptor> getDeclaredPropertyDescriptors() {
        return null;
    }

    protected void gatherPresenters(ArrayList<Presenter> presenters) {
        DocumentSupport.removePresentersOfClass(presenters, InspectorFolderPresenter.class);
        DocumentSupport.removePresentersOfClass(presenters, InspectorPositionPresenter.class);
        super.gatherPresenters(presenters);
    }

    protected List<? extends Presenter> createPresenters() {
        return Arrays.asList(this.createSwitchDisplayCodePresenter(), CodeNamePresenter.fixed((String[])new String[]{"switchDisplayable", "getDisplay", "__previousDisplayables", "switchToPreviousDisplayable"}), DeletePresenter.createIndeliblePresenter());
    }

    private CodeClassLevelPresenter.Adapter createSwitchDisplayCodePresenter() {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection section) {
                if (this.isPreviousScreenEventHandlerUsed()) {
                    section.getWriter().write("private java.util.Hashtable __previousDisplayables = new java.util.Hashtable ();\n");
                }
            }

            protected void generateMethodSectionCode(MultiGuardedSection section) {
                if (this.isPreviousScreenEventHandlerUsed()) {
                    section.getWriter().write("/**\n * Switches a display to previous displayable of the current displayable.\n * The <code>display</code> instance is obtain from the <code>getDisplay</code> method.\n */\n");
                    section.getWriter().write("private void switchToPreviousDisplayable () {\n");
                    section.getWriter().write("Displayable __currentDisplayable = getDisplay ().getCurrent ();\n");
                    section.getWriter().write("if (__currentDisplayable != null) {\n");
                    section.getWriter().write("Displayable __nextDisplayable = (Displayable) __previousDisplayables.get (__currentDisplayable);\n");
                    section.getWriter().write("if (__nextDisplayable != null) {\n");
                    section.getWriter().write("switchDisplayable (null, __nextDisplayable);\n");
                    section.getWriter().write("}\n");
                    section.getWriter().write("}\n");
                    section.getWriter().write("}\n");
                }
            }

            protected void generateClassBodyCode(StyledDocument document) {
                MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(this.getComponent().getComponentID() + "-switchDisplayable"));
                section.getWriter().write("//<editor-fold defaultstate=\"collapsed\" desc=\" Generated Method: switchDisplayable \">\n");
                section.getWriter().write("/**\n * Switches a current displayable in a display. The <code>display</code> instance is taken from <code>getDisplay</code> method. This method is used by all actions in the design for switching displayable.\n * @param alert the Alert which is temporarily set to the display; if <code>null</code>, then <code>nextDisplayable</code> is set immediately\n * @param nextDisplayable the Displayable to be set\n */\n");
                section.getWriter().write("public void switchDisplayable (Alert alert, Displayable nextDisplayable) {\n").commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-preSwitch");
                section.getWriter().write(" // write pre-switch user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write("Display display = getDisplay ();\n");
                if (this.isPreviousScreenEventHandlerUsed()) {
                    section.getWriter().write("Displayable __currentDisplayable = display.getCurrent ();\n");
                    section.getWriter().write("if (__currentDisplayable != null  &&  nextDisplayable != null) {\n");
                    section.getWriter().write("__previousDisplayables.put (nextDisplayable, __currentDisplayable);\n");
                    section.getWriter().write("}\n");
                }
                section.getWriter().write("if (alert == null) {\n");
                section.getWriter().write("display.setCurrent (nextDisplayable);\n");
                section.getWriter().write("} else {\n");
                section.getWriter().write("display.setCurrent (alert, nextDisplayable);\n");
                section.getWriter().write("}\n").commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-postSwitch");
                section.getWriter().write(" // write post-switch user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write("}\n");
                section.getWriter().write("//</editor-fold>\n").commit();
                section.close();
            }

            private boolean isPreviousScreenEventHandlerUsed() {
                return !DocumentSupport.gatherAllComponentsOfTypeID((DesignDocument)this.getComponent().getDocument(), (TypeID)PreviousScreenEventHandlerCD.TYPEID).isEmpty();
            }
        };
    }
}

