/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final long serialVersionUID = 4227225638931828014L;
    private JPopupMenu popupMenu;
    private MenuEvent menuEvent;
    private int delay;
    protected WinListener popupListener;
    private Point menuLocation;
    static /* synthetic */ Class class$javax$swing$event$MenuListener;

    public JMenuItem add(JMenuItem jMenuItem) {
        return this.popupMenu.add(jMenuItem);
    }

    public Component add(Component component) {
        this.popupMenu.insert(component, -1);
        return component;
    }

    public Component add(Component component, int n) {
        return this.popupMenu.add(component, n);
    }

    public JMenuItem add(String string) {
        return this.popupMenu.add(string);
    }

    public JMenuItem add(Action action) {
        return this.popupMenu.add(action);
    }

    public void remove(JMenuItem jMenuItem) {
        this.popupMenu.remove(jMenuItem);
    }

    public void remove(int n) {
        this.popupMenu.remove(n);
    }

    public void remove(Component component) {
        int n = this.popupMenu.getComponentIndex(component);
        this.popupMenu.remove(n);
    }

    public void removeAll() {
        this.popupMenu.removeAll();
    }

    public void insert(String string, int n) {
        this.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero");
        }
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n) {
        JMenuItem jMenuItem = new JMenuItem(action);
        this.insert(jMenuItem, n);
        return jMenuItem;
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuUI";
    }

    public void setModel(ButtonModel buttonModel) {
        super.setModel(buttonModel);
    }

    public boolean isSelected() {
        return super.isSelected();
    }

    private final void setSelectedHelper(boolean bl, boolean bl2, boolean bl3) {
        if (bl && bl2) {
            super.setArmed(true);
            super.setSelected(true);
            if (this.isShowing()) {
                this.fireMenuSelected();
                int n = 0;
                int n2 = 0;
                if (bl3) {
                    if (this.menuLocation == null) {
                        if (this.isTopLevelMenu()) {
                            n2 = this.getHeight();
                        } else {
                            n = this.getWidth();
                        }
                        this.getPopupMenu().show(this, n, n2);
                    } else {
                        this.getPopupMenu().show(this, this.menuLocation.x, this.menuLocation.y);
                    }
                }
            }
        } else {
            super.setSelected(false);
            super.setArmed(false);
            this.fireMenuDeselected();
            this.popupMenu.setVisible(false);
        }
    }

    public void setSelected(boolean bl) {
        this.setSelectedHelper(bl, true, false);
    }

    public boolean isPopupMenuVisible() {
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean bl) {
        if (this.getModel().isEnabled()) {
            this.popupMenu.setVisible(bl);
        }
    }

    protected Point getPopupMenuOrigin() {
        if (this.isTopLevelMenu()) {
            return new Point(0, this.getHeight());
        }
        return new Point(this.getWidth(), 0);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("delay less than 0");
        }
        this.delay = n;
    }

    public void setMenuLocation(int n, int n2) {
        this.menuLocation = new Point(n, n2);
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        this.getPopupMenu().insert(new JPopupMenu.Separator(), n);
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        Component component = this.popupMenu.getComponentAtIndex(n);
        if (component instanceof JMenuItem) {
            return (JMenuItem)component;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        return false;
    }

    public int getMenuComponentCount() {
        return this.popupMenu.getComponentCount();
    }

    public Component getMenuComponent(int n) {
        return this.popupMenu.getComponentAtIndex(n);
    }

    public Component[] getMenuComponents() {
        return this.popupMenu.getComponents();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener menuListener) {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        this.listenerList.add(clazz, menuListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        this.listenerList.remove(clazz, menuListener);
    }

    public MenuListener[] getMenuListeners() {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        return (MenuListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireMenuSelected() {
        MenuListener[] menuListenerArray = this.getMenuListeners();
        int n = 0;
        while (n < menuListenerArray.length) {
            menuListenerArray[n].menuSelected(this.menuEvent);
            ++n;
        }
    }

    protected void fireMenuDeselected() {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        EventListener[] eventListenerArray = this.listenerList.getListeners(clazz);
        int n = 0;
        while (n < eventListenerArray.length) {
            ((MenuListener)eventListenerArray[n]).menuDeselected(this.menuEvent);
            ++n;
        }
    }

    protected void fireMenuCanceled() {
        Class clazz = class$javax$swing$event$MenuListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$MenuListener = JMenu.class("[Ljavax.swing.event.MenuListener;", false);
        }
        EventListener[] eventListenerArray = this.listenerList.getListeners(clazz);
        int n = 0;
        while (n < eventListenerArray.length) {
            ((MenuListener)eventListenerArray[n]).menuCanceled(this.menuEvent);
            ++n;
        }
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(jPopupMenu);
    }

    public void menuSelectionChanged(boolean bl) {
        this.setSelectedHelper(bl, this.isEnabled(), true);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[]{this.popupMenu};
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
    }

    public void doClick(int n) {
        this.getModel().setArmed(true);
        this.getModel().setPressed(true);
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
        this.getModel().setPressed(false);
        this.getModel().setArmed(false);
        this.popupMenu.show(this, this.getWidth(), 0);
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.popupMenu = new JPopupMenu();
        this.menuEvent = new MenuEvent(this);
    }

    public JMenu() {
        this.this();
        this.setOpaque(false);
    }

    public JMenu(String string) {
        super(string);
        this.this();
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
    }

    public JMenu(Action action) {
        super(action);
        this.this();
        this.createActionChangeListener(this);
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
    }

    public JMenu(String string, boolean bl) {
        this(string);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ActionChangedListener
    implements PropertyChangeListener {
        private JMenuItem menuItem;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public ActionChangedListener(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
            Action action = jMenuItem.getAction();
            if (action != null) {
                action.addPropertyChangeListener(this);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        private static final long serialVersionUID = -6415815570638474823L;

        public void windowClosing(WindowEvent windowEvent) {
            JMenu.this.setSelected(false);
        }

        public WinListener(JPopupMenu jPopupMenu) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        private static final long serialVersionUID = -8131864021059524309L;

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleSelection(int n) {
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public void addAccessibleSelection(int n) {
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }

        protected AccessibleJMenu() {
        }
    }
}

