/*
 * Decompiled with CFR 0.152.
 */
package javax.security.sasl;

import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class Sasl {
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    public static final String REUSE = "javax.security.sasl.reuse";
    private static final String CLIENT_FACTORY_SVC = "SaslClientFactory.";
    private static final String SERVER_FACTORY_SVC = "SaslServerFactory.";
    private static final String ALIAS = "Alg.Alias.";

    public static SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        if (stringArray == null) {
            return null;
        }
        Provider[] providerArray = Security.getProviders();
        if (providerArray == null || providerArray.length == 0) {
            return null;
        }
        SaslClient saslClient = null;
        SaslClientFactory saslClientFactory = null;
        String string4 = null;
        int n = 0;
        while (n < stringArray.length) {
            block12: {
                String string5 = stringArray[n];
                if (string5 == null) break block12;
                int n2 = 0;
                while (n2 < providerArray.length) {
                    block15: {
                        block13: {
                            block14: {
                                String string6;
                                Provider provider = providerArray[n2];
                                if (provider == null) break block13;
                                string4 = provider.getProperty(CLIENT_FACTORY_SVC + string5);
                                if (string4 != null || (string4 = provider.getProperty(CLIENT_FACTORY_SVC + (string6 = string5.toUpperCase()))) != null) break block14;
                                String string7 = provider.getProperty("Alg.Alias.SaslClientFactory." + string5);
                                if (string7 == null && (string7 = provider.getProperty("Alg.Alias.SaslClientFactory." + string6)) == null) break block15;
                                string4 = provider.getProperty(CLIENT_FACTORY_SVC + string7);
                            }
                            if (string4 == null) break block15;
                            string4 = string4.trim();
                        }
                        try {
                            saslClient = null;
                            saslClientFactory = (SaslClientFactory)Class.forName(string4).newInstance();
                            saslClient = saslClientFactory.createSaslClient(stringArray, string, string2, string3, map, callbackHandler);
                        }
                        catch (ClassCastException classCastException) {
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                        if (saslClient != null) {
                            return saslClient;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public static Enumeration getSaslClientFactories() {
        Object object;
        Iterator iterator;
        Object object2;
        Vector vector = new Vector();
        HashSet hashSet = new HashSet();
        Provider[] providerArray = Security.getProviders();
        if (providerArray != null) {
            int n = 0;
            while (n < providerArray.length) {
                object2 = providerArray[n];
                iterator = ((Hashtable)object2).keySet().iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (!((String)object).startsWith(CLIENT_FACTORY_SVC) || ((String)object).indexOf(" ") != -1) continue;
                    hashSet.add(((Properties)object2).getProperty((String)object));
                    break;
                }
                ++n;
            }
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            try {
                object = (SaslClientFactory)Class.forName((String)object2).newInstance();
                if (object == null) continue;
                vector.add(object);
            }
            catch (ClassCastException classCastException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return vector.elements();
    }

    public static SaslServer createSaslServer(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        if (string == null) {
            return null;
        }
        Provider[] providerArray = Security.getProviders();
        if (providerArray == null || providerArray.length == 0) {
            return null;
        }
        SaslServer saslServer = null;
        SaslServerFactory saslServerFactory = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        while (n < providerArray.length) {
            block14: {
                block13: {
                    Provider provider = providerArray[n];
                    if (provider == null || (string4 = provider.getProperty(SERVER_FACTORY_SVC + string)) != null) break block13;
                    String string6 = string.toUpperCase();
                    string4 = provider.getProperty(SERVER_FACTORY_SVC + string6);
                    if (string4 == null && (string5 = provider.getProperty("Alg.Alias.SaslServerFactory." + string)) == null && (string5 = provider.getProperty("Alg.Alias.SaslServerFactory." + string6)) == null) break block14;
                    string4 = provider.getProperty(SERVER_FACTORY_SVC + string5);
                }
                if (string4 != null) {
                    string4 = string4.trim();
                    try {
                        saslServer = null;
                        saslServerFactory = (SaslServerFactory)Class.forName(string4).newInstance();
                        saslServer = saslServerFactory.createSaslServer(string, string2, string3, map, callbackHandler);
                    }
                    catch (ClassCastException classCastException) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    if (saslServer != null) {
                        return saslServer;
                    }
                }
            }
            ++n;
        }
        return null;
    }

    public static Enumeration getSaslServerFactories() {
        Object object;
        Iterator iterator;
        Object object2;
        Vector vector = new Vector();
        HashSet hashSet = new HashSet();
        Provider[] providerArray = Security.getProviders();
        if (providerArray != null) {
            int n = 0;
            while (n < providerArray.length) {
                object2 = providerArray[n];
                iterator = ((Hashtable)object2).keySet().iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (!((String)object).startsWith(SERVER_FACTORY_SVC) || ((String)object).indexOf(" ") != -1) continue;
                    hashSet.add(((Properties)object2).getProperty((String)object));
                    break;
                }
                ++n;
            }
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            try {
                object = (SaslServerFactory)Class.forName((String)object2).newInstance();
                if (object == null) continue;
                vector.add(object);
            }
            catch (ClassCastException classCastException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return vector.elements();
    }

    private Sasl() {
    }
}

