/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GYearMonthType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            if (c == '-' && n4 == 0) {
                ++n3;
            } else if (c < '0' || c > '9') {
                if (n2 == 0 && c == '-') {
                    String string2 = string.substring(n3, n4);
                    if (string2.length() < 4 || Integer.parseInt(string2) == 0) {
                        throw new DatatypeException(n4, "illegal GYear value");
                    }
                    n2 = 1;
                    n3 = n4 + 1;
                } else {
                    throw new DatatypeException(n4, "illegal GYear value");
                }
            }
            ++n4;
        }
        switch (n2) {
            case 1: {
                if (n - n3 == 2) break;
                throw new DatatypeException("illegal GYear value");
            }
            default: {
                throw new DatatypeException("illegal GYear value");
            }
        }
    }

    public final Object createValue(String string, ValidationContext validationContext) {
        try {
            int n = 5;
            if (string.charAt(0) == '-') {
                ++n;
            }
            GYearMonth gYearMonth = new GYearMonth();
            gYearMonth.year = Integer.parseInt(string.substring(0, n));
            gYearMonth.month = Integer.parseInt(string.substring(n + 1));
            return gYearMonth;
        }
        catch (Exception exception) {
            return null;
        }
    }

    GYearMonthType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    static class GYearMonth
    implements Comparable {
        int year;
        int month;

        public int hashCode() {
            return this.year * 31 + this.month;
        }

        public boolean equals(Object object) {
            if (object instanceof GYearMonth) {
                GYearMonth gYearMonth = (GYearMonth)object;
                boolean bl = false;
                if (gYearMonth.year == this.year && gYearMonth.month == this.month) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof GYearMonth) {
                GYearMonth gYearMonth = (GYearMonth)object;
                if (gYearMonth.year == this.year) {
                    if (gYearMonth.month == this.month) {
                        return 0;
                    }
                    return this.month < gYearMonth.month ? -1 : 1;
                }
                return this.year < gYearMonth.year ? -1 : 1;
            }
            return 0;
        }

        GYearMonth() {
        }
    }
}

