/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.Big5;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.HKSCS_2001;

public class Big5_HKSCS
extends Charset
implements HistoricallyNamedCharset {
    public Big5_HKSCS() {
        super("Big5-HKSCS", ExtendedCharsets.aliasesFor("Big5-HKSCS"));
    }

    @Override
    public String historicalName() {
        return "Big5_HKSCS";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof Big5 || charset instanceof Big5_HKSCS;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends HKSCS_2001.Encoder {
        private Big5.Encoder big5Enc;

        @Override
        protected int encodeDouble(char c) {
            int n = super.encodeDouble(c);
            return n != 0 ? n : this.big5Enc.encodeDouble(c);
        }

        private Encoder(Charset charset) {
            super(charset);
            this.big5Enc = new Big5.Encoder(charset);
        }
    }

    private static class Decoder
    extends HKSCS_2001.Decoder {
        Big5.Decoder big5Dec;

        @Override
        protected char decodeDouble(int n, int n2) {
            char c = super.decodeDouble(n, n2);
            return c != '\ufffd' ? c : this.big5Dec.decodeDouble(n, n2);
        }

        private Decoder(Charset charset) {
            super(charset);
            this.big5Dec = new Big5.Decoder(charset);
        }
    }
}

