/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.Timestamper;

public class HttpTimestamper
implements Timestamper {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final boolean DEBUG = false;
    private String tsaUrl = null;

    public HttpTimestamper(String string) {
        this.tsaUrl = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSResponse generateTimestamp(TSRequest tSRequest) throws IOException {
        Object object;
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.tsaUrl).openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", TS_QUERY_MIME_TYPE);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.connect();
        try (DataOutputStream dataOutputStream = null;){
            dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            object = tSRequest.encode();
            dataOutputStream.write((byte[])object, 0, ((byte[])object).length);
            dataOutputStream.flush();
        }
        object = null;
        byte[] byArray = null;
        try {
            int n;
            object = new BufferedInputStream(httpURLConnection.getInputStream());
            HttpTimestamper.verifyMimeType(httpURLConnection.getContentType());
            int n2 = 0;
            int n3 = httpURLConnection.getContentLength();
            if (n3 != -1) {
                byArray = new byte[n3];
            } else {
                byArray = new byte[2048];
                n3 = Integer.MAX_VALUE;
            }
            while (n2 < n3 && (n = ((BufferedInputStream)object).read(byArray, n2, byArray.length - n2)) >= 0) {
                if ((n2 += n) < byArray.length || n2 >= n3) continue;
                byArray = Arrays.copyOf(byArray, n2 * 2);
            }
            byArray = Arrays.copyOf(byArray, n2);
        }
        finally {
            if (object != null) {
                ((BufferedInputStream)object).close();
            }
        }
        return new TSResponse(byArray);
    }

    private static void verifyMimeType(String string) throws IOException {
        if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(string)) {
            throw new IOException("MIME Content-Type is not application/timestamp-reply");
        }
    }
}

