/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOption;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import sun.nio.ch.Net;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.Util;

public class ServerSocketAdaptor
extends ServerSocket {
    private final ServerSocketChannelImpl ssc;
    private volatile int timeout = 0;

    public static ServerSocket create(ServerSocketChannelImpl serverSocketChannelImpl) {
        try {
            return new ServerSocketAdaptor(serverSocketChannelImpl);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private ServerSocketAdaptor(ServerSocketChannelImpl serverSocketChannelImpl) throws IOException {
        this.ssc = serverSocketChannelImpl;
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    @Override
    public void bind(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        try {
            this.ssc.bind(socketAddress, n);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (!this.ssc.isBound()) {
            return null;
        }
        return Net.asInetSocketAddress(this.ssc.localAddress()).getAddress();
    }

    @Override
    public int getLocalPort() {
        if (!this.ssc.isBound()) {
            return -1;
        }
        return Net.asInetSocketAddress(this.ssc.localAddress()).getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Socket accept() throws IOException {
        Object object = this.ssc.blockingLock();
        synchronized (object) {
            if (!this.ssc.isBound()) {
                throw new IllegalBlockingModeException();
            }
            try {
                if (this.timeout == 0) {
                    SocketChannel socketChannel = this.ssc.accept();
                    if (socketChannel == null && !this.ssc.isBlocking()) {
                        throw new IllegalBlockingModeException();
                    }
                    return socketChannel.socket();
                }
                SelectionKey selectionKey = null;
                Selector selector = null;
                this.ssc.configureBlocking(false);
                try {
                    long l;
                    SocketChannel socketChannel = this.ssc.accept();
                    if (socketChannel != null) {
                        Socket socket = socketChannel.socket();
                        return socket;
                    }
                    selector = Util.getTemporarySelector(this.ssc);
                    selectionKey = this.ssc.register(selector, 16);
                    long l2 = this.timeout;
                    do {
                        if (!this.ssc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        l = System.currentTimeMillis();
                        int n = selector.select(l2);
                        if (n > 0 && selectionKey.isAcceptable() && (socketChannel = this.ssc.accept()) != null) {
                            Socket socket = socketChannel.socket();
                            return socket;
                        }
                        selector.selectedKeys().remove(selectionKey);
                    } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                    throw new SocketTimeoutException();
                }
                finally {
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (this.ssc.isOpen()) {
                        this.ssc.configureBlocking(true);
                    }
                    if (selector != null) {
                        Util.releaseTemporarySelector(selector);
                    }
                }
            }
            catch (Exception exception) {
                Net.translateException(exception);
                assert (false);
                return null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.ssc.close();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.ssc;
    }

    @Override
    public boolean isBound() {
        return this.ssc.isBound();
    }

    @Override
    public boolean isClosed() {
        return !this.ssc.isOpen();
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        this.timeout = n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        try {
            this.ssc.setOption((SocketOption)StandardSocketOption.SO_REUSEADDR, (Object)bl);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOption.SO_REUSEADDR);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return false;
        }
    }

    @Override
    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("size cannot be 0 or negative");
        }
        try {
            this.ssc.setOption((SocketOption)StandardSocketOption.SO_RCVBUF, (Object)n);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.ssc.getOption(StandardSocketOption.SO_RCVBUF);
        }
        catch (IOException iOException) {
            Net.translateToSocketException(iOException);
            return -1;
        }
    }
}

