/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SQLOutputImpl;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import javax.sql.rowset.serial.SerialRef;

public class SerialStruct
implements Struct,
Serializable,
Cloneable {
    private String SQLTypeName;
    private Object[] attribs;
    static final long serialVersionUID = -8322445504027483372L;

    public SerialStruct(Struct struct, Map<String, Class<?>> map) throws SerialException {
        try {
            this.SQLTypeName = new String(struct.getSQLTypeName());
            System.out.println("SQLTypeName: " + this.SQLTypeName);
            this.attribs = struct.getAttributes(map);
            this.mapToSerial(map);
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }

    public SerialStruct(SQLData sQLData, Map<String, Class<?>> map) throws SerialException {
        try {
            this.SQLTypeName = new String(sQLData.getSQLTypeName());
            Vector vector = new Vector();
            sQLData.writeSQL(new SQLOutputImpl(vector, map));
            this.attribs = vector.toArray();
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }

    @Override
    public String getSQLTypeName() throws SerialException {
        return this.SQLTypeName;
    }

    @Override
    public Object[] getAttributes() throws SerialException {
        return this.attribs;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SerialException {
        return this.attribs;
    }

    private void mapToSerial(Map map) throws SerialException {
        try {
            for (int i = 0; i < this.attribs.length; ++i) {
                if (this.attribs[i] instanceof Struct) {
                    this.attribs[i] = new SerialStruct((Struct)this.attribs[i], map);
                    continue;
                }
                if (this.attribs[i] instanceof SQLData) {
                    this.attribs[i] = new SerialStruct((SQLData)this.attribs[i], map);
                    continue;
                }
                if (this.attribs[i] instanceof Blob) {
                    this.attribs[i] = new SerialBlob((Blob)this.attribs[i]);
                    continue;
                }
                if (this.attribs[i] instanceof Clob) {
                    this.attribs[i] = new SerialClob((Clob)this.attribs[i]);
                    continue;
                }
                if (this.attribs[i] instanceof Ref) {
                    this.attribs[i] = new SerialRef((Ref)this.attribs[i]);
                    continue;
                }
                if (!(this.attribs[i] instanceof Array)) continue;
                this.attribs[i] = new SerialArray((Array)this.attribs[i], map);
            }
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }
}

