/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import sun.misc.Unsafe;

public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private volatile transient Node<E> head = new Node<Object>(null);
    private volatile transient Node<E> tail = this.head;
    private static final int HOPS = 1;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long headOffset = ConcurrentLinkedQueue.objectFieldOffset(UNSAFE, "head", ConcurrentLinkedQueue.class);
    private static final long tailOffset = ConcurrentLinkedQueue.objectFieldOffset(UNSAFE, "tail", ConcurrentLinkedQueue.class);

    public ConcurrentLinkedQueue() {
    }

    public ConcurrentLinkedQueue(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    final void updateHead(Node<E> node, Node<E> node2) {
        if (node != node2 && this.casHead(node, node2)) {
            node.lazySetNext(node);
        }
    }

    final Node<E> succ(Node<E> node) {
        Node<E> node2 = node.getNext();
        return node == node2 ? this.head : node2;
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        block0: while (true) {
            Node node2;
            Node node3 = node2 = this.tail;
            int n = 0;
            while (true) {
                Node<E> node4;
                if ((node4 = this.succ(node3)) != null) {
                    if (n > 1 && node2 != this.tail) continue block0;
                    node3 = node4;
                } else {
                    if (node3.casNext(null, node)) {
                        if (n >= 1) {
                            this.casTail(node2, node);
                        }
                        return true;
                    }
                    node3 = this.succ(node3);
                }
                ++n;
            }
            break;
        }
    }

    @Override
    public E poll() {
        Node<E> node;
        Node<E> node2 = node = this.head;
        int n = 0;
        while (true) {
            Node<E> node3;
            E e;
            if ((e = node2.getItem()) != null && node2.casItem(e, null)) {
                if (n >= 1) {
                    node3 = node2.getNext();
                    this.updateHead(node, node3 != null ? node3 : node2);
                }
                return e;
            }
            node3 = this.succ(node2);
            if (node3 == null) break;
            node2 = node3;
            ++n;
        }
        this.updateHead(node, node2);
        return null;
    }

    @Override
    public E peek() {
        Node<E> node;
        E e;
        Node<E> node2;
        Node<E> node3 = node2 = this.head;
        while ((e = node3.getItem()) == null && (node = this.succ(node3)) != null) {
            node3 = node;
        }
        this.updateHead(node2, node3);
        return e;
    }

    Node<E> first() {
        Node<E> node;
        Node<E> node2;
        Node<E> node3 = node2 = this.head;
        while (true) {
            E e;
            if ((e = node3.getItem()) != null) {
                node = node3;
                break;
            }
            Node<E> node4 = this.succ(node3);
            if (node4 == null) {
                node = null;
                break;
            }
            node3 = node4;
        }
        this.updateHead(node2, node3);
        return node;
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int n = 0;
        Node<E> node = this.first();
        while (node != null && (node.getItem() == null || ++n != Integer.MAX_VALUE)) {
            node = this.succ(node);
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Node<E> node = this.first();
        while (node != null) {
            E e = node.getItem();
            if (e != null && object.equals(e)) {
                return true;
            }
            node = this.succ(node);
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Node<E> node = null;
        Node<E> node2 = this.first();
        while (node2 != null) {
            E e = node2.getItem();
            if (e != null && object.equals(e) && node2.casItem(e, null)) {
                Node<E> node3 = this.succ(node2);
                if (node != null && node3 != null) {
                    node.casNext(node2, node3);
                }
                return true;
            }
            node = node2;
            node2 = this.succ(node2);
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> arrayList = new ArrayList<E>();
        Node<E> node = this.first();
        while (node != null) {
            E e = node.getItem();
            if (e != null) {
                arrayList.add(e);
            }
            node = this.succ(node);
        }
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        ArrayList arrayList;
        int n = 0;
        Node<E> node = this.first();
        while (node != null && n < TArray.length) {
            arrayList = node.getItem();
            if (arrayList != null) {
                TArray[n++] = arrayList;
            }
            node = this.succ(node);
        }
        if (node == null) {
            if (n < TArray.length) {
                TArray[n] = null;
            }
            return TArray;
        }
        arrayList = new ArrayList();
        Node<E> node2 = this.first();
        while (node2 != null) {
            E e = node2.getItem();
            if (e != null) {
                arrayList.add(e);
            }
            node2 = this.succ(node2);
        }
        return arrayList.toArray(TArray);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node<E> node = this.first();
        while (node != null) {
            E e = node.getItem();
            if (e != null) {
                objectOutputStream.writeObject(e);
            }
            node = this.succ(node);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.head = new Node<Object>(null);
        this.tail = this.head;
        while ((object = objectInputStream.readObject()) != null) {
            this.offer(object);
        }
    }

    private boolean casTail(Node<E> node, Node<E> node2) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, node, node2);
    }

    private boolean casHead(Node<E> node, Node<E> node2) {
        return UNSAFE.compareAndSwapObject(this, headOffset, node, node2);
    }

    private void lazySetHead(Node<E> node) {
        UNSAFE.putOrderedObject(this, headOffset, node);
    }

    static long objectFieldOffset(Unsafe unsafe, String string, Class<?> clazz) {
        try {
            return unsafe.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            this.advance();
        }

        private E advance() {
            Node node;
            Node node2;
            this.lastRet = this.nextNode;
            Object e = this.nextItem;
            if (this.nextNode == null) {
                node2 = ConcurrentLinkedQueue.this.first();
                node = null;
            } else {
                node = this.nextNode;
                node2 = ConcurrentLinkedQueue.this.succ(this.nextNode);
            }
            while (true) {
                if (node2 == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return e;
                }
                Object e2 = node2.getItem();
                if (e2 != null) {
                    this.nextNode = node2;
                    this.nextItem = e2;
                    return e;
                }
                Node node3 = ConcurrentLinkedQueue.this.succ(node2);
                if (node != null && node3 != null) {
                    node.casNext(node2, node3);
                }
                node2 = node3;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node<Object> node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            node.setItem(null);
            this.lastRet = null;
        }
    }

    private static class Node<E> {
        private volatile E item;
        private volatile Node<E> next;
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final long nextOffset = ConcurrentLinkedQueue.objectFieldOffset(UNSAFE, "next", Node.class);
        private static final long itemOffset = ConcurrentLinkedQueue.objectFieldOffset(UNSAFE, "item", Node.class);

        Node(E e) {
            this.lazySetItem(e);
        }

        E getItem() {
            return this.item;
        }

        boolean casItem(E e, E e2) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, e, e2);
        }

        void setItem(E e) {
            this.item = e;
        }

        void lazySetItem(E e) {
            UNSAFE.putOrderedObject(this, itemOffset, e);
        }

        void lazySetNext(Node<E> node) {
            UNSAFE.putOrderedObject(this, nextOffset, node);
        }

        Node<E> getNext() {
            return this.next;
        }

        boolean casNext(Node<E> node, Node<E> node2) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, node, node2);
        }
    }
}

