/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.CompletionHandler;
import java.nio.channels.MulticastChannel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class AsynchronousDatagramChannel
implements AsynchronousByteChannel,
MulticastChannel {
    private final AsynchronousChannelProvider provider;

    protected AsynchronousDatagramChannel(AsynchronousChannelProvider asynchronousChannelProvider) {
        this.provider = asynchronousChannelProvider;
    }

    public final AsynchronousChannelProvider provider() {
        return this.provider;
    }

    public static AsynchronousDatagramChannel open(ProtocolFamily protocolFamily, AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        AsynchronousChannelProvider asynchronousChannelProvider = asynchronousChannelGroup == null ? AsynchronousChannelProvider.provider() : asynchronousChannelGroup.provider();
        return asynchronousChannelProvider.openAsynchronousDatagramChannel(protocolFamily, asynchronousChannelGroup);
    }

    public static AsynchronousDatagramChannel open() throws IOException {
        return AsynchronousDatagramChannel.open(null, null);
    }

    @Override
    public abstract AsynchronousDatagramChannel bind(SocketAddress var1) throws IOException;

    @Override
    public abstract <T> AsynchronousDatagramChannel setOption(SocketOption<T> var1, T var2) throws IOException;

    public abstract SocketAddress getRemoteAddress() throws IOException;

    public abstract AsynchronousDatagramChannel connect(SocketAddress var1) throws IOException;

    public abstract AsynchronousDatagramChannel disconnect() throws IOException;

    public abstract <A> void receive(ByteBuffer var1, long var2, TimeUnit var4, A var5, CompletionHandler<SocketAddress, ? super A> var6);

    public final <A> void receive(ByteBuffer byteBuffer, A a, CompletionHandler<SocketAddress, ? super A> completionHandler) {
        this.receive(byteBuffer, 0L, TimeUnit.MILLISECONDS, a, completionHandler);
    }

    public abstract Future<SocketAddress> receive(ByteBuffer var1);

    public abstract <A> void send(ByteBuffer var1, SocketAddress var2, A var3, CompletionHandler<Integer, ? super A> var4);

    public abstract Future<Integer> send(ByteBuffer var1, SocketAddress var2);

    public abstract <A> void read(ByteBuffer var1, long var2, TimeUnit var4, A var5, CompletionHandler<Integer, ? super A> var6);

    @Override
    public final <A> void read(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.read(byteBuffer, 0L, TimeUnit.MILLISECONDS, a, completionHandler);
    }

    @Override
    public abstract Future<Integer> read(ByteBuffer var1);

    @Override
    public abstract <A> void write(ByteBuffer var1, A var2, CompletionHandler<Integer, ? super A> var3);

    @Override
    public abstract Future<Integer> write(ByteBuffer var1);
}

