/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.writers;

import com.sun.org.apache.xerces.internal.impl.PropertyManager;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.xml.internal.stream.util.ReadOnlyIterator;
import com.sun.xml.internal.stream.writers.UTF8OutputStreamWriter;
import com.sun.xml.internal.stream.writers.XMLWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamResult;

public final class XMLStreamWriterImpl
extends AbstractMap
implements XMLStreamWriter {
    public static final String START_COMMENT = "<!--";
    public static final String END_COMMENT = "-->";
    public static final String DEFAULT_ENCODING = " encoding=\"utf-8\"";
    public static final String DEFAULT_XMLDECL = "<?xml version=\"1.0\" ?>";
    public static final String DEFAULT_XML_VERSION = "1.0";
    public static final char CLOSE_START_TAG = '>';
    public static final char OPEN_START_TAG = '<';
    public static final String OPEN_END_TAG = "</";
    public static final char CLOSE_END_TAG = '>';
    public static final String START_CDATA = "<![CDATA[";
    public static final String END_CDATA = "]]>";
    public static final String CLOSE_EMPTY_ELEMENT = "/>";
    public static final String SPACE = " ";
    public static final String UTF_8 = "UTF-8";
    public static final String OUTPUTSTREAM_PROPERTY = "sjsxp-outputstream";
    boolean fEscapeCharacters = true;
    private boolean fIsRepairingNamespace = false;
    private Writer fWriter;
    private OutputStream fOutputStream = null;
    private ArrayList fAttributeCache;
    private ArrayList fNamespaceDecls;
    private NamespaceContextImpl fNamespaceContext = null;
    private NamespaceSupport fInternalNamespaceContext = null;
    private Random fPrefixGen = null;
    private PropertyManager fPropertyManager = null;
    private boolean fStartTagOpened = false;
    private boolean fReuse;
    private SymbolTable fSymbolTable = new SymbolTable();
    private ElementStack fElementStack = new ElementStack();
    private final String DEFAULT_PREFIX = this.fSymbolTable.addSymbol("");
    private final ReadOnlyIterator fReadOnlyIterator = new ReadOnlyIterator();
    private CharsetEncoder fEncoder = null;

    public XMLStreamWriterImpl(OutputStream outputStream, PropertyManager props) throws IOException {
        this(new OutputStreamWriter(outputStream), props);
    }

    public XMLStreamWriterImpl(OutputStream outputStream, String encoding, PropertyManager props) throws IOException {
        this(new StreamResult(outputStream), encoding, props);
    }

    public XMLStreamWriterImpl(Writer writer, PropertyManager props) throws IOException {
        this(new StreamResult(writer), null, props);
    }

    public XMLStreamWriterImpl(StreamResult sr, String encoding, PropertyManager props) throws IOException {
        this.setOutput(sr, encoding);
        this.fPropertyManager = props;
        this.init();
    }

    private void init() {
        this.fReuse = false;
        this.fNamespaceDecls = new ArrayList();
        this.fPrefixGen = new Random();
        this.fAttributeCache = new ArrayList();
        this.fInternalNamespaceContext = new NamespaceSupport();
        this.fNamespaceContext = new NamespaceContextImpl();
        this.fNamespaceContext.internalContext = this.fInternalNamespaceContext;
        Boolean ob = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isRepairingNamespaces");
        this.fIsRepairingNamespace = ob;
        ob = (Boolean)this.fPropertyManager.getProperty("escapeCharacters");
        this.setEscapeCharacters(ob);
    }

    public void reset() {
        this.reset(false);
    }

    void reset(boolean resetProperties) {
        if (!this.fReuse) {
            throw new IllegalStateException("close() Must be called before calling reset()");
        }
        this.fReuse = false;
        this.fNamespaceDecls.clear();
        this.fAttributeCache.clear();
        this.fElementStack.clear();
        this.fInternalNamespaceContext.reset();
        this.fStartTagOpened = false;
        this.fNamespaceContext.userContext = null;
        if (resetProperties) {
            Boolean ob = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isRepairingNamespaces");
            this.fIsRepairingNamespace = ob;
            ob = (Boolean)this.fPropertyManager.getProperty("escapeCharacters");
            this.setEscapeCharacters(ob);
        }
    }

    public void setOutput(StreamResult sr, String encoding) throws IOException {
        if (sr.getOutputStream() != null) {
            this.setOutputUsingStream(sr.getOutputStream(), encoding);
        } else if (sr.getWriter() != null) {
            this.setOutputUsingWriter(sr.getWriter());
        } else if (sr.getSystemId() != null) {
            this.setOutputUsingStream(new FileOutputStream(sr.getSystemId()), encoding);
        }
    }

    private void setOutputUsingWriter(Writer writer) throws IOException {
        String charset;
        this.fWriter = writer;
        if (writer instanceof OutputStreamWriter && (charset = ((OutputStreamWriter)writer).getEncoding()) != null && !charset.equalsIgnoreCase("utf-8")) {
            this.fEncoder = Charset.forName(charset).newEncoder();
        }
    }

    private void setOutputUsingStream(OutputStream os, String encoding) throws IOException {
        this.fOutputStream = os;
        if (encoding != null) {
            if (encoding.equalsIgnoreCase("utf-8")) {
                this.fWriter = new UTF8OutputStreamWriter(os);
            } else {
                this.fWriter = new XMLWriter(new OutputStreamWriter(os, encoding));
                this.fEncoder = Charset.forName(encoding).newEncoder();
            }
        } else {
            encoding = System.getProperty("file.encoding");
            this.fWriter = encoding != null && encoding.equalsIgnoreCase("utf-8") ? new UTF8OutputStreamWriter(os) : new XMLWriter(new OutputStreamWriter(os));
        }
    }

    public boolean canReuse() {
        return this.fReuse;
    }

    public void setEscapeCharacters(boolean escape) {
        this.fEscapeCharacters = escape;
    }

    public boolean getEscapeCharacters() {
        return this.fEscapeCharacters;
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.fWriter != null) {
            try {
                this.fWriter.flush();
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }
        this.fWriter = null;
        this.fOutputStream = null;
        this.fNamespaceDecls.clear();
        this.fAttributeCache.clear();
        this.fElementStack.clear();
        this.fInternalNamespaceContext.reset();
        this.fReuse = true;
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.fWriter.flush();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.fNamespaceContext.getPrefix(uri);
    }

    @Override
    public Object getProperty(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new NullPointerException();
        }
        if (!this.fPropertyManager.containsProperty(str)) {
            throw new IllegalArgumentException("Property '" + str + "' is not supported");
        }
        return this.fPropertyManager.getProperty(str);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        if (uri != null) {
            uri = this.fSymbolTable.addSymbol(uri);
        }
        if (this.fIsRepairingNamespace) {
            if (this.isDefaultNamespace(uri)) {
                return;
            }
            QName qname = new QName();
            qname.setValues(this.DEFAULT_PREFIX, "xmlns", null, uri);
            this.fNamespaceDecls.add(qname);
        } else {
            this.fInternalNamespaceContext.declarePrefix(this.DEFAULT_PREFIX, uri);
        }
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fNamespaceContext.userContext = namespaceContext;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new XMLStreamException("Prefix cannot be null");
        }
        if (uri == null) {
            throw new XMLStreamException("URI cannot be null");
        }
        prefix = this.fSymbolTable.addSymbol(prefix);
        uri = this.fSymbolTable.addSymbol(uri);
        if (this.fIsRepairingNamespace) {
            String tmpURI = this.fInternalNamespaceContext.getURI(prefix);
            if (tmpURI != null && tmpURI == uri) {
                return;
            }
            if (this.checkUserNamespaceContext(prefix, uri)) {
                return;
            }
            QName qname = new QName();
            qname.setValues(prefix, "xmlns", null, uri);
            this.fNamespaceDecls.add(qname);
            return;
        }
        this.fInternalNamespaceContext.declarePrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (this.fIsRepairingNamespace) {
                Attribute attr = new Attribute(value);
                attr.setValues(null, localName, null, null);
                this.fAttributeCache.add(attr);
                return;
            }
            this.fWriter.write(SPACE);
            this.fWriter.write(localName);
            this.fWriter.write("=\"");
            this.writeXMLContent(value, true, true);
            this.fWriter.write("\"");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
            String prefix = this.fInternalNamespaceContext.getPrefix(namespaceURI);
            if (!this.fIsRepairingNamespace) {
                if (prefix == null) {
                    throw new XMLStreamException("Prefix cannot be null");
                }
                this.writeAttributeWithPrefix(prefix, localName, value);
            } else {
                Attribute attr = new Attribute(value);
                attr.setValues(null, localName, null, namespaceURI);
                this.fAttributeCache.add(attr);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void writeAttributeWithPrefix(String prefix, String localName, String value) throws IOException {
        this.fWriter.write(SPACE);
        if (prefix != null && prefix != "") {
            this.fWriter.write(prefix);
            this.fWriter.write(":");
        }
        this.fWriter.write(localName);
        this.fWriter.write("=\"");
        this.writeXMLContent(value, true, true);
        this.fWriter.write("\"");
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (localName == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (!this.fIsRepairingNamespace) {
                if (prefix == null || prefix.equals("")) {
                    if (!namespaceURI.equals("")) {
                        throw new XMLStreamException("prefix cannot be null or empty");
                    }
                    this.writeAttributeWithPrefix(null, localName, value);
                    return;
                }
                if (!prefix.equals("xml") || !namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                    String tmpURI;
                    prefix = this.fSymbolTable.addSymbol(prefix);
                    namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
                    if (this.fInternalNamespaceContext.containsPrefixInCurrentContext(prefix) && (tmpURI = this.fInternalNamespaceContext.getURI(prefix)) != null && tmpURI != namespaceURI) {
                        throw new XMLStreamException("Prefix " + prefix + " is " + "already bound to " + tmpURI + ". Trying to rebind it to " + namespaceURI + " is an error.");
                    }
                    this.fInternalNamespaceContext.declarePrefix(prefix, namespaceURI);
                }
                this.writeAttributeWithPrefix(prefix, localName, value);
            } else {
                if (prefix != null) {
                    prefix = this.fSymbolTable.addSymbol(prefix);
                }
                namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
                Attribute attr = new Attribute(value);
                attr.setValues(prefix, localName, null, namespaceURI);
                this.fAttributeCache.add(attr);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeCData(String cdata) throws XMLStreamException {
        try {
            if (cdata == null) {
                throw new XMLStreamException("cdata cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(START_CDATA);
            this.fWriter.write(cdata);
            this.fWriter.write(END_CDATA);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeCharacters(String data) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.writeXMLContent(data);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeCharacters(char[] data, int start, int len) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.writeXMLContent(data, start, len, this.fEscapeCharacters);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeComment(String comment) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(START_COMMENT);
            if (comment != null) {
                this.fWriter.write(comment);
            }
            this.fWriter.write(END_COMMENT);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(dtd);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        String namespaceURINormalized = null;
        namespaceURINormalized = namespaceURI == null ? "" : namespaceURI;
        try {
            String tmp;
            if (!this.fStartTagOpened) {
                throw new IllegalStateException("Namespace Attribute not associated with any element");
            }
            if (this.fIsRepairingNamespace) {
                QName qname = new QName();
                qname.setValues("", "xmlns", null, namespaceURINormalized);
                this.fNamespaceDecls.add(qname);
                return;
            }
            namespaceURINormalized = this.fSymbolTable.addSymbol(namespaceURINormalized);
            if (this.fInternalNamespaceContext.containsPrefixInCurrentContext("") && (tmp = this.fInternalNamespaceContext.getURI("")) != null && tmp != namespaceURINormalized) {
                throw new XMLStreamException("xmlns has been already bound to " + tmp + ". Rebinding it to " + namespaceURINormalized + " is an error");
            }
            this.fInternalNamespaceContext.declarePrefix("", namespaceURINormalized);
            this.writenamespace(null, namespaceURINormalized);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(null, localName, null, null, true);
            this.fInternalNamespaceContext.pushContext();
            if (!this.fIsRepairingNamespace) {
                this.fWriter.write(localName);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
        String prefix = this.fNamespaceContext.getPrefix(namespaceURI);
        this.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        try {
            if (localName == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (prefix != null) {
                prefix = this.fSymbolTable.addSymbol(prefix);
            }
            namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(prefix, localName, null, namespaceURI, true);
            this.fInternalNamespaceContext.pushContext();
            if (!this.fIsRepairingNamespace) {
                if (prefix == null) {
                    throw new XMLStreamException("NamespaceURI " + namespaceURI + " has not been bound to any prefix");
                }
            } else {
                return;
            }
            if (prefix != null && prefix != "") {
                this.fWriter.write(prefix);
                this.fWriter.write(":");
            }
            this.fWriter.write(localName);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            ElementState elem = null;
            while (!this.fElementStack.empty()) {
                elem = this.fElementStack.pop();
                this.fInternalNamespaceContext.popContext();
                if (elem.isEmpty) continue;
                this.fWriter.write(OPEN_END_TAG);
                if (elem.prefix != null && !elem.prefix.equals("")) {
                    this.fWriter.write(elem.prefix);
                    this.fWriter.write(":");
                }
                this.fWriter.write(elem.localpart);
                this.fWriter.write(62);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XMLStreamException("No more elements to write");
        }
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        try {
            ElementState currentElement;
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if ((currentElement = this.fElementStack.pop()) == null) {
                throw new XMLStreamException("No element was found to write");
            }
            if (currentElement.isEmpty) {
                return;
            }
            this.fWriter.write(OPEN_END_TAG);
            if (currentElement.prefix != null && !currentElement.prefix.equals("")) {
                this.fWriter.write(currentElement.prefix);
                this.fWriter.write(":");
            }
            this.fWriter.write(currentElement.localpart);
            this.fWriter.write(62);
            this.fInternalNamespaceContext.popContext();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XMLStreamException("No element was found to write: " + e.toString(), e);
        }
    }

    @Override
    public void writeEntityRef(String refName) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(38);
            this.fWriter.write(refName);
            this.fWriter.write(59);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        String namespaceURINormalized = null;
        namespaceURINormalized = namespaceURI == null ? "" : namespaceURI;
        try {
            String tmp;
            QName qname = null;
            if (!this.fStartTagOpened) {
                throw new IllegalStateException("Invalid state: start tag is not opened at writeNamespace(" + prefix + ", " + namespaceURINormalized + ")");
            }
            if (prefix == null || prefix.equals("") || prefix.equals("xmlns")) {
                this.writeDefaultNamespace(namespaceURINormalized);
                return;
            }
            if (prefix.equals("xml") && namespaceURINormalized.equals("http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            prefix = this.fSymbolTable.addSymbol(prefix);
            namespaceURINormalized = this.fSymbolTable.addSymbol(namespaceURINormalized);
            if (this.fIsRepairingNamespace) {
                String tmpURI = this.fInternalNamespaceContext.getURI(prefix);
                if (tmpURI != null && tmpURI == namespaceURINormalized) {
                    return;
                }
                qname = new QName();
                qname.setValues(prefix, "xmlns", null, namespaceURINormalized);
                this.fNamespaceDecls.add(qname);
                return;
            }
            if (this.fInternalNamespaceContext.containsPrefixInCurrentContext(prefix) && (tmp = this.fInternalNamespaceContext.getURI(prefix)) != null && tmp != namespaceURINormalized) {
                throw new XMLStreamException("prefix " + prefix + " has been already bound to " + tmp + ". Rebinding it to " + namespaceURINormalized + " is an error");
            }
            this.fInternalNamespaceContext.declarePrefix(prefix, namespaceURINormalized);
            this.writenamespace(prefix, namespaceURINormalized);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void writenamespace(String prefix, String namespaceURI) throws IOException {
        this.fWriter.write(" xmlns");
        if (prefix != null && prefix != "") {
            this.fWriter.write(":");
            this.fWriter.write(prefix);
        }
        this.fWriter.write("=\"");
        this.writeXMLContent(namespaceURI, true, true);
        this.fWriter.write("\"");
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if (target != null) {
                this.fWriter.write("<?");
                this.fWriter.write(target);
                this.fWriter.write("?>");
                return;
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        throw new XMLStreamException("PI target cannot be null");
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if (target == null || data == null) {
                throw new XMLStreamException("PI target cannot be null");
            }
            this.fWriter.write("<?");
            this.fWriter.write(target);
            this.fWriter.write(SPACE);
            this.fWriter.write(data);
            this.fWriter.write("?>");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        try {
            this.fWriter.write(DEFAULT_XMLDECL);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        try {
            if (version == null || version.equals("")) {
                this.writeStartDocument();
                return;
            }
            this.fWriter.write("<?xml version=\"");
            this.fWriter.write(version);
            this.fWriter.write("\"");
            this.fWriter.write("?>");
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        try {
            if (encoding == null && version == null) {
                this.writeStartDocument();
                return;
            }
            if (encoding == null) {
                this.writeStartDocument(version);
                return;
            }
            String streamEncoding = null;
            if (this.fWriter instanceof OutputStreamWriter) {
                streamEncoding = ((OutputStreamWriter)this.fWriter).getEncoding();
            } else if (this.fWriter instanceof UTF8OutputStreamWriter) {
                streamEncoding = ((UTF8OutputStreamWriter)this.fWriter).getEncoding();
            } else if (this.fWriter instanceof XMLWriter) {
                streamEncoding = ((OutputStreamWriter)((XMLWriter)this.fWriter).getWriter()).getEncoding();
            }
            if (streamEncoding != null && !streamEncoding.equalsIgnoreCase(encoding)) {
                boolean foundAlias = false;
                Set<String> aliases = Charset.forName(encoding).aliases();
                Iterator<String> it = aliases.iterator();
                while (!foundAlias && it.hasNext()) {
                    if (!streamEncoding.equalsIgnoreCase(it.next())) continue;
                    foundAlias = true;
                }
                if (!foundAlias) {
                    throw new XMLStreamException("Underlying stream encoding '" + streamEncoding + "' and input paramter for writeStartDocument() method '" + encoding + "' do not match.");
                }
            }
            this.fWriter.write("<?xml version=\"");
            if (version == null || version.equals("")) {
                this.fWriter.write(DEFAULT_XML_VERSION);
            } else {
                this.fWriter.write(version);
            }
            if (!encoding.equals("")) {
                this.fWriter.write("\" encoding=\"");
                this.fWriter.write(encoding);
            }
            this.fWriter.write("\"?>");
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        try {
            if (localName == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(null, localName, null, null, false);
            this.fInternalNamespaceContext.pushContext();
            if (this.fIsRepairingNamespace) {
                return;
            }
            this.fWriter.write(localName);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (localName == null) {
            throw new XMLStreamException("Local Name cannot be null");
        }
        if (namespaceURI == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
        String prefix = null;
        if (!this.fIsRepairingNamespace && (prefix = this.fNamespaceContext.getPrefix(namespaceURI)) != null) {
            prefix = this.fSymbolTable.addSymbol(prefix);
        }
        this.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        try {
            if (localName == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (namespaceURI == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (!this.fIsRepairingNamespace && prefix == null) {
                throw new XMLStreamException("Prefix cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            namespaceURI = this.fSymbolTable.addSymbol(namespaceURI);
            if (prefix != null) {
                prefix = this.fSymbolTable.addSymbol(prefix);
            }
            this.fElementStack.push(prefix, localName, null, namespaceURI, false);
            this.fInternalNamespaceContext.pushContext();
            String tmpPrefix = this.fNamespaceContext.getPrefix(namespaceURI);
            if (!(prefix == null || tmpPrefix != null && prefix.equals(tmpPrefix))) {
                this.fInternalNamespaceContext.declarePrefix(prefix, namespaceURI);
            }
            if (this.fIsRepairingNamespace) {
                if (prefix == null || tmpPrefix != null && prefix.equals(tmpPrefix)) {
                    return;
                }
                QName qname = new QName();
                qname.setValues(prefix, "xmlns", null, namespaceURI);
                this.fNamespaceDecls.add(qname);
                return;
            }
            if (prefix != null && prefix != "") {
                this.fWriter.write(prefix);
                this.fWriter.write(":");
            }
            this.fWriter.write(localName);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    private void writeXMLContent(char[] content, int start, int length, boolean escapeChars) throws IOException {
        if (!escapeChars) {
            this.fWriter.write(content, start, length);
            return;
        }
        int startWritePos = start;
        int end = start + length;
        block5: for (int index = start; index < end; ++index) {
            char ch = content[index];
            if (this.fEncoder != null && !this.fEncoder.canEncode(ch)) {
                this.fWriter.write(content, startWritePos, index - startWritePos);
                this.fWriter.write("&#x");
                this.fWriter.write(Integer.toHexString(ch));
                this.fWriter.write(59);
                startWritePos = index + 1;
                continue;
            }
            switch (ch) {
                case '<': {
                    this.fWriter.write(content, startWritePos, index - startWritePos);
                    this.fWriter.write("&lt;");
                    startWritePos = index + 1;
                    continue block5;
                }
                case '&': {
                    this.fWriter.write(content, startWritePos, index - startWritePos);
                    this.fWriter.write("&amp;");
                    startWritePos = index + 1;
                    continue block5;
                }
                case '>': {
                    this.fWriter.write(content, startWritePos, index - startWritePos);
                    this.fWriter.write("&gt;");
                    startWritePos = index + 1;
                }
            }
        }
        this.fWriter.write(content, startWritePos, end - startWritePos);
    }

    private void writeXMLContent(String content) throws IOException {
        if (content != null && content.length() > 0) {
            this.writeXMLContent(content, this.fEscapeCharacters, false);
        }
    }

    private void writeXMLContent(String content, boolean escapeChars, boolean escapeDoubleQuotes) throws IOException {
        if (!escapeChars) {
            this.fWriter.write(content);
            return;
        }
        int startWritePos = 0;
        int end = content.length();
        block6: for (int index = 0; index < end; ++index) {
            char ch = content.charAt(index);
            if (this.fEncoder != null && !this.fEncoder.canEncode(ch)) {
                this.fWriter.write(content, startWritePos, index - startWritePos);
                this.fWriter.write("&#x");
                this.fWriter.write(Integer.toHexString(ch));
                this.fWriter.write(59);
                startWritePos = index + 1;
                continue;
            }
            switch (ch) {
                case '<': {
                    this.fWriter.write(content, startWritePos, index - startWritePos);
                    this.fWriter.write("&lt;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '&': {
                    this.fWriter.write(content, startWritePos, index - startWritePos);
                    this.fWriter.write("&amp;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '>': {
                    this.fWriter.write(content, startWritePos, index - startWritePos);
                    this.fWriter.write("&gt;");
                    startWritePos = index + 1;
                    continue block6;
                }
                case '\"': {
                    this.fWriter.write(content, startWritePos, index - startWritePos);
                    if (escapeDoubleQuotes) {
                        this.fWriter.write("&quot;");
                    } else {
                        this.fWriter.write(34);
                    }
                    startWritePos = index + 1;
                }
            }
        }
        this.fWriter.write(content, startWritePos, end - startWritePos);
    }

    private void closeStartTag() throws XMLStreamException {
        try {
            ElementState currentElement = this.fElementStack.peek();
            if (this.fIsRepairingNamespace) {
                this.repair();
                this.correctPrefix(currentElement);
                if (currentElement.prefix != null && currentElement.prefix != "") {
                    this.fWriter.write(currentElement.prefix);
                    this.fWriter.write(":");
                }
                this.fWriter.write(currentElement.localpart);
                int len = this.fNamespaceDecls.size();
                QName qname = null;
                for (int i = 0; i < len; ++i) {
                    qname = (QName)this.fNamespaceDecls.get(i);
                    if (qname == null || !this.fInternalNamespaceContext.declarePrefix(qname.prefix, qname.uri)) continue;
                    this.writenamespace(qname.prefix, qname.uri);
                }
                this.fNamespaceDecls.clear();
                Attribute attr = null;
                for (int j = 0; j < this.fAttributeCache.size(); ++j) {
                    String tmp;
                    attr = (Attribute)this.fAttributeCache.get(j);
                    if (!(attr.prefix == null || attr.uri == null || attr.prefix.equals("") || attr.uri.equals("") || (tmp = this.fInternalNamespaceContext.getPrefix(attr.uri)) != null && tmp == attr.prefix || !this.fInternalNamespaceContext.declarePrefix(attr.prefix, attr.uri))) {
                        this.writenamespace(attr.prefix, attr.uri);
                    }
                    this.writeAttributeWithPrefix(attr.prefix, attr.localpart, attr.value);
                }
                this.fAttributeCache.clear();
            }
            if (currentElement.isEmpty) {
                this.fElementStack.pop();
                this.fInternalNamespaceContext.popContext();
                this.fWriter.write(CLOSE_EMPTY_ELEMENT);
            } else {
                this.fWriter.write(62);
            }
            this.fStartTagOpened = false;
        }
        catch (IOException ex) {
            this.fStartTagOpened = false;
            throw new XMLStreamException(ex);
        }
    }

    private void openStartTag() throws IOException {
        this.fStartTagOpened = true;
        this.fWriter.write(60);
    }

    private void correctPrefix(QName attr) {
        String tmpPrefix = null;
        String prefix = attr.prefix;
        String uri = attr.uri;
        if (prefix == null || prefix.equals("")) {
            if (uri == null) {
                return;
            }
            if (prefix == "" && uri == "") {
                return;
            }
            uri = this.fSymbolTable.addSymbol(uri);
            QName decl = null;
            for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
                decl = (QName)this.fNamespaceDecls.get(i);
                if (decl == null || decl.uri != attr.uri) continue;
                attr.prefix = decl.prefix;
                return;
            }
            tmpPrefix = this.fNamespaceContext.getPrefix(uri);
            if (tmpPrefix == "") {
                return;
            }
            if (tmpPrefix == null) {
                StringBuffer genPrefix = new StringBuffer("zdef");
                for (int i = 0; i < 1; ++i) {
                    genPrefix.append(this.fPrefixGen.nextInt());
                }
                prefix = genPrefix.toString();
                prefix = this.fSymbolTable.addSymbol(prefix);
            } else {
                prefix = this.fSymbolTable.addSymbol(tmpPrefix);
            }
            if (tmpPrefix == null) {
                QName qname = new QName();
                qname.setValues(prefix, "xmlns", null, uri);
                this.fNamespaceDecls.add(qname);
                this.fInternalNamespaceContext.declarePrefix(this.fSymbolTable.addSymbol(prefix), uri);
            }
        }
        attr.prefix = prefix;
    }

    private boolean isDefaultNamespace(String uri) {
        String defaultNamespace = this.fInternalNamespaceContext.getURI(this.DEFAULT_PREFIX);
        return uri == defaultNamespace;
    }

    private boolean checkUserNamespaceContext(String prefix, String uri) {
        String tmpURI;
        return this.fNamespaceContext.userContext != null && (tmpURI = this.fNamespaceContext.userContext.getNamespaceURI(prefix)) != null && tmpURI.equals(uri);
    }

    protected void repair() {
        int i;
        Attribute attr = null;
        Attribute attr2 = null;
        ElementState currentElement = this.fElementStack.peek();
        this.removeDuplicateDecls();
        for (i = 0; i < this.fAttributeCache.size(); ++i) {
            attr = (Attribute)this.fAttributeCache.get(i);
            if ((attr.prefix == null || attr.prefix.equals("")) && (attr.uri == null || attr.uri.equals(""))) continue;
            this.correctPrefix(currentElement, attr);
        }
        if (!(this.isDeclared(currentElement) || currentElement.prefix == null || currentElement.uri == null || currentElement.prefix.equals("") || currentElement.uri.equals(""))) {
            this.fNamespaceDecls.add(currentElement);
        }
        for (i = 0; i < this.fAttributeCache.size(); ++i) {
            attr = (Attribute)this.fAttributeCache.get(i);
            for (int j = i + 1; j < this.fAttributeCache.size(); ++j) {
                attr2 = (Attribute)this.fAttributeCache.get(j);
                if ("".equals(attr.prefix) || "".equals(attr2.prefix)) continue;
                this.correctPrefix(attr, attr2);
            }
        }
        this.repairNamespaceDecl(currentElement);
        i = 0;
        for (i = 0; i < this.fAttributeCache.size(); ++i) {
            attr = (Attribute)this.fAttributeCache.get(i);
            if (attr.prefix == null || !attr.prefix.equals("") || attr.uri == null || !attr.uri.equals("")) continue;
            this.repairNamespaceDecl(attr);
        }
        QName qname = null;
        for (i = 0; i < this.fNamespaceDecls.size(); ++i) {
            qname = (QName)this.fNamespaceDecls.get(i);
            if (qname == null) continue;
            this.fInternalNamespaceContext.declarePrefix(qname.prefix, qname.uri);
        }
        for (i = 0; i < this.fAttributeCache.size(); ++i) {
            attr = (Attribute)this.fAttributeCache.get(i);
            this.correctPrefix(attr);
        }
    }

    void correctPrefix(QName attr1, QName attr2) {
        String tmpPrefix = null;
        QName decl = null;
        boolean done = false;
        this.checkForNull(attr1);
        this.checkForNull(attr2);
        if (attr1.prefix.equals(attr2.prefix) && !attr1.uri.equals(attr2.uri)) {
            tmpPrefix = this.fNamespaceContext.getPrefix(attr2.uri);
            if (tmpPrefix != null) {
                attr2.prefix = this.fSymbolTable.addSymbol(tmpPrefix);
            } else {
                decl = null;
                for (int n = 0; n < this.fNamespaceDecls.size(); ++n) {
                    decl = (QName)this.fNamespaceDecls.get(n);
                    if (decl == null || decl.uri != attr2.uri) continue;
                    attr2.prefix = decl.prefix;
                    return;
                }
                StringBuffer genPrefix = new StringBuffer("zdef");
                for (int k = 0; k < 1; ++k) {
                    genPrefix.append(this.fPrefixGen.nextInt());
                }
                tmpPrefix = genPrefix.toString();
                attr2.prefix = tmpPrefix = this.fSymbolTable.addSymbol(tmpPrefix);
                QName qname = new QName();
                qname.setValues(tmpPrefix, "xmlns", null, attr2.uri);
                this.fNamespaceDecls.add(qname);
            }
        }
    }

    void checkForNull(QName attr) {
        if (attr.prefix == null) {
            attr.prefix = "";
        }
        if (attr.uri == null) {
            attr.uri = "";
        }
    }

    void removeDuplicateDecls() {
        for (int i = 0; i < this.fNamespaceDecls.size(); ++i) {
            QName decl1 = (QName)this.fNamespaceDecls.get(i);
            if (decl1 == null) continue;
            for (int j = i + 1; j < this.fNamespaceDecls.size(); ++j) {
                QName decl2 = (QName)this.fNamespaceDecls.get(j);
                if (decl2 == null || !decl1.prefix.equals(decl2.prefix) || !decl1.uri.equals(decl2.uri)) continue;
                this.fNamespaceDecls.remove(j);
            }
        }
    }

    void repairNamespaceDecl(QName attr) {
        QName decl = null;
        for (int j = 0; j < this.fNamespaceDecls.size(); ++j) {
            String tmpURI;
            decl = (QName)this.fNamespaceDecls.get(j);
            if (decl == null || attr.prefix == null || !attr.prefix.equals(decl.prefix) || attr.uri.equals(decl.uri) || (tmpURI = this.fNamespaceContext.getNamespaceURI(attr.prefix)) == null) continue;
            if (tmpURI.equals(attr.uri)) {
                this.fNamespaceDecls.set(j, null);
                continue;
            }
            decl.uri = attr.uri;
        }
    }

    boolean isDeclared(QName attr) {
        QName decl = null;
        for (int n = 0; n < this.fNamespaceDecls.size(); ++n) {
            decl = (QName)this.fNamespaceDecls.get(n);
            if (attr.prefix == null || attr.prefix != decl.prefix || decl.uri != attr.uri) continue;
            return true;
        }
        return attr.uri != null && this.fNamespaceContext.getPrefix(attr.uri) != null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return key.equals(OUTPUTSTREAM_PROPERTY);
    }

    @Override
    public Object get(Object key) {
        if (key.equals(OUTPUTSTREAM_PROPERTY)) {
            return this.fOutputStream;
        }
        return null;
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    class NamespaceContextImpl
    implements NamespaceContext {
        NamespaceContext userContext = null;
        NamespaceSupport internalContext = null;

        NamespaceContextImpl() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String uri = null;
            if (prefix != null) {
                prefix = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(prefix);
            }
            if (this.internalContext != null && (uri = this.internalContext.getURI(prefix)) != null) {
                return uri;
            }
            if (this.userContext != null) {
                uri = this.userContext.getNamespaceURI(prefix);
                return uri;
            }
            return null;
        }

        @Override
        public String getPrefix(String uri) {
            String prefix = null;
            if (uri != null) {
                uri = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(uri);
            }
            if (this.internalContext != null && (prefix = this.internalContext.getPrefix(uri)) != null) {
                return prefix;
            }
            if (this.userContext != null) {
                return this.userContext.getPrefix(uri);
            }
            return null;
        }

        @Override
        public Iterator getPrefixes(String uri) {
            Vector prefixes = null;
            Iterator itr = null;
            if (uri != null) {
                uri = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(uri);
            }
            if (this.userContext != null) {
                itr = this.userContext.getPrefixes(uri);
            }
            if (this.internalContext != null) {
                prefixes = this.internalContext.getPrefixes(uri);
            }
            if (prefixes == null && itr != null) {
                return itr;
            }
            if (prefixes != null && itr == null) {
                return new ReadOnlyIterator(prefixes.iterator());
            }
            if (prefixes != null && itr != null) {
                String ob = null;
                while (itr.hasNext()) {
                    ob = (String)itr.next();
                    if (ob != null) {
                        ob = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(ob);
                    }
                    if (prefixes.contains(ob)) continue;
                    prefixes.add(ob);
                }
                return new ReadOnlyIterator(prefixes.iterator());
            }
            return XMLStreamWriterImpl.this.fReadOnlyIterator;
        }
    }

    class Attribute
    extends QName {
        String value;

        Attribute(String value) {
            this.value = value;
        }
    }

    class ElementState
    extends QName {
        public boolean isEmpty;

        public ElementState() {
            this.isEmpty = false;
        }

        public ElementState(String prefix, String localpart, String rawname, String uri) {
            super(prefix, localpart, rawname, uri);
            this.isEmpty = false;
        }

        public void setValues(String prefix, String localpart, String rawname, String uri, boolean isEmpty) {
            super.setValues(prefix, localpart, rawname, uri);
            this.isEmpty = isEmpty;
        }
    }

    protected class ElementStack {
        protected ElementState[] fElements = new ElementState[10];
        protected short fDepth;

        public ElementStack() {
            for (int i = 0; i < this.fElements.length; ++i) {
                this.fElements[i] = new ElementState();
            }
        }

        public ElementState push(ElementState element) {
            if (this.fDepth == this.fElements.length) {
                ElementState[] array = new ElementState[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, array, 0, this.fDepth);
                this.fElements = array;
                for (int i = this.fDepth; i < this.fElements.length; ++i) {
                    this.fElements[i] = new ElementState();
                }
            }
            this.fElements[this.fDepth].setValues(element);
            short s = this.fDepth;
            this.fDepth = (short)(s + 1);
            return this.fElements[s];
        }

        public ElementState push(String prefix, String localpart, String rawname, String uri, boolean isEmpty) {
            if (this.fDepth == this.fElements.length) {
                ElementState[] array = new ElementState[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, array, 0, this.fDepth);
                this.fElements = array;
                for (int i = this.fDepth; i < this.fElements.length; ++i) {
                    this.fElements[i] = new ElementState();
                }
            }
            this.fElements[this.fDepth].setValues(prefix, localpart, rawname, uri, isEmpty);
            short s = this.fDepth;
            this.fDepth = (short)(s + 1);
            return this.fElements[s];
        }

        public ElementState pop() {
            this.fDepth = (short)(this.fDepth - 1);
            return this.fElements[this.fDepth];
        }

        public void clear() {
            this.fDepth = 0;
        }

        public ElementState peek() {
            return this.fElements[this.fDepth - 1];
        }

        public boolean empty() {
            return this.fDepth <= 0;
        }
    }
}

