/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class WindowGeometry {
    private Point topLeft;
    private Dimension extent;

    public static WindowGeometry centerOnScreen(Dimension extent) {
        Point topLeft = new Point(Math.max(0, (Toolkit.getDefaultToolkit().getScreenSize().width - extent.width) / 2), Math.max(0, (Toolkit.getDefaultToolkit().getScreenSize().height - extent.height) / 2));
        return new WindowGeometry(topLeft, extent);
    }

    public static WindowGeometry centerInWindow(Component reference, Dimension extent) {
        Window parentWindow = null;
        while (reference != null && !(reference instanceof Window)) {
            reference = reference.getParent();
        }
        if (reference == null) {
            return new WindowGeometry(new Point(0, 0), extent);
        }
        parentWindow = (Window)reference;
        Point topLeft = new Point(Math.max(0, (parentWindow.getSize().width - extent.width) / 2), Math.max(0, (parentWindow.getSize().height - extent.height) / 2));
        topLeft.x += parentWindow.getLocation().x;
        topLeft.y += parentWindow.getLocation().y;
        return new WindowGeometry(topLeft, extent);
    }

    public WindowGeometry(Point topLeft, Dimension extent) {
        this.topLeft = topLeft;
        this.extent = extent;
    }

    public WindowGeometry(Window window) {
        this(window.getLocationOnScreen(), window.getSize());
    }

    protected int parseField(String preferenceKey, String preferenceValue, String field) throws WindowGeometryException {
        String v = "";
        try {
            Pattern p = Pattern.compile(field + "=(\\d+)", 2);
            Matcher m = p.matcher(preferenceValue);
            if (!m.find()) {
                throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not include ''{1}''. Cannot restore window geometry from preferences.", preferenceKey, field));
            }
            v = m.group(1);
            return Integer.parseInt(v);
        }
        catch (WindowGeometryException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not provide an int value for ''{1}''. Got {2}. Cannot restore window geometry from preferences.", preferenceKey, field, v));
        }
        catch (Exception e) {
            throw new WindowGeometryException(I18n.tr("Failed to parse field ''{1}'' in preference with key ''{0}''. Exception was: {2}. Cannot restore window geometry from preferences.", preferenceKey, field, e.toString()), e);
        }
    }

    protected void initFromPreferences(String preferenceKey) throws WindowGeometryException {
        String value = Main.pref.get(preferenceKey);
        if (value == null || value.equals("")) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not exist. Cannot restore window geometry from preferences.", preferenceKey));
        }
        this.topLeft = new Point();
        this.extent = new Dimension();
        this.topLeft.x = this.parseField(preferenceKey, value, "x");
        this.topLeft.y = this.parseField(preferenceKey, value, "y");
        this.extent.width = this.parseField(preferenceKey, value, "width");
        this.extent.height = this.parseField(preferenceKey, value, "height");
    }

    protected void initFromWindowGeometry(WindowGeometry other) {
        this.topLeft = other.topLeft;
        this.extent = other.extent;
    }

    public WindowGeometry(String preferenceKey) throws WindowGeometryException {
        this.initFromPreferences(preferenceKey);
    }

    public WindowGeometry(String preferenceKey, WindowGeometry defaultGeometry) {
        try {
            this.initFromPreferences(preferenceKey);
        }
        catch (WindowGeometryException e) {
            this.initFromWindowGeometry(defaultGeometry);
        }
    }

    public void remember(String preferenceKey) {
        StringBuffer value = new StringBuffer();
        value.append("x=").append(this.topLeft.x).append(",").append("y=").append(this.topLeft.y).append(",").append("width=").append(this.extent.width).append(",").append("height=").append(this.extent.height);
        Main.pref.put(preferenceKey, value.toString());
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public Dimension getSize() {
        return this.extent;
    }

    public void apply(Window window) {
        window.setLocation(this.topLeft);
        window.setSize(this.extent);
    }

    public void applySafe(Window window) {
        Point p = new Point(this.topLeft);
        if (p.x > Toolkit.getDefaultToolkit().getScreenSize().width - 10) {
            p.x = 0;
        }
        if (p.y > Toolkit.getDefaultToolkit().getScreenSize().height - 10) {
            p.y = 0;
        }
        window.setLocation(p);
        window.setSize(this.extent);
    }

    public static class WindowGeometryException
    extends Exception {
        public WindowGeometryException(String message, Throwable cause) {
            super(message, cause);
        }

        public WindowGeometryException(String message) {
            super(message);
        }
    }
}

