/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;

public class I18n {
    private static PluralMode pluralMode = PluralMode.MODE_NOTONE;
    private static final String[] jFileChooserLocalizationKeys = new String[]{"FileChooser.detailsViewActionLabelText", "FileChooser.detailsViewButtonAccessibleName", "FileChooser.detailsViewButtonToolTipText", "FileChooser.fileAttrHeaderText", "FileChooser.fileDateHeaderText", "FileChooser.fileNameHeaderText", "FileChooser.fileNameLabelText", "FileChooser.fileSizeHeaderText", "FileChooser.fileTypeHeaderText", "FileChooser.filesOfTypeLabelText", "FileChooser.homeFolderAccessibleName", "FileChooser.homeFolderToolTipText", "FileChooser.listViewActionLabelText", "FileChooser.listViewButtonAccessibleName", "FileChooser.listViewButtonToolTipText", "FileChooser.lookInLabelText", "FileChooser.newFolderAccessibleName", "FileChooser.newFolderActionLabelText", "FileChooser.newFolderToolTipText", "FileChooser.refreshActionLabelText", "FileChooser.saveInLabelText", "FileChooser.upFolderAccessibleName", "FileChooser.upFolderToolTipText", "FileChooser.viewMenuLabelText", "FileChooser.acceptAllFileFilterText", "FileChooser.cancelButtonText", "FileChooser.cancelButtonToolTipText", "FileChooser.deleteFileButtonText", "FileChooser.filesLabelText", "FileChooser.filterLabelText", "FileChooser.foldersLabelText", "FileChooser.newFolderButtonText", "FileChooser.newFolderDialogText", "FileChooser.openButtonText", "FileChooser.openButtonToolTipText", "FileChooser.openDialogTitleText", "FileChooser.pathLabelText", "FileChooser.renameFileButtonText", "FileChooser.renameFileDialogText", "FileChooser.renameFileErrorText", "FileChooser.renameFileErrorTitle", "FileChooser.saveButtonText", "FileChooser.saveButtonToolTipText", "FileChooser.saveDialogTitleText", "FileChooser.enterFileNameLabelText", "FileChooser.helpButtonText", "FileChooser.helpButtonToolTipText", "FileChooser.updateButtonText", "FileChooser.updateButtonToolTipText", "GTKColorChooserPanel.blueText", "GTKColorChooserPanel.colorNameText", "GTKColorChooserPanel.greenText", "GTKColorChooserPanel.hueText", "GTKColorChooserPanel.nameText", "GTKColorChooserPanel.redText", "GTKColorChooserPanel.saturationText", "GTKColorChooserPanel.valueText"};
    private static HashMap<String, String> strings = null;
    private static HashMap<String, String[]> pstrings = null;
    private static HashMap<String, PluralMode> languages = new HashMap();

    public static final String tr(String text, Object ... objects) {
        return MessageFormat.format(I18n.gettext(text, null), objects);
    }

    public static final String tr(String text) {
        if (text == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettext(text, null), new Object[]{null});
    }

    public static final String trc(String ctx, String text) {
        return MessageFormat.format(I18n.gettext(text, ctx), new Object[]{null});
    }

    public static final String marktr(String text) {
        return text;
    }

    public static final String marktrc(String context, String text) {
        return text;
    }

    public static final String trn(String text, String pluralText, long n, Object ... objects) {
        return MessageFormat.format(I18n.gettextn(text, pluralText, null, n), objects);
    }

    public static final String trn(String text, String pluralText, long n) {
        return MessageFormat.format(I18n.gettextn(text, pluralText, null, n), new Object[]{null});
    }

    public static final String trnc(String ctx, String text, String pluralText, long n, Object ... objects) {
        return MessageFormat.format(I18n.gettextn(text, pluralText, ctx, n), objects);
    }

    public static final String trnc(String ctx, String text, String pluralText, long n) {
        return MessageFormat.format(I18n.gettextn(text, pluralText, ctx, n), new Object[]{null});
    }

    private static final String gettext(String text, String ctx) {
        String[] trans;
        int i;
        if (ctx == null && text.startsWith("_:") && (i = text.indexOf("\n")) >= 0) {
            ctx = text.substring(2, i - 1);
            text = text.substring(i + 1);
        }
        if (strings != null && (trans = strings.get(ctx == null ? text : "_:" + ctx + "\n" + text)) != null) {
            return trans;
        }
        if (pstrings != null && (trans = pstrings.get(ctx == null ? text : "_:" + ctx + "\n" + text)) != null) {
            return trans[0];
        }
        return text;
    }

    private static final String gettextn(String text, String plural, String ctx, long num) {
        int i;
        if (ctx == null && text.startsWith("_:") && (i = text.indexOf("\n")) >= 0) {
            ctx = text.substring(2, i - 1);
            text = text.substring(i + 1);
        }
        if (pstrings != null) {
            i = I18n.pluralEval(num);
            String[] trans = pstrings.get(ctx == null ? text : "_:" + ctx + "\n" + text);
            if (trans != null && trans.length > i) {
                return trans[i];
            }
        }
        return num == 1L ? text : plural;
    }

    public static final Locale[] getAvailableTranslations() {
        Vector<Locale> v = new Vector<Locale>();
        if (Main.class.getResource("/data/en.lang") != null) {
            for (String loc : languages.keySet()) {
                if (Main.class.getResource("/data/" + loc + ".lang") == null) continue;
                int i = loc.indexOf(95);
                if (i > 0) {
                    v.add(new Locale(loc.substring(0, i), loc.substring(i + 1)));
                    continue;
                }
                v.add(new Locale(loc));
            }
        }
        v.add(Locale.ENGLISH);
        Locale[] l = new Locale[v.size()];
        l = v.toArray(l);
        Arrays.sort(l, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return l;
    }

    public static void init() {
        languages.put("ar", PluralMode.MODE_AR);
        languages.put("bg", PluralMode.MODE_NOTONE);
        languages.put("cs", PluralMode.MODE_CS);
        languages.put("da", PluralMode.MODE_NOTONE);
        languages.put("de", PluralMode.MODE_NOTONE);
        languages.put("el", PluralMode.MODE_NOTONE);
        languages.put("en_AU", PluralMode.MODE_NOTONE);
        languages.put("en_GB", PluralMode.MODE_NOTONE);
        languages.put("es", PluralMode.MODE_NOTONE);
        languages.put("et", PluralMode.MODE_NOTONE);
        languages.put("eu", PluralMode.MODE_NOTONE);
        languages.put("fi", PluralMode.MODE_NOTONE);
        languages.put("fr", PluralMode.MODE_GREATERONE);
        languages.put("gl", PluralMode.MODE_NOTONE);
        languages.put("is", PluralMode.MODE_NOTONE);
        languages.put("it", PluralMode.MODE_NOTONE);
        languages.put("iw_IL", PluralMode.MODE_NOTONE);
        languages.put("ja", PluralMode.MODE_NONE);
        languages.put("nb", PluralMode.MODE_NOTONE);
        languages.put("nl", PluralMode.MODE_NOTONE);
        languages.put("pl", PluralMode.MODE_PL);
        languages.put("pt_BR", PluralMode.MODE_GREATERONE);
        languages.put("ro", PluralMode.MODE_RO);
        languages.put("ru", PluralMode.MODE_RU);
        languages.put("sk", PluralMode.MODE_SK);
        languages.put("sl", PluralMode.MODE_SL);
        languages.put("sv", PluralMode.MODE_NOTONE);
        languages.put("tr", PluralMode.MODE_NONE);
        languages.put("uk", PluralMode.MODE_RU);
        languages.put("zh_TW", PluralMode.MODE_NONE);
        if (!I18n.load(Locale.getDefault().toString())) {
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    private static boolean load(String l) {
        if (l.equals("en") || l.equals("en_US")) {
            strings = null;
            pstrings = null;
            pluralMode = PluralMode.MODE_NOTONE;
            return true;
        }
        URL en = Main.class.getResource("/data/en.lang");
        if (en == null) {
            return false;
        }
        URL tr = Main.class.getResource("/data/" + l + ".lang");
        if (tr == null) {
            int i = l.indexOf(95);
            if (i > 0) {
                l = l.substring(0, i);
            }
            if ((tr = Main.class.getResource("/data/" + l + ".lang")) == null) {
                return false;
            }
        }
        HashMap<String, String> s = new HashMap<String, String>();
        HashMap<String, String[]> p = new HashMap<String, String[]>();
        try {
            BufferedInputStream ens = new BufferedInputStream(en.openStream());
            BufferedInputStream trs = new BufferedInputStream(tr.openStream());
            byte[] enlen = new byte[2];
            byte[] trlen = new byte[2];
            boolean multimode = false;
            byte[] str = new byte[4096];
            while (true) {
                if (multimode) {
                    int ennum = ((InputStream)ens).read();
                    int trnum = ((InputStream)trs).read();
                    if (ennum == -1 && trnum != -1 || ennum != -1 && trnum == -1) {
                        return false;
                    }
                    if (ennum != -1) {
                        int rval;
                        int val;
                        int i;
                        String[] enstrings = new String[ennum];
                        String[] trstrings = new String[trnum];
                        for (i = 0; i < ennum; ++i) {
                            val = ((InputStream)ens).read(enlen);
                            if (val != 2) {
                                return false;
                            }
                            val = (enlen[0] < 0 ? 256 + enlen[0] : enlen[0]) * 256 + (enlen[1] < 0 ? 256 + enlen[1] : enlen[1]);
                            if (val > str.length) {
                                str = new byte[val];
                            }
                            if ((rval = ((InputStream)ens).read(str, 0, val)) != val) {
                                return false;
                            }
                            enstrings[i] = new String(str, 0, val, "utf-8");
                        }
                        for (i = 0; i < trnum; ++i) {
                            val = ((InputStream)trs).read(trlen);
                            if (val != 2) {
                                return false;
                            }
                            val = (trlen[0] < 0 ? 256 + trlen[0] : trlen[0]) * 256 + (trlen[1] < 0 ? 256 + trlen[1] : trlen[1]);
                            if (val > str.length) {
                                str = new byte[val];
                            }
                            if ((rval = ((InputStream)trs).read(str, 0, val)) != val) {
                                return false;
                            }
                            trstrings[i] = new String(str, 0, val, "utf-8");
                        }
                        if (trnum <= 0) continue;
                        p.put(enstrings[0], trstrings);
                        continue;
                    }
                } else {
                    int trval;
                    int enval = ((InputStream)ens).read(enlen);
                    if (enval != (trval = ((InputStream)trs).read(trlen))) {
                        return false;
                    }
                    if (enval != -1) {
                        int val;
                        if (enval != 2) {
                            return false;
                        }
                        enval = (enlen[0] < 0 ? 256 + enlen[0] : enlen[0]) * 256 + (enlen[1] < 0 ? 256 + enlen[1] : enlen[1]);
                        trval = (trlen[0] < 0 ? 256 + trlen[0] : trlen[0]) * 256 + (trlen[1] < 0 ? 256 + trlen[1] : trlen[1]);
                        if (enval == 65535) {
                            multimode = true;
                            if (trval == 65535) continue;
                            return false;
                        }
                        if (enval > str.length) {
                            str = new byte[enval];
                        }
                        if (trval > str.length) {
                            str = new byte[trval];
                        }
                        if ((val = ((InputStream)ens).read(str, 0, enval)) != enval) {
                            return false;
                        }
                        String enstr = new String(str, 0, enval, "utf-8");
                        if (trval == 0) continue;
                        val = ((InputStream)trs).read(str, 0, trval);
                        if (val != trval) {
                            return false;
                        }
                        String trstr = new String(str, 0, trval, "utf-8");
                        s.put(enstr, trstr);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (!s.isEmpty() && languages.containsKey(l)) {
            strings = s;
            pstrings = p;
            pluralMode = languages.get(l);
            return true;
        }
        return false;
    }

    public static void set(String localeName) {
        if (localeName != null) {
            int i;
            if (localeName.equals("he")) {
                localeName = "iw_IL";
            }
            Locale l = (i = localeName.indexOf(95)) > 0 ? new Locale(localeName.substring(0, i), localeName.substring(i + 1)) : new Locale(localeName);
            if (I18n.load(localeName)) {
                Locale.setDefault(l);
            } else if (!l.getLanguage().equals("en")) {
                System.out.println(I18n.tr("Unable to find translation for the locale {0}. Reverting to {1}.", l.getDisplayName(), Locale.getDefault().getDisplayName()));
            } else {
                strings = null;
                pstrings = null;
            }
        }
    }

    public static void fixJFileChooser() {
        Locale l = Locale.getDefault();
        JFileChooser.setDefaultLocale(l);
        JColorChooser.setDefaultLocale(l);
        for (String key : jFileChooserLocalizationKeys) {
            String us = UIManager.getString((Object)key, Locale.US);
            String loc = UIManager.getString((Object)key, l);
            if (us == null || !us.equals(loc)) continue;
            UIManager.put(key, I18n.tr(us));
        }
    }

    private static int pluralEval(long n) {
        switch (pluralMode) {
            case MODE_NOTONE: {
                return n != 1L ? 1 : 0;
            }
            case MODE_NONE: {
                return 0;
            }
            case MODE_GREATERONE: {
                return n > 1L ? 1 : 0;
            }
            case MODE_CS: {
                return n == 1L ? 0 : (n >= 2L && n <= 4L ? 1 : 2);
            }
            case MODE_AR: {
                return n == 0L ? 0 : (n == 1L ? 1 : (n == 2L ? 2 : (n % 100L >= 3L && n % 100L <= 10L ? 3 : (n % 100L >= 11L && n % 100L <= 99L ? 4 : 5))));
            }
            case MODE_PL: {
                return n == 1L ? 0 : (n % 10L >= 2L && n % 10L <= 4L && (n % 100L < 10L || n % 100L >= 20L) ? 1 : 2);
            }
            case MODE_RO: {
                return n == 1L ? 0 : (n % 100L > 19L || n % 100L == 0L && n != 0L ? 2 : 1);
            }
            case MODE_RU: {
                return n % 10L == 1L && n % 100L != 11L ? 0 : (n % 10L >= 2L && n % 10L <= 4L && (n % 100L < 10L || n % 100L >= 20L) ? 1 : 2);
            }
            case MODE_SK: {
                return n == 1L ? 1 : (n >= 2L && n <= 4L ? 2 : 0);
            }
            case MODE_SL: {
                return n % 100L == 1L ? 1 : (n % 100L == 2L ? 2 : (n % 100L == 3L || n % 100L == 4L ? 3 : 0));
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PluralMode {
        MODE_NOTONE,
        MODE_NONE,
        MODE_GREATERONE,
        MODE_CS,
        MODE_AR,
        MODE_PL,
        MODE_RO,
        MODE_RU,
        MODE_SK,
        MODE_SL;

    }
}

