/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GpxReader {
    public GpxData data;
    private InputSource inputSource;

    public GpxReader(InputStream source) throws IOException {
        this.inputSource = new InputSource(UTFInputStreamReader.create(source, "UTF-8"));
    }

    public boolean parse(boolean tryToFinish) throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newSAXParser().parse(this.inputSource, (DefaultHandler)parser);
            return true;
        }
        catch (SAXException e) {
            if (tryToFinish) {
                parser.tryToFinish();
                if (parser.currentData.isEmpty()) {
                    throw e;
                }
                return false;
            }
            throw e;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        private GpxData currentData;
        private Collection<Collection<WayPoint>> currentTrack;
        private Map<String, Object> currentTrackAttr;
        private Collection<WayPoint> currentTrackSeg;
        private GpxRoute currentRoute;
        private WayPoint currentWayPoint;
        private State currentState = State.init;
        private GpxLink currentLink;
        private Stack<State> states;
        private final Stack<String> elements = new Stack();
        private StringBuffer accumulator = new StringBuffer();
        private boolean nokiaSportsTrackerBug = false;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuffer();
            this.states = new Stack();
            this.currentData = new GpxData();
        }

        private double parseCoord(String s) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                return Double.NaN;
            }
        }

        private LatLon parseLatLon(Attributes atts) {
            return new LatLon(this.parseCoord(atts.getValue("lat")), this.parseCoord(atts.getValue("lon")));
        }

        @Override
        public void startElement(String namespaceURI, String qName, String rqName, Attributes atts) throws SAXException {
            this.elements.push(qName);
            switch (this.currentState) {
                case init: {
                    if (qName.equals("metadata")) {
                        this.states.push(this.currentState);
                        this.currentState = State.metadata;
                        break;
                    }
                    if (qName.equals("wpt")) {
                        this.states.push(this.currentState);
                        this.currentState = State.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(atts));
                        break;
                    }
                    if (qName.equals("rte")) {
                        this.states.push(this.currentState);
                        this.currentState = State.rte;
                        this.currentRoute = new GpxRoute();
                        break;
                    }
                    if (qName.equals("trk")) {
                        this.states.push(this.currentState);
                        this.currentState = State.trk;
                        this.currentTrack = new ArrayList<Collection<WayPoint>>();
                        this.currentTrackAttr = new HashMap<String, Object>();
                        break;
                    }
                    if (qName.equals("extensions")) {
                        this.states.push(this.currentState);
                        this.currentState = State.ext;
                        break;
                    }
                    if (!qName.equals("gpx") || atts.getValue("creator") == null || !atts.getValue("creator").startsWith("Nokia Sports Tracker")) break;
                    this.nokiaSportsTrackerBug = true;
                    break;
                }
                case author: {
                    if (qName.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(atts.getValue("href"));
                        break;
                    }
                    if (!qName.equals("email")) break;
                    this.currentData.attr.put("meta.author.email", atts.getValue("id") + "@" + atts.getValue("domain"));
                    break;
                }
                case trk: {
                    if (qName.equals("trkseg")) {
                        this.states.push(this.currentState);
                        this.currentState = State.trkseg;
                        this.currentTrackSeg = new ArrayList<WayPoint>();
                        break;
                    }
                    if (qName.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(atts.getValue("href"));
                        break;
                    }
                    if (!qName.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
                case metadata: {
                    if (qName.equals("author")) {
                        this.states.push(this.currentState);
                        this.currentState = State.author;
                        break;
                    }
                    if (qName.equals("extensions")) {
                        this.states.push(this.currentState);
                        this.currentState = State.ext;
                        break;
                    }
                    if (qName.equals("copyright")) {
                        this.states.push(this.currentState);
                        this.currentState = State.copyright;
                        this.currentData.attr.put("meta.copyright.author", atts.getValue("author"));
                        break;
                    }
                    if (!qName.equals("link")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.link;
                    this.currentLink = new GpxLink(atts.getValue("href"));
                    break;
                }
                case trkseg: {
                    if (!qName.equals("trkpt")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.wpt;
                    this.currentWayPoint = new WayPoint(this.parseLatLon(atts));
                    break;
                }
                case wpt: {
                    if (qName.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(atts.getValue("href"));
                        break;
                    }
                    if (!qName.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
                case rte: {
                    if (qName.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(atts.getValue("href"));
                        break;
                    }
                    if (qName.equals("rtept")) {
                        this.states.push(this.currentState);
                        this.currentState = State.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(atts));
                        break;
                    }
                    if (!qName.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
            }
            this.accumulator.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.nokiaSportsTrackerBug) {
                for (int i = 0; i < ch.length; ++i) {
                    if (ch[i] != '\u0001') continue;
                    ch[i] = 32;
                }
                this.nokiaSportsTrackerBug = false;
            }
            this.accumulator.append(ch, start, length);
        }

        private Map<String, Object> getAttr() {
            switch (this.currentState) {
                case rte: {
                    return this.currentRoute.attr;
                }
                case metadata: {
                    return this.currentData.attr;
                }
                case wpt: {
                    return this.currentWayPoint.attr;
                }
                case trk: {
                    return this.currentTrackAttr;
                }
            }
            return null;
        }

        @Override
        public void endElement(String namespaceURI, String qName, String rqName) {
            this.elements.pop();
            switch (this.currentState) {
                case metadata: {
                    if (qName.equals("name")) {
                        this.currentData.attr.put("meta.name", this.accumulator.toString());
                        break;
                    }
                    if (qName.equals("desc")) {
                        this.currentData.attr.put("meta.desc", this.accumulator.toString());
                        break;
                    }
                    if (qName.equals("time")) {
                        this.currentData.attr.put("meta.time", this.accumulator.toString());
                        break;
                    }
                    if (qName.equals("keywords")) {
                        this.currentData.attr.put("meta.keywords", this.accumulator.toString());
                        break;
                    }
                    if (!qName.equals("metadata")) break;
                    this.currentState = this.states.pop();
                    break;
                }
                case author: {
                    if (qName.equals("author")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (qName.equals("name")) {
                        this.currentData.attr.put("meta.author.name", this.accumulator.toString());
                        break;
                    }
                    if (qName.equals("email") || !qName.equals("link")) break;
                    this.currentData.attr.put("meta.author.link", this.currentLink);
                    break;
                }
                case copyright: {
                    if (qName.equals("copyright")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (qName.equals("year")) {
                        this.currentData.attr.put("meta.copyright.year", this.accumulator.toString());
                        break;
                    }
                    if (!qName.equals("license")) break;
                    this.currentData.attr.put("meta.copyright.license", this.accumulator.toString());
                    break;
                }
                case link: {
                    if (qName.equals("text")) {
                        this.currentLink.text = this.accumulator.toString();
                    } else if (qName.equals("type")) {
                        this.currentLink.type = this.accumulator.toString();
                    } else if (qName.equals("link")) {
                        if (this.currentLink.uri == null && this.accumulator != null && this.accumulator.toString().length() != 0) {
                            this.currentLink = new GpxLink(this.accumulator.toString());
                        }
                        this.currentState = this.states.pop();
                    }
                    if (this.currentState == State.author) {
                        this.currentData.attr.put("meta.author.link", this.currentLink);
                        break;
                    }
                    if (this.currentState == State.link) break;
                    Map<String, Object> attr = this.getAttr();
                    if (!attr.containsKey("meta.links")) {
                        attr.put("meta.links", new LinkedList());
                    }
                    ((Collection)attr.get("meta.links")).add(this.currentLink);
                    break;
                }
                case wpt: {
                    if (qName.equals("ele") || qName.equals("magvar") || qName.equals("name") || qName.equals("geoidheight") || qName.equals("type") || qName.equals("sym")) {
                        this.currentWayPoint.attr.put(qName, this.accumulator.toString());
                        break;
                    }
                    if (qName.equals("hdop")) {
                        try {
                            this.currentWayPoint.attr.put(qName, Float.valueOf(Float.parseFloat(this.accumulator.toString())));
                        }
                        catch (Exception e) {
                            this.currentWayPoint.attr.put(qName, new Float(0.0f));
                        }
                        break;
                    }
                    if (qName.equals("time")) {
                        this.currentWayPoint.attr.put(qName, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (qName.equals("cmt") || qName.equals("desc")) {
                        this.currentWayPoint.attr.put(qName, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (qName.equals("rtept")) {
                        this.currentState = this.states.pop();
                        this.currentRoute.routePoints.add(this.currentWayPoint);
                        break;
                    }
                    if (qName.equals("trkpt")) {
                        this.currentState = this.states.pop();
                        this.currentTrackSeg.add(this.currentWayPoint);
                        break;
                    }
                    if (!qName.equals("wpt")) break;
                    this.currentState = this.states.pop();
                    this.currentData.waypoints.add(this.currentWayPoint);
                    break;
                }
                case trkseg: {
                    if (!qName.equals("trkseg")) break;
                    this.currentState = this.states.pop();
                    this.currentTrack.add(this.currentTrackSeg);
                    break;
                }
                case trk: {
                    if (qName.equals("trk")) {
                        this.currentState = this.states.pop();
                        this.currentData.tracks.add(new ImmutableGpxTrack(this.currentTrack, this.currentTrackAttr));
                        break;
                    }
                    if (!qName.equals("name") && !qName.equals("cmt") && !qName.equals("desc") && !qName.equals("src") && !qName.equals("type") && !qName.equals("number") && !qName.equals("url")) break;
                    this.currentTrackAttr.put(qName, this.accumulator.toString());
                    break;
                }
                case ext: {
                    if (!qName.equals("extensions")) break;
                    this.currentState = this.states.pop();
                    break;
                }
                default: {
                    if (qName.equals("wpt")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (!qName.equals("rte")) break;
                    this.currentState = this.states.pop();
                    this.currentData.routes.add(this.currentRoute);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.states.empty()) {
                throw new SAXException(I18n.tr("Parse error: invalid document structure for GPX document."));
            }
            GpxReader.this.data = this.currentData;
        }

        public void tryToFinish() throws SAXException {
            ArrayList<String> remainingElements = new ArrayList<String>(this.elements);
            for (int i = remainingElements.size() - 1; i >= 0; --i) {
                this.endElement(null, (String)remainingElements.get(i), null);
            }
            this.endDocument();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        init,
        metadata,
        wpt,
        rte,
        trk,
        ext,
        author,
        link,
        trkseg,
        copyright;

    }
}

