/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class PluginListPanel
extends VerticallyScrollablePanel {
    private static final Logger logger = Logger.getLogger(PluginListPanel.class.getName());
    private PluginPreferencesModel model;

    public PluginListPanel() {
        this.model = new PluginPreferencesModel();
        this.setLayout(new GridBagLayout());
    }

    public PluginListPanel(PluginPreferencesModel model) {
        this.model = model;
        this.setLayout(new GridBagLayout());
    }

    protected String formatPluginRemoteVersion(PluginInformation pi) {
        StringBuilder sb = new StringBuilder();
        if (pi.version == null || pi.version.trim().equals("")) {
            sb.append(I18n.tr("unknown"));
        } else {
            sb.append(pi.version);
            if (pi.oldmode) {
                sb.append("*");
            }
        }
        return sb.toString();
    }

    protected String formatPluginLocalVersion(PluginInformation pi) {
        if (pi == null) {
            return I18n.tr("unknown");
        }
        if (pi.localversion == null || pi.localversion.trim().equals("")) {
            return I18n.tr("unknown");
        }
        return pi.localversion;
    }

    protected String formatCheckboxTooltipText(PluginInformation pi) {
        if (pi == null) {
            return "";
        }
        if (pi.downloadlink == null) {
            return I18n.tr("Plugin bundled with JOSM");
        }
        return pi.downloadlink;
    }

    public void displayEmptyPluginListInformation() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(40, 0, 40, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        HtmlPanel hint = new HtmlPanel();
        hint.setText("<html>" + I18n.tr("Please click on <strong>Download list</strong> to download and display a list of available plugins.") + "</html>");
        this.add((Component)hint, gbc);
    }

    public void refreshView() {
        List<PluginInformation> displayedPlugins = this.model.getDisplayedPlugins();
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        if (displayedPlugins.isEmpty()) {
            this.displayEmptyPluginListInformation();
            return;
        }
        int row = -1;
        for (final PluginInformation pi : displayedPlugins) {
            boolean selected = this.model.isSelectedPlugin(pi.getName());
            String remoteversion = this.formatPluginRemoteVersion(pi);
            String localversion = this.formatPluginLocalVersion(this.model.getPluginInformation(pi.getName()));
            final JCheckBox cbPlugin = new JCheckBox();
            cbPlugin.setSelected(selected);
            cbPlugin.setToolTipText(this.formatCheckboxTooltipText(pi));
            cbPlugin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PluginListPanel.this.model.setPluginSelected(pi.getName(), cbPlugin.isSelected());
                }
            });
            JLabel lblPlugin = new JLabel(I18n.tr("{0}: Version {1} (local: {2})", pi.getName(), remoteversion, localversion), pi.getScaledIcon(), 2);
            gbc.gridx = 0;
            gbc.gridy = ++row;
            gbc.insets = new Insets(5, 5, 0, 5);
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            this.add((Component)cbPlugin, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            this.add((Component)lblPlugin, gbc);
            HtmlPanel description = new HtmlPanel();
            description.setText(pi.getDescriptionAsHtml());
            description.getEditorPane().addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl(e.getURL().toString());
                    }
                }
            });
            gbc.gridx = 1;
            gbc.gridy = ++row;
            gbc.insets = new Insets(3, 25, 5, 5);
            gbc.weighty = 1.0;
            this.add((Component)description, gbc);
        }
        this.revalidate();
        this.repaint();
    }
}

