/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedure;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedureComboBox;
import org.openstreetmap.josm.gui.oauth.FullyAutomaticAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.ManualAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.SemiAutomaticAuthorizationUI;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WindowGeometry;

public class OAuthAuthorizationWizard
extends JDialog {
    private static final Logger logger = Logger.getLogger(OAuthAuthorizationWizard.class.getName());
    private HtmlPanel pnlMessage;
    private boolean canceled;
    private String apiUrl;
    private AuthorizationProcedureComboBox cbAuthorisationProcedure;
    private FullyAutomaticAuthorizationUI pnlFullyAutomaticAuthorisationUI;
    private SemiAutomaticAuthorizationUI pnlSemiAutomaticAuthorisationUI;
    private ManualAuthorizationUI pnlManualAuthorisationUI;
    private JScrollPane spAuthorisationProcedureUI;

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        AcceptAccessTokenAction actAcceptAccessToken = new AcceptAccessTokenAction();
        this.pnlFullyAutomaticAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        this.pnlSemiAutomaticAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        this.pnlManualAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        pnl.add(new SideButton(actAcceptAccessToken));
        pnl.add(new SideButton(new CancelAction()));
        pnl.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"))));
        return pnl;
    }

    protected JPanel buildHeaderInfoPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        JLabel lbl = new JLabel();
        lbl.setIcon(ImageProvider.get("oauth", "oauth-logo"));
        lbl.setOpaque(true);
        pnl.add((Component)lbl, gc);
        gc.gridy = 1;
        gc.insets = new Insets(5, 0, 0, 5);
        this.pnlMessage = new HtmlPanel();
        this.pnlMessage.setText("<html><body>" + I18n.tr("With OAuth you grant JOSM the right to upload map data and GPS tracks on your behalf (<a href=\"{0}\">more info...</a>).", "http://oauth.net/") + "</body></html>");
        this.pnlMessage.getEditorPane().addHyperlinkListener(new ExternalBrowserLauncher());
        pnl.add((Component)this.pnlMessage, gc);
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        lbl = new JLabel(I18n.tr("Please select an authorization procedure: "));
        lbl.setFont(lbl.getFont().deriveFont(0));
        pnl.add((Component)lbl, gc);
        gc.gridx = 1;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        this.cbAuthorisationProcedure = new AuthorizationProcedureComboBox();
        pnl.add((Component)this.cbAuthorisationProcedure, gc);
        this.cbAuthorisationProcedure.addItemListener(new AuthorisationProcedureChangeListener());
        return pnl;
    }

    protected void refreshAuthorisationProcedurePanel() {
        AuthorizationProcedure procedure = (AuthorizationProcedure)((Object)this.cbAuthorisationProcedure.getSelectedItem());
        switch (procedure) {
            case FULLY_AUTOMATIC: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlFullyAutomaticAuthorisationUI);
                this.pnlFullyAutomaticAuthorisationUI.revalidate();
                break;
            }
            case SEMI_AUTOMATIC: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlSemiAutomaticAuthorisationUI);
                this.pnlSemiAutomaticAuthorisationUI.revalidate();
                break;
            }
            case MANUALLY: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlManualAuthorisationUI);
                this.pnlManualAuthorisationUI.revalidate();
            }
        }
        this.validate();
        this.repaint();
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildHeaderInfoPanel(), "North");
        this.pnlFullyAutomaticAuthorisationUI = new FullyAutomaticAuthorizationUI();
        this.pnlFullyAutomaticAuthorisationUI.setApiUrl(this.apiUrl);
        this.pnlSemiAutomaticAuthorisationUI = new SemiAutomaticAuthorizationUI();
        this.pnlSemiAutomaticAuthorisationUI.setApiUrl(this.apiUrl);
        this.pnlManualAuthorisationUI = new ManualAuthorizationUI();
        this.pnlManualAuthorisationUI.setApiUrl(this.apiUrl);
        this.spAuthorisationProcedureUI = new JScrollPane(new JPanel());
        this.spAuthorisationProcedureUI.setHorizontalScrollBarPolicy(31);
        this.spAuthorisationProcedureUI.setVerticalScrollBarPolicy(20);
        this.spAuthorisationProcedureUI.getVerticalScrollBar().addComponentListener(new ComponentListener(){

            public void componentShown(ComponentEvent e) {
                OAuthAuthorizationWizard.this.spAuthorisationProcedureUI.setBorder(UIManager.getBorder("ScrollPane.border"));
            }

            public void componentHidden(ComponentEvent e) {
                OAuthAuthorizationWizard.this.spAuthorisationProcedureUI.setBorder(null);
            }

            public void componentResized(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }
        });
        this.getContentPane().add((Component)this.spAuthorisationProcedureUI, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowEventHandler());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new CancelAction());
        this.refreshAuthorisationProcedurePanel();
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
    }

    public OAuthAuthorizationWizard(String apiUrl) throws IllegalArgumentException {
        super(JOptionPane.getFrameForComponent(Main.parent), true);
        CheckParameterUtil.ensureParameterNotNull(apiUrl, "apiUrl");
        this.build();
        this.setApiUrl(apiUrl);
    }

    public OAuthAuthorizationWizard(Component parent, String apiUrl) {
        super(JOptionPane.getFrameForComponent(parent), true);
        CheckParameterUtil.ensureParameterNotNull(apiUrl, "apiUrl");
        this.build();
        this.setApiUrl(apiUrl);
    }

    public void setApiUrl(String apiUrl) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(apiUrl, "apiUrl");
        this.apiUrl = apiUrl;
        this.setTitle(I18n.tr("Get an Access Token for ''{0}''", apiUrl));
        if (this.pnlFullyAutomaticAuthorisationUI != null) {
            this.pnlFullyAutomaticAuthorisationUI.setApiUrl(apiUrl);
        }
        if (this.pnlSemiAutomaticAuthorisationUI != null) {
            this.pnlSemiAutomaticAuthorisationUI.setApiUrl(apiUrl);
        }
        if (this.pnlManualAuthorisationUI != null) {
            this.pnlManualAuthorisationUI.setApiUrl(apiUrl);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected AbstractAuthorizationUI getCurrentAuthorisationUI() {
        switch ((AuthorizationProcedure)((Object)this.cbAuthorisationProcedure.getSelectedItem())) {
            case FULLY_AUTOMATIC: {
                return this.pnlFullyAutomaticAuthorisationUI;
            }
            case MANUALLY: {
                return this.pnlManualAuthorisationUI;
            }
            case SEMI_AUTOMATIC: {
                return this.pnlSemiAutomaticAuthorisationUI;
            }
        }
        return null;
    }

    public OAuthToken getAccessToken() {
        return this.getCurrentAuthorisationUI().getAccessToken();
    }

    public OAuthParameters getOAuthParameters() {
        return this.getCurrentAuthorisationUI().getOAuthParameters();
    }

    public boolean isSaveAccessTokenToPreferences() {
        return this.getCurrentAuthorisationUI().isSaveAccessTokenToPreferences();
    }

    public void initFromPreferences() {
        this.pnlFullyAutomaticAuthorisationUI.initFromPreferences(Main.pref);
        this.pnlSemiAutomaticAuthorisationUI.initFromPreferences(Main.pref);
        this.pnlManualAuthorisationUI.initFromPreferences(Main.pref);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(450, 540))).applySafe(this);
            this.initFromPreferences();
        } else if (!visible && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    class ExternalBrowserLauncher
    implements HyperlinkListener {
        ExternalBrowserLauncher() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                String url = e.getDescription();
                OpenBrowser.displayUrl(url);
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent arg0) {
            new CancelAction().cancel();
        }
    }

    class AcceptAccessTokenAction
    extends AbstractAction
    implements PropertyChangeListener {
        private OAuthToken token;

        public AcceptAccessTokenAction() {
            this.putValue("Name", I18n.tr("Accept Access Token"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog and accept the Access Token"));
            this.updateEnabledState(null);
        }

        public void actionPerformed(ActionEvent evt) {
            OAuthAuthorizationWizard.this.setCanceled(false);
            OAuthAuthorizationWizard.this.setVisible(false);
        }

        public void updateEnabledState(OAuthToken token) {
            this.setEnabled(token != null);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(AbstractAuthorizationUI.ACCESS_TOKEN_PROP)) {
                return;
            }
            this.token = (OAuthToken)evt.getNewValue();
            this.updateEnabledState(this.token);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog and cancel authorization"));
        }

        public void cancel() {
            OAuthAuthorizationWizard.this.setCanceled(true);
            OAuthAuthorizationWizard.this.setVisible(false);
        }

        public void actionPerformed(ActionEvent evt) {
            this.cancel();
        }
    }

    class AuthorisationProcedureChangeListener
    implements ItemListener {
        AuthorisationProcedureChangeListener() {
        }

        public void itemStateChanged(ItemEvent arg0) {
            OAuthAuthorizationWizard.this.refreshAuthorisationProcedurePanel();
        }
    }
}

