/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineElemStyle
extends ElemStyle
implements Comparable<LineElemStyle> {
    public static final LineElemStyle UNTAGGED_WAY = new LineElemStyle();
    private int width;
    public int realWidth;
    public Color color;
    private float[] dashed;
    public Color dashedColor;
    public boolean over;
    public WidthMode widthMode;
    public Collection<LineElemStyle> overlays;

    public LineElemStyle(LineElemStyle s, long maxScale, long minScale) {
        this.width = s.width;
        this.realWidth = s.realWidth;
        this.color = s.color;
        this.dashed = s.dashed;
        this.dashedColor = s.dashedColor;
        this.over = s.over;
        this.widthMode = s.widthMode;
        this.priority = s.priority;
        this.maxScale = maxScale;
        this.minScale = minScale;
        this.rules = s.rules;
    }

    public LineElemStyle(LineElemStyle s, Collection<LineElemStyle> overlays) {
        this.width = s.width;
        this.realWidth = s.realWidth;
        this.color = s.color;
        this.dashed = s.dashed;
        this.dashedColor = s.dashedColor;
        this.over = s.over;
        this.widthMode = s.widthMode;
        this.priority = s.priority;
        this.maxScale = s.maxScale;
        this.minScale = s.minScale;
        this.rules = s.rules;
        this.overlays = overlays;
        this.code = s.code;
        for (LineElemStyle o : overlays) {
            this.code = this.code + o.code;
        }
    }

    public LineElemStyle() {
        this.init();
    }

    public void init() {
        this.width = -1;
        this.realWidth = 0;
        this.dashed = new float[0];
        this.dashedColor = null;
        this.priority = 0;
        this.color = PaintColors.UNTAGGED.get();
        this.over = true;
        this.widthMode = WidthMode.ABSOLUTE;
        this.overlays = null;
    }

    public int getWidth(int ref) {
        int res = this.widthMode == WidthMode.ABSOLUTE ? this.width : (this.widthMode == WidthMode.OFFSET ? ref + this.width : (this.width < 0 ? 0 : ref * this.width / 100));
        return res <= 0 ? 1 : res;
    }

    @Override
    public int compareTo(LineElemStyle s) {
        if (s.priority != this.priority) {
            return s.priority > this.priority ? 1 : -1;
        }
        if (!this.over && s.over) {
            return -1;
        }
        return 0;
    }

    public float[] getDashed() {
        return this.dashed;
    }

    public void setDashed(float[] dashed) {
        if (dashed.length == 0) {
            this.dashed = dashed;
            return;
        }
        boolean found = false;
        for (int i = 0; i < dashed.length; ++i) {
            if (dashed[i] > 0.0f) {
                found = true;
            }
            if (!(dashed[i] < 0.0f)) continue;
            System.out.println(I18n.tr("Illegal dash pattern, values must be positive"));
        }
        if (found) {
            this.dashed = dashed;
        } else {
            System.out.println(I18n.tr("Illegal dash pattern, at least one value must be > 0"));
        }
    }

    @Override
    public void paintPrimitive(OsmPrimitive primitive, MapPaintSettings paintSettings, MapPainter painter, boolean selected, boolean member) {
        Way w = (Way)primitive;
        boolean showDirection = selected || !paintSettings.isUseRealWidth() && paintSettings.isShowDirectionArrow() && (!paintSettings.isShowRelevantDirectionsOnly() || w.hasDirectionKeys());
        boolean reversedDirection = w.reversedDirection();
        boolean showOnlyHeadArrowOnly = showDirection && !selected && paintSettings.isShowHeadArrowOnly();
        Color myColor = this.color;
        Color myDashedColor = this.dashedColor;
        int myWidth = this.getWidth();
        if (this.realWidth > 0 && paintSettings.isUseRealWidth() && !showDirection) {
            String widthTag = w.get("width");
            if (widthTag == null) {
                widthTag = w.get("est_width");
            }
            if (widthTag != null) {
                try {
                    this.realWidth = Integer.parseInt(widthTag);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((myWidth = (int)(100.0f / (float)(painter.getCircum() / (double)this.realWidth))) < this.getWidth()) {
                myWidth = this.getWidth();
            }
        }
        if (w.isHighlighted()) {
            myColor = paintSettings.getHighlightColor();
        } else if (selected) {
            myColor = member ? paintSettings.getRelationSelectedColor() : paintSettings.getSelectedColor();
        } else if (w.isDisabled()) {
            myColor = paintSettings.getInactiveColor();
            myDashedColor = paintSettings.getInactiveColor();
        }
        if (this.overlays != null) {
            for (LineElemStyle s : this.overlays) {
                if (s.over) continue;
                painter.drawWay(w, s.color == null || selected ? myColor : s.color, s.getWidth(myWidth), s.getDashed(), w.isDisabled() ? paintSettings.getInactiveColor() : s.dashedColor, false, false, false);
            }
        }
        painter.drawWay(w, myColor, myWidth, this.dashed, myDashedColor, showDirection, selected ? false : reversedDirection, showOnlyHeadArrowOnly);
        if (this.overlays != null) {
            for (LineElemStyle s : this.overlays) {
                if (!s.over) continue;
                painter.drawWay(w, s.color == null || selected ? myColor : s.color, s.getWidth(myWidth), s.getDashed(), s.dashedColor, false, false, false);
            }
        }
        if (paintSettings.isShowOrderNumber()) {
            int orderNumber = 0;
            Node lastN = null;
            for (Node n : w.getNodes()) {
                if (lastN != null) {
                    painter.drawOrderNumber(lastN, n, ++orderNumber);
                }
                lastN = n;
            }
        }
    }

    public int getWidth() {
        if (this.width == -1) {
            return MapPaintSettings.INSTANCE.getDefaultSegmentWidth();
        }
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WidthMode {
        ABSOLUTE,
        PERCENT,
        OFFSET;

    }
}

