/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MarkerLayer
extends Layer {
    public final Collection<Marker> data;
    private boolean mousePressed = false;
    public GpxLayer fromLayer = null;

    public MarkerLayer(GpxData indata, String name, File associatedFile, GpxLayer fromLayer) {
        super(name);
        this.setAssociatedFile(associatedFile);
        this.data = new ArrayList<Marker>();
        this.fromLayer = fromLayer;
        double firstTime = -1.0;
        String lastLinkedFile = "";
        for (WayPoint wpt : indata.waypoints) {
            Marker m;
            GpxLink oneLink;
            Iterator i$;
            double time = wpt.time;
            boolean wpt_has_link = wpt.attr.containsKey("meta.links");
            if (firstTime < 0.0 && wpt_has_link) {
                firstTime = time;
                i$ = ((Collection)wpt.attr.get("meta.links")).iterator();
                if (i$.hasNext()) {
                    oneLink = (GpxLink)i$.next();
                    lastLinkedFile = oneLink.uri;
                }
            }
            if (wpt_has_link && (i$ = ((Collection)wpt.attr.get("meta.links")).iterator()).hasNext()) {
                oneLink = (GpxLink)i$.next();
                if (!oneLink.uri.equals(lastLinkedFile)) {
                    firstTime = time;
                }
                lastLinkedFile = oneLink.uri;
            }
            if ((m = Marker.createMarker(wpt, indata.storageFile, this, time, time - firstTime)) == null) continue;
            this.data.add(m);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.getButton() != 1) {
                            return;
                        }
                        boolean mousePressedInButton = false;
                        if (e.getPoint() != null) {
                            for (Marker mkr : MarkerLayer.this.data) {
                                if (!mkr.containsPoint(e.getPoint())) continue;
                                mousePressedInButton = true;
                                break;
                            }
                        }
                        if (!mousePressedInButton) {
                            return;
                        }
                        MarkerLayer.this.mousePressed = true;
                        if (MarkerLayer.this.isVisible()) {
                            Main.map.mapView.repaint();
                        }
                    }

                    public void mouseReleased(MouseEvent ev) {
                        if (ev.getButton() != 1 || !MarkerLayer.this.mousePressed) {
                            return;
                        }
                        MarkerLayer.this.mousePressed = false;
                        if (!MarkerLayer.this.isVisible()) {
                            return;
                        }
                        if (ev.getPoint() != null) {
                            for (Marker mkr : MarkerLayer.this.data) {
                                if (!mkr.containsPoint(ev.getPoint())) continue;
                                mkr.actionPerformed(new ActionEvent(this, 0, null));
                            }
                        }
                        Main.map.mapView.repaint();
                    }
                });
            }
        });
    }

    public Icon getIcon() {
        return ImageProvider.get("layer", "marker_small");
    }

    public static Color getColor(String name) {
        return Main.pref.getColor(I18n.marktr("gps marker"), name != null ? "layer " + name : null, Color.gray);
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        boolean showTextOrIcon = this.isTextOrIconShown();
        g.setColor(MarkerLayer.getColor(this.getName()));
        if (this.mousePressed) {
            boolean mousePressedTmp = this.mousePressed;
            Point mousePos = mv.getMousePosition();
            for (Marker mkr : this.data) {
                if (mousePos == null || !mkr.containsPoint(mousePos)) continue;
                mkr.paint(g, mv, mousePressedTmp, showTextOrIcon);
                mousePressedTmp = false;
            }
        } else {
            for (Marker mkr : this.data) {
                mkr.paint(g, mv, false, showTextOrIcon);
            }
        }
    }

    public String getToolTipText() {
        return this.data.size() + " " + I18n.trn("marker", "markers", this.data.size());
    }

    public void mergeFrom(Layer from) {
        MarkerLayer layer = (MarkerLayer)from;
        this.data.addAll(layer.data);
    }

    public boolean isMergable(Layer other) {
        return other instanceof MarkerLayer;
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Marker mkr : this.data) {
            v.visit(mkr.getEastNorth());
        }
    }

    public Object getInfoComponent() {
        return "<html>" + I18n.trn("{0} consists of {1} marker", "{0} consists of {1} markers", this.data.size(), this.getName(), this.data.size()) + "</html>";
    }

    public Component[] getMenuEntries() {
        JMenuItem color = new JMenuItem(I18n.tr("Customize Color"), ImageProvider.get("colorchooser"));
        color.putClientProperty("help", "Action/LayerCustomizeColor");
        color.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JColorChooser c = new JColorChooser(MarkerLayer.getColor(MarkerLayer.this.getName()));
                Object[] options = new Object[]{I18n.tr("OK"), I18n.tr("Cancel"), I18n.tr("Default")};
                int answer = JOptionPane.showOptionDialog(Main.parent, c, I18n.tr("Choose a color"), 2, -1, null, options, options[0]);
                switch (answer) {
                    case 0: {
                        Main.pref.putColor("layer " + MarkerLayer.this.getName(), c.getColor());
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        Main.pref.putColor("layer " + MarkerLayer.this.getName(), null);
                    }
                }
                Main.map.repaint();
            }
        });
        JMenuItem syncaudio = new JMenuItem(I18n.tr("Synchronize Audio"), ImageProvider.get("audio-sync"));
        syncaudio.putClientProperty("help", "Action/SynchronizeAudio");
        syncaudio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!AudioPlayer.paused()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to pause audio at the moment when you hear your synchronization cue."), I18n.tr("Warning"), 2);
                    return;
                }
                AudioMarker recent = AudioMarker.recentlyPlayedMarker();
                if (MarkerLayer.this.synchronizeAudioMarkers(recent)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Audio synchronized at point {0}.", recent.text), I18n.tr("Information"), 1);
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to synchronize in layer being played."), I18n.tr("Error"), 0);
                }
            }
        });
        JMenuItem moveaudio = new JMenuItem(I18n.tr("Make Audio Marker at Play Head"), ImageProvider.get("addmarkers"));
        moveaudio.putClientProperty("help", "Action/MakeAudioMarkerAtPlayHead");
        moveaudio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!AudioPlayer.paused()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to have paused audio at the point on the track where you want the marker."), I18n.tr("Warning"), 2);
                    return;
                }
                PlayHeadMarker playHeadMarker = Main.map.mapView.playHeadMarker;
                if (playHeadMarker == null) {
                    return;
                }
                MarkerLayer.this.addAudioMarker(playHeadMarker.time, playHeadMarker.getCoor());
                Main.map.mapView.repaint();
            }
        });
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        components.add(new JMenuItem(LayerListDialog.getInstance().createShowHideLayerAction(this)));
        JCheckBoxMenuItem showMarkerTextItem = new JCheckBoxMenuItem(new ShowHideMarkerText(this));
        showMarkerTextItem.setState(this.isTextOrIconShown());
        components.add(showMarkerTextItem);
        components.add(new JMenuItem(LayerListDialog.getInstance().createDeleteLayerAction(this)));
        components.add(new JSeparator());
        components.add(color);
        components.add(new JSeparator());
        components.add(syncaudio);
        if (Main.pref.getBoolean("marker.traceaudio", true)) {
            components.add(moveaudio);
        }
        components.add(new JMenuItem(new RenameLayerAction(this.getAssociatedFile(), this)));
        components.add(new JSeparator());
        components.add(new JMenuItem(new LayerListPopup.InfoAction(this)));
        return components.toArray(new Component[0]);
    }

    public boolean synchronizeAudioMarkers(AudioMarker startMarker) {
        if (startMarker != null && !this.data.contains(startMarker)) {
            startMarker = null;
        }
        if (startMarker == null) {
            for (Marker m : this.data) {
                if (!(m instanceof AudioMarker)) continue;
                startMarker = (AudioMarker)m;
                break;
            }
        }
        if (startMarker == null) {
            return false;
        }
        double adjustment = AudioPlayer.position() - startMarker.offset;
        boolean seenStart = false;
        URL url = startMarker.url();
        for (Marker m : this.data) {
            AudioMarker ma;
            if (m == startMarker) {
                seenStart = true;
            }
            if (!seenStart || !(ma = (AudioMarker)m).url().equals(url)) continue;
            ma.adjustOffset(adjustment);
        }
        return true;
    }

    public AudioMarker addAudioMarker(double time, LatLon coor) {
        double offset = 0.0;
        AudioMarker am = null;
        for (Marker m : this.data) {
            if (m.getClass() != AudioMarker.class) continue;
            am = (AudioMarker)m;
            offset = time - am.time;
            break;
        }
        if (am == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No existing audio markers in this layer to offset from."), I18n.tr("Error"), 0);
            return null;
        }
        AudioMarker newAudioMarker = AudioMarker.create(coor, AudioMarker.inventName(offset), AudioPlayer.url().toString(), this, time, offset);
        ArrayList<Marker> newData = new ArrayList<Marker>();
        am = null;
        AudioMarker ret = newAudioMarker;
        for (Marker m : this.data) {
            if (m.getClass() == AudioMarker.class) {
                am = (AudioMarker)m;
                if (newAudioMarker != null && offset < am.offset) {
                    newAudioMarker.adjustOffset(am.syncOffset());
                    newData.add(newAudioMarker);
                    newAudioMarker = null;
                }
            }
            newData.add(m);
        }
        if (newAudioMarker != null) {
            if (am != null) {
                newAudioMarker.adjustOffset(am.syncOffset());
            }
            newData.add(newAudioMarker);
        }
        this.data.clear();
        this.data.addAll(newData);
        return ret;
    }

    public static void playAudio() {
        MarkerLayer.playAdjacentMarker(null, true);
    }

    public static void playNextMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), true);
    }

    public static void playPreviousMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), false);
    }

    private static Marker getAdjacentMarker(Marker startMarker, boolean next, Layer layer) {
        Marker previousMarker = null;
        boolean nextTime = false;
        if (layer.getClass() == MarkerLayer.class) {
            MarkerLayer markerLayer = (MarkerLayer)layer;
            for (Marker marker : markerLayer.data) {
                if (marker == startMarker) {
                    if (next) {
                        nextTime = true;
                        continue;
                    }
                    if (previousMarker == null) {
                        previousMarker = startMarker;
                    }
                    return previousMarker;
                }
                if (marker.getClass() != AudioMarker.class) continue;
                if (nextTime || startMarker == null) {
                    return marker;
                }
                previousMarker = marker;
            }
            if (nextTime) {
                return startMarker;
            }
        }
        return null;
    }

    private static void playAdjacentMarker(Marker startMarker, boolean next) {
        Marker m = null;
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        Layer l = Main.map.mapView.getActiveLayer();
        if (l != null) {
            m = MarkerLayer.getAdjacentMarker(startMarker, next, l);
        }
        if (m == null) {
            Layer layer;
            Iterator<Layer> i$ = Main.map.mapView.getAllLayers().iterator();
            while (i$.hasNext() && (m = MarkerLayer.getAdjacentMarker(startMarker, next, layer = i$.next())) == null) {
            }
        }
        if (m != null) {
            ((AudioMarker)m).play();
        }
    }

    private boolean isTextOrIconShown() {
        String current = Main.pref.get("marker.show " + this.getName(), "show");
        return "show".equalsIgnoreCase(current);
    }

    public static final class ShowHideMarkerText
    extends AbstractAction {
        private final MarkerLayer layer;

        public ShowHideMarkerText(MarkerLayer layer) {
            super(I18n.tr("Show Text/Icons"), ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the marker text and icons."));
            this.putValue("help", "Action/ShowHideTextIcons");
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent e) {
            Main.pref.put("marker.show " + this.layer.getName(), this.layer.isTextOrIconShown() ? "hide" : "show");
            Main.map.mapView.repaint();
        }
    }
}

