/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationNodeMap {
    private TreeMap<Node, TreeSet<Integer>> nodesMap;
    private TreeMap<Integer, TreeSet<Node>> waysMap;
    private TreeSet<Integer> remaining;
    private List<Integer> notSortable = new ArrayList<Integer>();

    RelationNodeMap(List<RelationMember> members) {
        this.nodesMap = new TreeMap();
        this.waysMap = new TreeMap();
        for (int i = 0; i < members.size(); ++i) {
            RelationMember m = members.get(i);
            if (m.getMember().isIncomplete() || !m.isWay()) {
                this.notSortable.add(i);
                continue;
            }
            Way w = m.getWay();
            if (MemberTableModel.roundaboutType(w) != WayConnectionType.Direction.NONE) {
                for (Node nd : w.getNodes()) {
                    this.addPair(nd, i);
                }
                continue;
            }
            this.addPair(w.firstNode(), i);
            this.addPair(w.lastNode(), i);
        }
        this.remaining = new TreeSet();
        for (Integer k : this.waysMap.keySet()) {
            this.remaining.add(k);
        }
        Iterator<Map.Entry<Node, TreeSet<Integer>>> it = this.nodesMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Node, TreeSet<Integer>> nodeLinks = it.next();
            if (nodeLinks.getValue().size() >= 2) continue;
            if (nodeLinks.getValue().size() != 1) {
                throw new AssertionError();
            }
            Integer d_way = nodeLinks.getValue().iterator().next();
            TreeSet<Node> d_way_nodes = this.waysMap.get(d_way);
            d_way_nodes.remove(nodeLinks.getKey());
            it.remove();
        }
    }

    private void addPair(Node n, int i) {
        TreeSet<Integer> ts = this.nodesMap.get(n);
        if (ts == null) {
            ts = new TreeSet();
            this.nodesMap.put(n, ts);
        }
        ts.add(i);
        TreeSet<Node> ts2 = this.waysMap.get(i);
        if (ts2 == null) {
            ts2 = new TreeSet();
            this.waysMap.put(i, ts2);
        }
        ts2.add(n);
    }

    public Integer popAdjacent(Integer i) {
        TreeSet<Node> nodes = this.waysMap.get(i);
        for (Node n : nodes) {
            TreeSet<Integer> adj = this.nodesMap.get(n);
            if (adj.isEmpty()) continue;
            Integer j = adj.iterator().next();
            this.done(j);
            this.waysMap.get(j).remove(n);
            return j;
        }
        return null;
    }

    public Integer pop() {
        if (this.remaining.isEmpty()) {
            return null;
        }
        Integer i = this.remaining.iterator().next();
        this.done(i);
        return i;
    }

    private void done(Integer i) {
        this.remaining.remove(i);
        TreeSet<Node> nodes = this.waysMap.get(i);
        for (Node n : nodes) {
            boolean result = this.nodesMap.get(n).remove(i);
            if (!result) {
                throw new AssertionError();
            }
        }
    }

    public List<Integer> getNotSortableMembers() {
        return this.notSortable;
    }
}

