/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetContentTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public ChangesetContentTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void reset() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
        this.setFont(UIManager.getFont("Table.font"));
    }

    protected void renderColors(boolean isSelected) {
        if (isSelected) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
    }

    protected void renderId(HistoryOsmPrimitive primitive) {
        this.setText(Long.toString(primitive.getId()));
        this.setToolTipText("");
    }

    protected void renderModificationType(ChangesetDataSet.ChangesetModificationType type) {
        switch (type) {
            case CREATED: {
                this.setText(I18n.tr("Created"));
                break;
            }
            case UPDATED: {
                this.setText(I18n.tr("Updated"));
                break;
            }
            case DELETED: {
                this.setText(I18n.tr("Deleted"));
            }
        }
        this.setToolTipText("");
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.reset();
        this.renderColors(isSelected);
        switch (column) {
            case 0: {
                ChangesetDataSet.ChangesetModificationType type = (ChangesetDataSet.ChangesetModificationType)((Object)value);
                this.renderModificationType(type);
                break;
            }
            case 1: {
                HistoryOsmPrimitive primitive = (HistoryOsmPrimitive)value;
                this.renderId(primitive);
                break;
            }
        }
        return this;
    }
}

