/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecision;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinePrimitiveResolverDialog
extends JDialog {
    private static CombinePrimitiveResolverDialog instance;
    private AutoAdjustingSplitPane spTagConflictTypes;
    private TagConflictResolver pnlTagConflictResolver;
    private RelationMemberConflictResolver pnlRelationMemberConflictResolver;
    private boolean cancelled;
    private JPanel pnlButtons;
    private OsmPrimitive targetPrimitive;
    private ContextSensitiveHelpAction helpAction;
    private SideButton btnApply;

    public static CombinePrimitiveResolverDialog getInstance() {
        if (instance == null) {
            instance = new CombinePrimitiveResolverDialog(Main.parent);
        }
        return instance;
    }

    public OsmPrimitive getTargetPrimitmive() {
        return this.targetPrimitive;
    }

    public void setTargetPrimitive(OsmPrimitive primitive) {
        this.targetPrimitive = primitive;
        this.updateTitle();
        if (primitive instanceof Way) {
            this.pnlRelationMemberConflictResolver.initForWayCombining();
        } else if (primitive instanceof Node) {
            this.pnlRelationMemberConflictResolver.initForNodeMerging();
        }
    }

    protected void updateTitle() {
        if (this.targetPrimitive == null) {
            this.setTitle(I18n.tr("Conflicts when combining primitives"));
            return;
        }
        if (this.targetPrimitive instanceof Way) {
            this.setTitle(I18n.tr("Conflicts when combining ways - combined way is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/CombineWay#ResolvingConflicts"));
        } else if (this.targetPrimitive instanceof Node) {
            this.setTitle(I18n.tr("Conflicts when merging nodes - target node is ''{0}''", this.targetPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
            this.helpAction.setHelpTopic(HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
            this.getRootPane().putClientProperty("help", HelpUtil.ht("/Action/MergeNodes#ResolvingConflicts"));
        }
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.updateTitle();
        this.spTagConflictTypes = new AutoAdjustingSplitPane(0);
        this.spTagConflictTypes.setTopComponent(this.buildTagConflictResolverPanel());
        this.spTagConflictTypes.setBottomComponent(this.buildRelationMemberConflictResolverPanel());
        this.pnlButtons = this.buildButtonPanel();
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.addWindowListener(new AdjustDividerLocationAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/"));
    }

    protected JPanel buildTagConflictResolverPanel() {
        this.pnlTagConflictResolver = new TagConflictResolver();
        return this.pnlTagConflictResolver;
    }

    protected JPanel buildRelationMemberConflictResolverPanel() {
        this.pnlRelationMemberConflictResolver = new RelationMemberConflictResolver();
        return this.pnlRelationMemberConflictResolver;
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        ApplyAction applyAction = new ApplyAction();
        this.pnlTagConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.pnlRelationMemberConflictResolver.getModel().addPropertyChangeListener(applyAction);
        this.btnApply = new SideButton(applyAction);
        this.btnApply.setFocusable(true);
        pnl.add(this.btnApply);
        CancelAction cancelAction = new CancelAction();
        pnl.add(new SideButton(cancelAction));
        this.helpAction = new ContextSensitiveHelpAction();
        pnl.add(new SideButton(this.helpAction));
        return pnl;
    }

    public CombinePrimitiveResolverDialog(Component owner) {
        super(JOptionPane.getFrameForComponent(owner), true);
        this.build();
    }

    public TagConflictResolverModel getTagConflictResolverModel() {
        return this.pnlTagConflictResolver.getModel();
    }

    public RelationMemberConflictResolverModel getRelationMemberConflictResolverModel() {
        return this.pnlRelationMemberConflictResolver.getModel();
    }

    protected List<Command> buildTagChangeCommand(OsmPrimitive primitive, TagCollection tc) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (String key : tc.getKeys()) {
            if (tc.hasUniqueEmptyValue(key)) {
                if (primitive.get(key) == null) continue;
                cmds.add(new ChangePropertyCommand(primitive, key, null));
                continue;
            }
            String value = tc.getJoinedValues(key);
            if (value.equals(primitive.get(key))) continue;
            cmds.add(new ChangePropertyCommand(primitive, key, value));
        }
        return cmds;
    }

    public List<Command> buildResolutionCommands() {
        Command cmd;
        LinkedList<Command> cmds = new LinkedList<Command>();
        TagCollection allResolutions = this.getTagConflictResolverModel().getAllResolutions();
        if (allResolutions.size() > 0) {
            cmds.addAll(this.buildTagChangeCommand(this.targetPrimitive, allResolutions));
        }
        if (this.targetPrimitive.get("created_by") != null) {
            cmds.add(new ChangePropertyCommand(this.targetPrimitive, "created_by", null));
        }
        if (this.getRelationMemberConflictResolverModel().getNumDecisions() > 0) {
            cmds.addAll(this.getRelationMemberConflictResolverModel().buildResolutionCommands(this.targetPrimitive));
        }
        if ((cmd = this.pnlRelationMemberConflictResolver.buildTagApplyCommands(this.getRelationMemberConflictResolverModel().getModifiedRelations(this.targetPrimitive))) != null) {
            cmds.add(cmd);
        }
        return cmds;
    }

    protected void prepareDefaultTagDecisions() {
        TagConflictResolverModel model = this.getTagConflictResolverModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            MultiValueResolutionDecision decision = model.getDecision(i);
            List<String> values = decision.getValues();
            values.remove("");
            if (values.size() == 1) {
                decision.keepOne(values.get(0));
                continue;
            }
            decision.keepAll();
        }
        model.rebuild();
    }

    protected void prepareDefaultRelationDecisions() {
        RelationMemberConflictResolverModel model = this.getRelationMemberConflictResolverModel();
        HashSet<Relation> relations = new HashSet<Relation>();
        for (int i = 0; i < model.getNumDecisions(); ++i) {
            RelationMemberConflictDecision decision = model.getDecision(i);
            if (!relations.contains(decision.getRelation())) {
                decision.decide(RelationMemberConflictDecisionType.KEEP);
                relations.add(decision.getRelation());
                continue;
            }
            decision.decide(RelationMemberConflictDecisionType.REMOVE);
        }
        model.refresh();
    }

    public void prepareDefaultDecisions() {
        this.prepareDefaultTagDecisions();
        this.prepareDefaultRelationDecisions();
    }

    protected JPanel buildEmptyConflictsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add(new JLabel(I18n.tr("No conflicts to resolve")));
        return pnl;
    }

    protected void prepareGUIBeforeConflictResolutionStarts() {
        RelationMemberConflictResolverModel relModel = this.getRelationMemberConflictResolverModel();
        TagConflictResolverModel tagModel = this.getTagConflictResolverModel();
        this.getContentPane().removeAll();
        if (relModel.getNumDecisions() > 0 && tagModel.getNumDecisions() > 0) {
            this.spTagConflictTypes.setTopComponent(this.pnlTagConflictResolver);
            this.spTagConflictTypes.setBottomComponent(this.pnlRelationMemberConflictResolver);
            this.getContentPane().add((Component)this.spTagConflictTypes, "Center");
        } else if (relModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlRelationMemberConflictResolver, "Center");
        } else if (tagModel.getNumDecisions() > 0) {
            this.getContentPane().add((Component)this.pnlTagConflictResolver, "Center");
        } else {
            this.getContentPane().add((Component)this.buildEmptyConflictsPanel(), "Center");
        }
        this.getContentPane().add((Component)this.pnlButtons, "South");
        this.validate();
        int numTagDecisions = this.getTagConflictResolverModel().getNumDecisions();
        int numRelationDecisions = this.getRelationMemberConflictResolverModel().getNumDecisions();
        if (numTagDecisions > 0 && numRelationDecisions > 0) {
            this.spTagConflictTypes.setDividerLocation(0.5);
        }
        this.pnlRelationMemberConflictResolver.prepareForEditing();
    }

    protected void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.prepareGUIBeforeConflictResolutionStarts();
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(600, 400))).applySafe(this);
            this.setCancelled(false);
            this.btnApply.requestFocusInWindow();
        } else {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    static class AutoAdjustingSplitPane
    extends JSplitPane
    implements PropertyChangeListener,
    HierarchyBoundsListener {
        private double dividerLocation;

        public AutoAdjustingSplitPane(int newOrientation) {
            super(newOrientation);
            this.addPropertyChangeListener("dividerLocation", this);
            this.addHierarchyBoundsListener(this);
        }

        public void ancestorResized(HierarchyEvent e) {
            this.setDividerLocation((int)(this.dividerLocation * (double)this.getHeight()));
        }

        public void ancestorMoved(HierarchyEvent e) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dividerLocation")) {
                int newVal = (Integer)evt.getNewValue();
                if (this.getHeight() != 0) {
                    this.dividerLocation = (double)newVal / (double)this.getHeight();
                }
            }
        }
    }

    class AdjustDividerLocationAction
    extends WindowAdapter {
        AdjustDividerLocationAction() {
        }

        public void windowOpened(WindowEvent e) {
            int numTagDecisions = CombinePrimitiveResolverDialog.this.getTagConflictResolverModel().getNumDecisions();
            int numRelationDecisions = CombinePrimitiveResolverDialog.this.getRelationMemberConflictResolverModel().getNumDecisions();
            if (numTagDecisions > 0 && numRelationDecisions > 0) {
                CombinePrimitiveResolverDialog.this.spTagConflictTypes.setDividerLocation(0.5);
            }
        }
    }

    class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts"));
            this.putValue("Name", I18n.tr("Apply"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent arg0) {
            CombinePrimitiveResolverDialog.this.setVisible(false);
            CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.rememberPreferences();
        }

        protected void updateEnabledState() {
            this.setEnabled(CombinePrimitiveResolverDialog.this.pnlTagConflictResolver.getModel().getNumConflicts() == 0 && CombinePrimitiveResolverDialog.this.pnlRelationMemberConflictResolver.getModel().getNumConflicts() == 0);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
            if (evt.getPropertyName().equals(RelationMemberConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution"));
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            CombinePrimitiveResolverDialog.this.setCancelled(true);
            CombinePrimitiveResolverDialog.this.setVisible(false);
        }
    }
}

