/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SizeButton;
import org.openstreetmap.josm.gui.bbox.SlippyMapControler;
import org.openstreetmap.josm.gui.bbox.SourceButton;

public class SlippyMapBBoxChooser
extends JMapViewer
implements BBoxChooser {
    private static TileSource[] TILE_SOURCES = new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.TilesAtHome(), new OsmTileSource.CycleMap()};
    private Dimension iDownloadDialogDimension;
    private TileLoader cachedLoader;
    private TileLoader uncachedLoader;
    private SizeButton iSizeButton = new SizeButton();
    private SourceButton iSourceButton = new SourceButton();
    private Bounds bbox;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;

    public SlippyMapBBoxChooser() {
        try {
            this.cachedLoader = new OsmFileCacheTileLoader(this);
        }
        catch (SecurityException e) {
            this.cachedLoader = null;
        }
        this.uncachedLoader = new OsmTileLoader(this);
        this.setZoomContolsVisible(false);
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Main.pref.getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Main.pref.getInteger("slippy_map_chooser.max_tiles", 1000));
        String mapStyle = Main.pref.get("slippy_map_chooser.mapstyle", "mapnik");
        if (mapStyle.equals("osmarender")) {
            this.iSourceButton.setMapStyle(3);
            this.setTileSource(TILE_SOURCES[1]);
        } else if (mapStyle.equals("cyclemap")) {
            this.iSourceButton.setMapStyle(4);
            this.setTileSource(TILE_SOURCES[2]);
        } else if (!mapStyle.equals("mapnik")) {
            Main.pref.put("slippy_map_chooser", "mapnik");
        }
        new SlippyMapControler(this, this, this.iSizeButton, this.iSourceButton);
    }

    protected Point getTopLeftCoordinates() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                int zoomDiff = 22 - this.zoom;
                Point tlc = this.getTopLeftCoordinates();
                int x_min = (this.iSelectionRectStart.x >> zoomDiff) - tlc.x;
                int y_min = (this.iSelectionRectStart.y >> zoomDiff) - tlc.y;
                int x_max = (this.iSelectionRectEnd.x >> zoomDiff) - tlc.x;
                int y_max = (this.iSelectionRectEnd.y >> zoomDiff) - tlc.y;
                int w = x_max - x_min;
                int h = y_max - y_min;
                g.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                g.fillRect(x_min, y_min, w, h);
                g.setColor(Color.BLACK);
                g.drawRect(x_min, y_min, w, h);
            }
            this.iSizeButton.paint(g);
            this.iSourceButton.paint(g);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFileCacheEnabled(boolean enabled) {
        if (enabled) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public void setMaxTilesInMemory(int tiles) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(tiles);
    }

    public void setSelection(Point aStart, Point aEnd) {
        if (aStart == null || aEnd == null || aStart.x == aEnd.x || aStart.y == aEnd.y) {
            return;
        }
        Point p_max = new Point(Math.max(aEnd.x, aStart.x), Math.max(aEnd.y, aStart.y));
        Point p_min = new Point(Math.min(aEnd.x, aStart.x), Math.min(aEnd.y, aStart.y));
        Point tlc = this.getTopLeftCoordinates();
        int zoomDiff = 22 - this.zoom;
        Point pEnd = new Point(p_max.x + tlc.x, p_max.y + tlc.y);
        Point pStart = new Point(p_min.x + tlc.x, p_min.y + tlc.y);
        pEnd.x <<= zoomDiff;
        pEnd.y <<= zoomDiff;
        pStart.x <<= zoomDiff;
        pStart.y <<= zoomDiff;
        this.iSelectionRectStart = pStart;
        this.iSelectionRectEnd = pEnd;
        Coordinate l1 = this.getPosition(p_max);
        Coordinate l2 = this.getPosition(p_min);
        Bounds b = new Bounds(new LatLon(Math.min(l2.getLat(), l1.getLat()), Math.min(l1.getLon(), l2.getLon())), new LatLon(Math.max(l2.getLat(), l1.getLat()), Math.max(l1.getLon(), l2.getLon())));
        Bounds oldValue = this.bbox;
        this.bbox = b;
        this.firePropertyChange(BBOX_PROP, oldValue, this.bbox);
        this.repaint();
    }

    public void resizeSlippyMap() {
        Dimension iScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.iDownloadDialogDimension == null) {
            int w = iScreenSize.width * 90 / 100;
            int h = iScreenSize.height * 90 / 100;
        } else {
            int w = this.iDownloadDialogDimension.width;
            int h = this.iDownloadDialogDimension.height;
            this.iDownloadDialogDimension = null;
        }
        this.repaint();
    }

    public void toggleMapSource(int mapSource) {
        this.tileController.setTileCache(new MemoryTileCache());
        if (mapSource == 2) {
            this.setTileSource(TILE_SOURCES[0]);
            Main.pref.put("slippy_map_chooser.mapstyle", "mapnik");
        } else if (mapSource == 4) {
            this.setTileSource(TILE_SOURCES[2]);
            Main.pref.put("slippy_map_chooser.mapstyle", "cyclemap");
        } else {
            this.setTileSource(TILE_SOURCES[1]);
            Main.pref.put("slippy_map_chooser.mapstyle", "osmarender");
        }
    }

    public Bounds getBoundingBox() {
        return this.bbox;
    }

    public void setBoundingBox(Bounds bbox) {
        if (bbox == null) {
            this.bbox = null;
            return;
        }
        if (bbox.getMin().lat() == 0.0 && bbox.getMin().lon() == 0.0 && bbox.getMax().lat() == 0.0 && bbox.getMax().lon() == 0.0) {
            this.bbox = null;
        }
        int y1 = OsmMercator.LatToY(bbox.getMin().lat(), 22);
        int y2 = OsmMercator.LatToY(bbox.getMax().lat(), 22);
        int x1 = OsmMercator.LonToX(bbox.getMin().lon(), 22);
        int x2 = OsmMercator.LonToX(bbox.getMax().lon(), 22);
        this.iSelectionRectStart = new Point(Math.min(x1, x2), Math.min(y1, y2));
        this.iSelectionRectEnd = new Point(Math.max(x1, x2), Math.max(y1, y2));
        MapMarkerDot xmin_ymin = new MapMarkerDot(bbox.getMin().lat(), bbox.getMin().lon());
        MapMarkerDot xmax_ymax = new MapMarkerDot(bbox.getMax().lat(), bbox.getMax().lon());
        Vector<MapMarker> marker = new Vector<MapMarker>(2);
        marker.add(xmin_ymin);
        marker.add(xmax_ymax);
        this.setMapMarkerList(marker);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
        this.bbox = bbox;
    }
}

