/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPainter {
    private final Graphics2D g;
    private final NavigatableComponent nc;
    private final boolean inactive;
    private final boolean useStrokes;
    private final boolean showNames;
    private final boolean showIcons;
    private final Color inactiveColor;
    private final Color textColor;
    private final Color selectedColor;
    private final Color relationSelectedColor;
    private final Color areaTextColor;
    private final Color nodeColor;
    private final Color backgroundColor;
    private final Font orderFont;
    private final int fillAlpha;
    private final int virtualNodeSize;
    private final int virtualNodeSpace;
    private final int segmentNumberSpace;
    private final double circum;
    private final Collection<String> regionalNameOrder;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);

    public MapPainter(MapPaintSettings settings, Graphics2D g, boolean inactive, NavigatableComponent nc, boolean virtual, double dist, double circum) {
        this.g = g;
        this.inactive = inactive;
        this.nc = nc;
        this.useStrokes = (double)settings.getUseStrokesDistance() > dist;
        this.showNames = (double)settings.getShowNamesDistance() > dist;
        this.showIcons = (double)settings.getShowIconsDistance() > dist;
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.textColor = PaintColors.TEXT.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.areaTextColor = PaintColors.AREA_TEXT.get();
        this.nodeColor = PaintColors.NODE.get();
        this.backgroundColor = PaintColors.BACKGROUND.get();
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Helvetica"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        this.fillAlpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fillalpha", 50)));
        this.virtualNodeSize = virtual ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        String[] names = new String[]{"name:" + LanguageInfo.getJOSMLocaleCode(), "name", "int_name", "ref", "operator", "brand", "addr:housenumber"};
        this.regionalNameOrder = Main.pref.getCollection("mappaint.nameOrder", Arrays.asList(names));
        this.circum = circum;
    }

    public void drawWay(Way way, Color color, int width, float[] dashed, Color dashedColor, boolean showDirection, boolean reversedDirection, boolean showHeadArrowOnly) {
        GeneralPath path = new GeneralPath();
        Point lastPoint = null;
        Iterator<Node> it = way.getNodes().iterator();
        while (it.hasNext()) {
            Node n = it.next();
            Point p = this.nc.getPoint(n);
            if (lastPoint != null) {
                this.drawSegment(path, lastPoint, p, showHeadArrowOnly ? !it.hasNext() : showDirection, reversedDirection);
            }
            lastPoint = p;
        }
        this.displaySegments(path, color, width, dashed, dashedColor);
    }

    private void displaySegments(GeneralPath path, Color color, int width, float[] dashed, Color dashedColor) {
        this.g.setColor(this.inactive ? this.inactiveColor : color);
        if (this.useStrokes) {
            if (dashed.length > 0) {
                this.g.setStroke(new BasicStroke(width, 0, 1, 0.0f, dashed, 0.0f));
            } else {
                this.g.setStroke(new BasicStroke(width, 1, 1));
            }
        }
        this.g.draw(path);
        if (!this.inactive && this.useStrokes && dashedColor != null) {
            this.g.setColor(dashedColor);
            if (dashed.length > 0) {
                float[] dashedOffset = new float[dashed.length];
                System.arraycopy(dashed, 1, dashedOffset, 0, dashed.length - 1);
                dashedOffset[dashed.length - 1] = dashed[0];
                float offset = dashedOffset[0];
                this.g.setStroke(new BasicStroke(width, 0, 1, 0.0f, dashedOffset, offset));
            } else {
                this.g.setStroke(new BasicStroke(width, 1, 1));
            }
            this.g.draw(path);
        }
        if (this.useStrokes) {
            this.g.setStroke(new BasicStroke());
        }
    }

    private void drawSegment(GeneralPath path, Point p1, Point p2, boolean showDirection, boolean reversedDirection) {
        boolean drawIt = false;
        if (Main.isOpenjdk) {
            Rectangle bounds = this.g.getClipBounds();
            bounds.grow(100, 100);
            LineClip clip = new LineClip();
            drawIt = clip.cohenSutherland(p1.x, p1.y, p2.x, p2.y, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
            p1 = clip.getP1();
            p2 = clip.getP2();
        } else {
            drawIt = this.isSegmentVisible(p1, p2);
        }
        if (drawIt) {
            path.moveTo(p1.x, p1.y);
            path.lineTo(p2.x, p2.y);
            if (showDirection) {
                Point q1 = p1;
                Point q2 = p2;
                if (reversedDirection) {
                    q1 = p2;
                    q2 = p1;
                    path.moveTo(q2.x, q2.y);
                }
                double l = 10.0 / q1.distance(q2);
                double sx = l * (double)(q1.x - q2.x);
                double sy = l * (double)(q1.y - q2.y);
                path.lineTo(q2.x + (int)Math.round(cosPHI * sx - sinPHI * sy), q2.y + (int)Math.round(sinPHI * sx + cosPHI * sy));
                path.moveTo(q2.x + (int)Math.round(cosPHI * sx + sinPHI * sy), q2.y + (int)Math.round(-sinPHI * sx + cosPHI * sy));
                path.lineTo(q2.x, q2.y);
            }
        }
    }

    private boolean isSegmentVisible(Point p1, Point p2) {
        if (p1.x < 0 && p2.x < 0) {
            return false;
        }
        if (p1.y < 0 && p2.y < 0) {
            return false;
        }
        if (p1.x > this.nc.getWidth() && p2.x > this.nc.getWidth()) {
            return false;
        }
        return p1.y <= this.nc.getHeight() || p2.y <= this.nc.getHeight();
    }

    public void drawNodeIcon(Node n, ImageIcon icon, boolean selected, boolean member, String name) {
        Point p = this.nc.getPoint(n);
        if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
            return;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        icon.paintIcon(this.nc, this.g, p.x - w / 2, p.y - h / 2);
        if (name != null) {
            if (this.inactive || n.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(this.textColor);
            }
            Font defaultFont = this.g.getFont();
            this.g.setFont(this.orderFont);
            this.g.drawString(name, p.x + w / 2 + 2, p.y + h / 2 + 2);
            this.g.setFont(defaultFont);
        }
        if (selected) {
            this.g.setColor(member ? this.relationSelectedColor : this.selectedColor);
            this.g.drawRect(p.x - w / 2 - 2, p.y - h / 2 - 2, w + 4, h + 4);
        }
    }

    public void drawNode(Node n, Color color, int size, boolean fill, String name) {
        if (size > 1) {
            int radius = size / 2;
            Point p = this.nc.getPoint(n);
            if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
                return;
            }
            if (this.inactive || n.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(color);
            }
            if (fill) {
                this.g.fillRect(p.x - radius, p.y - radius, size, size);
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            } else {
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            }
            if (name != null) {
                if (this.inactive || n.isDisabled()) {
                    this.g.setColor(this.inactiveColor);
                } else {
                    this.g.setColor(this.textColor);
                }
                Font defaultFont = this.g.getFont();
                this.g.setFont(this.orderFont);
                this.g.drawString(name, p.x + radius + 2, p.y + radius + 2);
                this.g.setFont(defaultFont);
            }
        }
    }

    protected void drawArea(Polygon polygon, Color color, String name) {
        this.g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.fillAlpha));
        this.g.fillPolygon(polygon);
        if (name != null) {
            Rectangle pb = polygon.getBounds();
            FontMetrics fontMetrics = this.g.getFontMetrics(this.orderFont);
            Rectangle2D nb = fontMetrics.getStringBounds(name, this.g);
            Rectangle centeredNBounds = new Rectangle(pb.x + (int)(((double)pb.width - nb.getWidth()) / 2.0), pb.y + (int)(((double)pb.height - nb.getHeight()) / 2.0), (int)nb.getWidth(), (int)nb.getHeight());
            if ((double)pb.width >= nb.getWidth() && (double)pb.height >= nb.getHeight() && polygon.contains(centeredNBounds)) {
                this.g.setColor(this.areaTextColor);
                Font defaultFont = this.g.getFont();
                this.g.setFont(this.orderFont);
                this.g.drawString(name, (int)(centeredNBounds.getMinX() - nb.getMinX()), (int)(centeredNBounds.getMinY() - nb.getMinY()));
                this.g.setFont(defaultFont);
            }
        }
    }

    public void drawRestriction(ImageIcon icon, Point pVia, double vx, double vx2, double vy, double vy2, double iconAngle, boolean selected) {
        ImageIcon rotatedIcon = ImageProvider.createRotatedImage(null, icon, iconAngle);
        ImageIcon smallIcon = new ImageIcon(rotatedIcon.getImage().getScaledInstance(16, 16, 4));
        int w = smallIcon.getIconWidth();
        int h = smallIcon.getIconHeight();
        smallIcon.paintIcon(this.nc, this.g, (int)((double)pVia.x + vx + vx2) - w / 2, (int)((double)pVia.y + vy + vy2) - h / 2);
        if (selected) {
            this.g.setColor(this.relationSelectedColor);
            this.g.drawRect((int)((double)pVia.x + vx + vx2) - w / 2 - 2, (int)((double)pVia.y + vy + vy2) - h / 2 - 2, w + 4, h + 4);
        }
    }

    public void drawVirtualNodes(Collection<Way> ways) {
        if (this.virtualNodeSize != 0) {
            GeneralPath path = new GeneralPath();
            for (Way osm : ways) {
                if (!osm.isUsable() || osm.isFiltered() || osm.isDisabled()) continue;
                this.visitVirtual(path, osm);
            }
            this.g.setColor(this.nodeColor);
            this.g.draw(path);
        }
    }

    public void visitVirtual(GeneralPath path, Way w) {
        Iterator<Node> it = w.getNodes().iterator();
        if (it.hasNext()) {
            Point lastP = this.nc.getPoint(it.next());
            while (it.hasNext()) {
                Point p = this.nc.getPoint(it.next());
                if (this.isSegmentVisible(lastP, p) && MapPainter.isLargeSegment(lastP, p, this.virtualNodeSpace)) {
                    int x = (p.x + lastP.x) / 2;
                    int y = (p.y + lastP.y) / 2;
                    path.moveTo(x - this.virtualNodeSize, y);
                    path.lineTo(x + this.virtualNodeSize, y);
                    path.moveTo(x, y - this.virtualNodeSize);
                    path.lineTo(x, y + this.virtualNodeSize);
                }
                lastP = p;
            }
        }
    }

    private static boolean isLargeSegment(Point p1, Point p2, int space) {
        int yd;
        int xd = p1.x - p2.x;
        if (xd < 0) {
            xd = -xd;
        }
        if ((yd = p1.y - p2.y) < 0) {
            yd = -yd;
        }
        return xd + yd > space;
    }

    public void drawOrderNumber(Node n1, Node n2, int orderNumber) {
        Point p1 = this.nc.getPoint(n1);
        Point p2 = this.nc.getPoint(n2);
        this.drawOrderNumber(p1, p2, orderNumber);
    }

    protected void drawOrderNumber(Point p1, Point p2, int orderNumber) {
        if (this.isSegmentVisible(p1, p2) && MapPainter.isLargeSegment(p1, p2, this.segmentNumberSpace)) {
            String on = Integer.toString(orderNumber);
            int strlen = on.length();
            int x = (p1.x + p2.x) / 2 - 4 * strlen;
            int y = (p1.y + p2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && MapPainter.isLargeSegment(p1, p2, this.virtualNodeSpace)) {
                y = (p1.y + p2.y) / 2 - this.virtualNodeSize - 3;
            }
            Color c = this.g.getColor();
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(x - 1, y - 12, 8 * strlen + 1, 14);
            this.g.setColor(c);
            this.g.drawString(on, x, y);
        }
    }

    public String getNodeName(Node n) {
        String name;
        block1: {
            String rn;
            name = null;
            if (!n.hasKeys()) break block1;
            Iterator<String> i$ = this.regionalNameOrder.iterator();
            while (i$.hasNext() && (name = n.get(rn = i$.next())) == null) {
            }
        }
        return name;
    }

    public String getAreaName(OsmPrimitive w) {
        String name;
        block1: {
            String rn;
            name = null;
            if (!w.hasKeys()) break block1;
            Iterator<String> i$ = this.regionalNameOrder.iterator();
            while (i$.hasNext() && (name = w.get(rn = i$.next())) == null) {
            }
        }
        return name;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    public double getCircum() {
        return this.circum;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }
}

