/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryWay
extends HistoryOsmPrimitive {
    private ArrayList<Long> nodeIds = new ArrayList();

    public HistoryWay(long id, long version, boolean visible, String user, long uid, long changesetId, Date timestamp) {
        super(id, version, visible, user, uid, changesetId, timestamp);
    }

    public HistoryWay(long id, long version, boolean visible, String user, long uid, long changesetId, Date timestamp, ArrayList<Long> nodeIdList) {
        this(id, version, visible, user, uid, changesetId, timestamp);
        this.nodeIds.addAll(nodeIdList);
    }

    public int getNumNodes() {
        return this.nodeIds.size();
    }

    public long getNodeId(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.nodeIds.size()) {
            throw new IndexOutOfBoundsException(I18n.tr("Parameter {0} not in range 0..{1}. Got ''{2}''.", "idx", this.nodeIds.size(), idx));
        }
        return this.nodeIds.get(idx);
    }

    public List<Long> getNodes() {
        return Collections.unmodifiableList(this.nodeIds);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    public void addNode(long ref) {
        this.nodeIds.add(ref);
    }

    public boolean isClosed() {
        return this.getNumNodes() >= 3 && this.nodeIds.get(0) == this.nodeIds.get(this.nodeIds.size() - 1);
    }

    @Override
    public String getDisplayName(HistoryNameFormatter formatter) {
        return formatter.format(this);
    }
}

