/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsmPrimitive
implements Comparable<OsmPrimitive>,
Tagged,
PrimitiveId {
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private static final int FLAG_MODIFIED = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_DISABLED = 4;
    private static final int FLAG_DELETED = 8;
    private static final int FLAG_HIDE_IF_DISABLED = 16;
    private static final int FLAG_HAS_DIRECTIONS = 32;
    private static final int FLAG_TAGGED = 64;
    private static final int FLAG_DIRECTION_REVERSED = 128;
    private static final int FLAG_HIGHLIGHTED = 256;
    private static final int FLAG_INCOMPLETE = 512;
    public static final Predicate<OsmPrimitive> isUsablePredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.isUsable();
        }
    };
    public static final Predicate<OsmPrimitive> isSelectablePredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.isSelectable();
        }
    };
    public static final Predicate<OsmPrimitive> nonDeletedPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return !primitive.isDeleted();
        }
    };
    public static final Predicate<OsmPrimitive> nonDeletedCompletePredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return !primitive.isDeleted() && !primitive.isIncomplete();
        }
    };
    public static final Predicate<OsmPrimitive> nonDeletedPhysicalPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return !primitive.isDeleted() && !primitive.isIncomplete() && !(primitive instanceof Relation);
        }
    };
    public static final Predicate<OsmPrimitive> modifiedPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.isModified();
        }
    };
    public static final Predicate<OsmPrimitive> nodePredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.getClass() == Node.class;
        }
    };
    public static final Predicate<OsmPrimitive> wayPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.getClass() == Way.class;
        }
    };
    public static final Predicate<OsmPrimitive> relationPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return primitive.getClass() == Relation.class;
        }
    };
    public static final Predicate<OsmPrimitive> allPredicate = new Predicate<OsmPrimitive>(){

        @Override
        public boolean evaluate(OsmPrimitive primitive) {
            return true;
        }
    };
    public ElemStyle mappaintStyle = null;
    public int mappaintDrawnCode = 0;
    private DataSet dataSet;
    private long id = 0L;
    private User user = null;
    private int version = 0;
    private int changesetId;
    private int timestamp;
    private volatile short flags = (short)2;
    private static volatile Collection<String> uninteresting = null;
    private static volatile SearchCompiler.Match directionKeys = null;
    private static volatile SearchCompiler.Match reversedDirectionKeys = null;
    private String[] keys;
    private Object referrers;

    static long generateUniqueId() {
        return idCounter.decrementAndGet();
    }

    public static <T extends OsmPrimitive> List<T> getFilteredList(Collection<OsmPrimitive> list, Class<T> type) {
        if (list == null) {
            return Collections.emptyList();
        }
        LinkedList<T> ret = new LinkedList<T>();
        for (OsmPrimitive p : list) {
            if (!type.isInstance(p)) continue;
            ret.add(type.cast(p));
        }
        return ret;
    }

    public static <T extends OsmPrimitive> LinkedHashSet<T> getFilteredSet(Collection<OsmPrimitive> set, Class<T> type) {
        LinkedHashSet<T> ret = new LinkedHashSet<T>();
        if (set != null) {
            for (OsmPrimitive p : set) {
                if (!type.isInstance(p)) continue;
                ret.add(type.cast(p));
            }
        }
        return ret;
    }

    public static Set<OsmPrimitive> getReferrer(Collection<? extends OsmPrimitive> primitives) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        if (primitives == null || primitives.isEmpty()) {
            return ret;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            ret.addAll(osmPrimitive.getReferrers());
        }
        return ret;
    }

    protected OsmPrimitive(long id, boolean allowNegativeId) throws IllegalArgumentException {
        if (allowNegativeId) {
            this.id = id;
        } else {
            if (id < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("Expected ID >= 0. Got {0}.", id));
            }
            this.id = id == 0L ? OsmPrimitive.generateUniqueId() : id;
        }
        this.version = 0;
        this.setIncomplete(id > 0L);
    }

    protected OsmPrimitive(long id, int version, boolean allowNegativeId) throws IllegalArgumentException {
        this(id, allowNegativeId);
        this.version = id > 0L ? version : 0;
        this.setIncomplete(id > 0L && version == 0);
    }

    protected void clearCached() {
        this.mappaintDrawnCode = 0;
        this.mappaintStyle = null;
    }

    void setDataset(DataSet dataSet) {
        if (this.dataSet != null && dataSet != null && this.dataSet != dataSet) {
            throw new DataIntegrityProblemException("Primitive cannot be included in more than one Dataset");
        }
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void checkDataset() {
        if (this.dataSet == null) {
            throw new DataIntegrityProblemException("Primitive  must be part of the dataset: " + this.toString());
        }
    }

    protected boolean writeLock() {
        if (this.dataSet != null) {
            this.dataSet.beginUpdate();
            return true;
        }
        return false;
    }

    protected void writeUnlock(boolean locked) {
        if (locked) {
            this.dataSet.endUpdate();
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getId() {
        long id = this.id;
        return id >= 0L ? id : 0L;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    public boolean isNewOrUndeleted() {
        return this.id <= 0L || (this.flags & 0xA) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOsmId(long id, int version) {
        boolean locked = this.writeLock();
        try {
            if (id <= 0L) {
                throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", id));
            }
            if (version <= 0) {
                throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", version));
            }
            if (this.dataSet != null && id != this.id) {
                DataSet datasetCopy = this.dataSet;
                datasetCopy.removePrimitive(this);
                this.id = id;
                datasetCopy.addPrimitive(this);
            }
            this.id = id;
            this.version = version;
            this.setIncomplete(false);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public void clearOsmId() {
        if (this.dataSet != null) {
            throw new DataIntegrityProblemException("Method cannot be called after primitive was added to the dataset");
        }
        this.id = OsmPrimitive.generateUniqueId();
        this.version = 0;
        this.changesetId = 0;
        this.setIncomplete(false);
    }

    public User getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(User user) {
        boolean locked = this.writeLock();
        try {
            this.user = user;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public int getChangesetId() {
        return this.changesetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangesetId(int changesetId) throws IllegalStateException, IllegalArgumentException {
        boolean locked = this.writeLock();
        try {
            if (this.changesetId == changesetId) {
                return;
            }
            if (changesetId < 0) {
                throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected, got {1}", "changesetId", changesetId));
            }
            if (this.isNew() && changesetId > 0) {
                throw new IllegalStateException(I18n.tr("Cannot assign a changesetId > 0 to a new primitive. Value of changesetId is {0}", changesetId));
            }
            int old = this.changesetId;
            this.changesetId = changesetId;
            if (this.dataSet != null) {
                this.dataSet.fireChangesetIdChanged(this, old, changesetId);
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.getUniqueId(), this.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(Date timestamp) {
        boolean locked = this.writeLock();
        try {
            this.timestamp = (int)(timestamp.getTime() / 1000L);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public Date getTimestamp() {
        return new Date((long)this.timestamp * 1000L);
    }

    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    private void updateFlagsNoLock(int flag, boolean value) {
        this.flags = value ? (short)(this.flags | flag) : (short)(this.flags & ~flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlags(int flag, boolean value) {
        boolean locked = this.writeLock();
        try {
            this.updateFlagsNoLock(flag, value);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabledState(boolean hide) {
        boolean locked = this.writeLock();
        try {
            this.updateFlagsNoLock(4, true);
            this.updateFlagsNoLock(16, hide);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public void unsetDisabledState() {
        this.updateFlags(20, false);
    }

    public boolean isDisabled() {
        return (this.flags & 4) != 0;
    }

    public boolean isDisabledAndHidden() {
        return (this.flags & 4) != 0 && (this.flags & 0x10) != 0;
    }

    @Deprecated
    public boolean isFiltered() {
        return this.isDisabledAndHidden();
    }

    public void setModified(boolean modified) {
        this.updateFlags(1, modified);
    }

    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    public boolean isDeleted() {
        return (this.flags & 8) != 0;
    }

    public boolean isUndeleted() {
        return (this.flags & 0xA) == 0;
    }

    public boolean isUsable() {
        return (this.flags & 0x208) == 0;
    }

    public boolean isSelectable() {
        return (this.flags & 0x21C) == 0;
    }

    public boolean isDrawable() {
        return (this.flags & 0x218) == 0;
    }

    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) throws IllegalStateException {
        boolean locked = this.writeLock();
        try {
            if (this.isNew() && !visible) {
                throw new IllegalStateException(I18n.tr("A primitive with ID = 0 cannot be invisible."));
            }
            this.updateFlagsNoLock(2, visible);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeleted(boolean deleted) {
        boolean locked = this.writeLock();
        try {
            this.updateFlagsNoLock(8, deleted);
            this.setModified(deleted ^ !this.isVisible());
            if (this.dataSet != null) {
                if (deleted) {
                    this.dataSet.firePrimitivesRemoved(Collections.singleton(this), false);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singleton(this), false);
                }
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIncomplete(boolean incomplete) {
        boolean locked = this.writeLock();
        try {
            if (this.dataSet != null && incomplete != this.isIncomplete()) {
                if (incomplete) {
                    this.dataSet.firePrimitivesRemoved(Collections.singletonList(this), true);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singletonList(this), true);
                }
            }
            this.updateFlagsNoLock(512, incomplete);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public boolean isIncomplete() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isSelected() {
        return this.dataSet != null && this.dataSet.isSelected(this);
    }

    public void setHighlighted(boolean highlighted) {
        if (this.isHighlighted() != highlighted) {
            this.updateFlags(256, highlighted);
            if (this.dataSet != null) {
                this.dataSet.fireHighlightingChanged(this);
            }
        }
    }

    public boolean isHighlighted() {
        return (this.flags & 0x100) != 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            uninteresting = Main.pref.getCollection("tags.uninteresting", Arrays.asList("source", "source_ref", "source:", "note", "comment", "converted_by", "created_by", "watch", "watch:", "fixme", "FIXME", "description"));
        }
        return uninteresting;
    }

    public static boolean isUninterestingKey(String key) {
        OsmPrimitive.getUninterestingKeys();
        if (uninteresting.contains(key)) {
            return true;
        }
        int pos = key.indexOf(58);
        if (pos > 0) {
            return uninteresting.contains(key.substring(0, pos + 1));
        }
        return false;
    }

    private void updateTagged() {
        if (this.keys != null) {
            for (String key : this.keySet()) {
                if (OsmPrimitive.isUninterestingKey(key)) continue;
                this.updateFlagsNoLock(64, true);
                return;
            }
        }
        this.updateFlagsNoLock(64, false);
    }

    public boolean isTagged() {
        return (this.flags & 0x40) != 0;
    }

    private void updateDirectionFlags() {
        boolean hasDirections = false;
        boolean directionReversed = false;
        if (reversedDirectionKeys.match(this)) {
            hasDirections = true;
            directionReversed = true;
        }
        if (directionKeys.match(this)) {
            hasDirections = true;
        }
        this.updateFlagsNoLock(128, directionReversed);
        this.updateFlagsNoLock(32, hasDirections);
    }

    public boolean hasDirectionKeys() {
        return (this.flags & 0x20) != 0;
    }

    public boolean reversedDirection() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public Map<String, String> getKeys() {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] keys = this.keys;
        if (keys != null) {
            for (int i = 0; i < keys.length; i += 2) {
                result.put(keys[i], keys[i + 1]);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeys(Map<String, String> keys) {
        boolean locked = this.writeLock();
        try {
            Map<String, String> originalKeys = this.getKeys();
            if (keys == null || keys.isEmpty()) {
                this.keys = null;
                this.keysChangedImpl(originalKeys);
                return;
            }
            String[] newKeys = new String[keys.size() * 2];
            int index = 0;
            for (Map.Entry<String, String> entry : keys.entrySet()) {
                newKeys[index++] = entry.getKey();
                newKeys[index++] = entry.getValue();
            }
            this.keys = newKeys;
            this.keysChangedImpl(originalKeys);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(String key, String value) {
        boolean locked = this.writeLock();
        try {
            Map<String, String> originalKeys = this.getKeys();
            if (key == null) {
                return;
            }
            if (value == null) {
                this.remove(key);
            } else if (this.keys == null) {
                this.keys = new String[]{key, value};
                this.keysChangedImpl(originalKeys);
            } else {
                for (int i = 0; i < this.keys.length; i += 2) {
                    if (!this.keys[i].equals(key)) continue;
                    this.keys[i + 1] = value;
                    this.keysChangedImpl(originalKeys);
                    return;
                }
                String[] newKeys = new String[this.keys.length + 2];
                for (int i = 0; i < this.keys.length; i += 2) {
                    newKeys[i] = this.keys[i];
                    newKeys[i + 1] = this.keys[i + 1];
                }
                newKeys[this.keys.length] = key;
                newKeys[this.keys.length + 1] = value;
                this.keys = newKeys;
                this.keysChangedImpl(originalKeys);
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove(String key) {
        boolean locked = this.writeLock();
        try {
            if (key == null || this.keys == null) {
                return;
            }
            if (!this.hasKey(key)) {
                return;
            }
            Map<String, String> originalKeys = this.getKeys();
            if (this.keys.length == 2) {
                this.keys = null;
                this.keysChangedImpl(originalKeys);
                return;
            }
            String[] newKeys = new String[this.keys.length - 2];
            int j = 0;
            for (int i = 0; i < this.keys.length; i += 2) {
                if (this.keys[i].equals(key)) continue;
                newKeys[j++] = this.keys[i];
                newKeys[j++] = this.keys[i + 1];
            }
            this.keys = newKeys;
            this.keysChangedImpl(originalKeys);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAll() {
        boolean locked = this.writeLock();
        try {
            if (this.keys != null) {
                Map<String, String> originalKeys = this.getKeys();
                this.keys = null;
                this.keysChangedImpl(originalKeys);
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    @Override
    public final String get(String key) {
        String[] keys = this.keys;
        if (key == null) {
            return null;
        }
        if (keys == null) {
            return null;
        }
        for (int i = 0; i < keys.length; i += 2) {
            if (!keys[i].equals(key)) continue;
            return keys[i + 1];
        }
        return null;
    }

    @Override
    public final Collection<String> keySet() {
        String[] keys = this.keys;
        if (keys == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(keys.length / 2);
        for (int i = 0; i < keys.length; i += 2) {
            result.add(keys[i]);
        }
        return result;
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null;
    }

    private void keysChangedImpl(Map<String, String> originalKeys) {
        this.clearCached();
        this.updateDirectionFlags();
        this.updateTagged();
        if (this.dataSet != null) {
            this.dataSet.fireTagsChanged(this, originalKeys);
        }
    }

    public boolean hasKey(String key) {
        String[] keys = this.keys;
        if (key == null) {
            return false;
        }
        if (keys == null) {
            return false;
        }
        for (int i = 0; i < keys.length; i += 2) {
            if (!keys[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSameTags(OsmPrimitive other) {
        return ((Object)this.getKeys()).equals(other.getKeys());
    }

    protected void addReferrer(OsmPrimitive referrer) {
        if (this.referrers == null) {
            this.referrers = referrer;
        } else if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers != referrer) {
                this.referrers = new OsmPrimitive[]{(OsmPrimitive)this.referrers, referrer};
            }
        } else {
            for (OsmPrimitive primitive : (OsmPrimitive[])this.referrers) {
                if (primitive != referrer) continue;
                return;
            }
            OsmPrimitive[] orig = (OsmPrimitive[])this.referrers;
            OsmPrimitive[] bigger = new OsmPrimitive[orig.length + 1];
            System.arraycopy(orig, 0, bigger, 0, orig.length);
            bigger[orig.length] = referrer;
            this.referrers = bigger;
        }
    }

    protected void removeReferrer(OsmPrimitive referrer) {
        if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers == referrer) {
                this.referrers = null;
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] orig = (OsmPrimitive[])this.referrers;
            int idx = -1;
            for (int i = 0; i < orig.length; ++i) {
                if (orig[i] != referrer) continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                return;
            }
            if (orig.length == 2) {
                this.referrers = orig[1 - idx];
            } else {
                OsmPrimitive[] smaller = new OsmPrimitive[orig.length - 1];
                System.arraycopy(orig, 0, smaller, 0, idx);
                System.arraycopy(orig, idx + 1, smaller, idx, smaller.length - idx);
                this.referrers = smaller;
            }
        }
    }

    public final List<OsmPrimitive> getReferrers() {
        this.checkDataset();
        Object referrers = this.referrers;
        ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>();
        if (referrers != null) {
            if (referrers instanceof OsmPrimitive) {
                OsmPrimitive ref = (OsmPrimitive)referrers;
                if (ref.dataSet == this.dataSet) {
                    result.add(ref);
                }
            } else {
                for (OsmPrimitive o : (OsmPrimitive[])referrers) {
                    if (this.dataSet != o.dataSet) continue;
                    result.add(o);
                }
            }
        }
        return result;
    }

    public abstract void visit(Visitor var1);

    public void cloneFrom(OsmPrimitive other) {
        if (this.id != other.id && this.dataSet != null) {
            throw new DataIntegrityProblemException("Osm id cannot be changed after primitive was added to the dataset");
        }
        this.setKeys(other.getKeys());
        this.id = other.id;
        if (this.id <= 0L) {
            this.version = 0;
            this.changesetId = 0;
        }
        this.timestamp = other.timestamp;
        if (this.id > 0L) {
            this.version = other.version;
        }
        this.setIncomplete(other.isIncomplete());
        this.flags = other.flags;
        this.user = other.user;
        if (this.id > 0L && other.changesetId > 0) {
            this.setChangesetId(other.changesetId);
        }
        this.clearCached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFrom(OsmPrimitive other) {
        boolean locked = this.writeLock();
        try {
            CheckParameterUtil.ensureParameterNotNull(other, "other");
            if (other.isNew() ^ this.isNew()) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge because either of the participating primitives is new and the other is not"));
            }
            if (!other.isNew() && other.getId() != this.id) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge primitives with different ids. This id is {0}, the other is {1}", this.id, other.getId()));
            }
            this.setKeys(other.getKeys());
            this.timestamp = other.timestamp;
            this.version = other.version;
            this.setIncomplete(other.isIncomplete());
            this.flags = other.flags;
            this.user = other.user;
            this.changesetId = other.changesetId;
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (!this.isNew() && this.id != other.id) {
            return false;
        }
        if (this.isIncomplete() && !other.isIncomplete() || !this.isIncomplete() && other.isIncomplete()) {
            return false;
        }
        return this.hasSameTags(other);
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive other) {
        if (other == null) {
            return false;
        }
        return this.isDeleted() == other.isDeleted() && this.isModified() == other.isModified() && this.timestamp == other.timestamp && this.version == other.version && this.isVisible() == other.isVisible() && (this.user == null ? other.user == null : this.user == other.user) && this.changesetId == other.changesetId;
    }

    public String getName() {
        return this.get("name");
    }

    public String getLocalName() {
        String key = "name:" + Locale.getDefault().toString();
        if (this.get(key) != null) {
            return this.get(key);
        }
        key = "name:" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (this.get(key) != null) {
            return this.get(key);
        }
        key = "name:" + Locale.getDefault().getLanguage();
        if (this.get(key) != null) {
            return this.get(key);
        }
        return this.getName();
    }

    public abstract String getDisplayName(NameFormatter var1);

    public void load(PrimitiveData data) {
        this.setKeys(data.getKeys());
        this.setTimestamp(data.getTimestamp());
        this.user = data.getUser();
        this.setChangesetId(data.getChangesetId());
        this.setDeleted(data.isDeleted());
        this.setModified(data.isModified());
        this.setVisible(data.isVisible());
        this.setIncomplete(data.isIncomplete());
        this.version = data.getVersion();
    }

    public abstract PrimitiveData save();

    protected void saveCommonAttributes(PrimitiveData data) {
        data.setId(this.id);
        data.getKeys().clear();
        data.getKeys().putAll(this.getKeys());
        data.setTimestamp(this.getTimestamp());
        data.setUser(this.user);
        data.setDeleted(this.isDeleted());
        data.setModified(this.isModified());
        data.setVisible(this.isVisible());
        data.setIncomplete(this.isIncomplete());
        data.setChangesetId(this.changesetId);
        data.setVersion(this.version);
    }

    public abstract BBox getBBox();

    public abstract void updatePosition();

    protected String getFlagsAsString() {
        StringBuilder builder = new StringBuilder();
        if (this.isIncomplete()) {
            builder.append("I");
        }
        if (this.isModified()) {
            builder.append("M");
        }
        if (this.isVisible()) {
            builder.append("V");
        }
        if (this.isDeleted()) {
            builder.append("D");
        }
        if (this.isFiltered()) {
            builder.append("f");
        }
        if (this.isDisabled()) {
            builder.append("d");
        }
        if (this.isTagged()) {
            builder.append("T");
        }
        if (this.hasDirectionKeys()) {
            if (this.reversedDirection()) {
                builder.append("<");
            } else {
                builder.append(">");
            }
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OsmPrimitive) {
            return ((OsmPrimitive)obj).id == this.id && obj.getClass() == this.getClass();
        }
        return false;
    }

    public final int hashCode() {
        return (int)this.id;
    }

    static {
        if (Main.pref.isCollection("tags.direction", false)) {
            System.out.println("Collection of keys in tags.direction is no longer supported, value will converted to search pattern");
            Collection<String> keys = Main.pref.getCollection("tags.direction", null);
            StringBuilder builder = new StringBuilder();
            for (String key : keys) {
                builder.append(key);
                builder.append("=* | ");
            }
            builder.delete(builder.length() - 3, builder.length());
            Main.pref.put("tags.direction", builder.toString());
        }
        String reversedDirectionDefault = "oneway=\"-1\" | incline=down | incline=\"-*\"";
        String directionDefault = "oneway? | incline=* | aerialway=* | waterway=stream | waterway=river | waterway=canal | waterway=drain | waterway=rapids | \"piste:type\"=downhill | \"piste:type\"=sled | man_made=\"piste:halfpipe\" | junction=roundabout";
        try {
            reversedDirectionKeys = SearchCompiler.compile(Main.pref.get("tags.reversed_direction", reversedDirectionDefault), false, false);
        }
        catch (SearchCompiler.ParseError e) {
            System.err.println("Unable to compile pattern for tags.reversed_direction, trying default pattern: " + e.getMessage());
            try {
                reversedDirectionKeys = SearchCompiler.compile(reversedDirectionDefault, false, false);
            }
            catch (SearchCompiler.ParseError e2) {
                throw new AssertionError((Object)("Unable to compile default pattern for direction keys: " + e2.getMessage()));
            }
        }
        try {
            directionKeys = SearchCompiler.compile(Main.pref.get("tags.direction", directionDefault), false, false);
        }
        catch (SearchCompiler.ParseError e) {
            System.err.println("Unable to compile pattern for tags.direction, trying default pattern: " + e.getMessage());
            try {
                directionKeys = SearchCompiler.compile(directionDefault, false, false);
            }
            catch (SearchCompiler.ParseError e2) {
                throw new AssertionError((Object)("Unable to compile default pattern for direction keys: " + e2.getMessage()));
            }
        }
    }
}

