/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

public final class Node
extends OsmPrimitive {
    private CachedLatLon coor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCoor(LatLon coor) {
        if (coor != null) {
            if (this.getDataSet() != null) {
                boolean locked = this.writeLock();
                try {
                    this.getDataSet().fireNodeMoved(this, coor);
                }
                finally {
                    this.writeUnlock(locked);
                }
            } else {
                this.setCoorInternal(coor);
            }
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        if (eastNorth != null) {
            this.setCoor(Main.proj.eastNorth2latlon(eastNorth));
        }
    }

    public final EastNorth getEastNorth() {
        return this.coor != null ? this.coor.getEastNorth() : null;
    }

    protected void setCoorInternal(LatLon coor) {
        if (this.coor == null) {
            this.coor = new CachedLatLon(coor);
        } else {
            this.coor.setCoor(coor);
        }
    }

    protected Node(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Node() {
        this(0L, false);
    }

    public Node(long id) {
        super(id, false);
    }

    public Node(long id, int version) {
        super(id, version, false);
    }

    public Node(Node clone, boolean clearId) {
        super(clone.getUniqueId(), true);
        this.cloneFrom(clone);
        if (clearId) {
            this.clearOsmId();
        }
    }

    public Node(Node clone) {
        this(clone, false);
    }

    public Node(LatLon latlon) {
        super(0L, false);
        this.setCoor(latlon);
    }

    public Node(EastNorth eastNorth) {
        super(0L, false);
        this.setEastNorth(eastNorth);
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneFrom(OsmPrimitive osm) {
        boolean locked = this.writeLock();
        try {
            super.cloneFrom(osm);
            this.setCoor(((Node)osm).coor);
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFrom(OsmPrimitive other) {
        boolean locked = this.writeLock();
        try {
            super.mergeFrom(other);
            if (!other.isIncomplete()) {
                this.setCoor(new LatLon(((Node)other).coor));
            }
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(PrimitiveData data) {
        boolean locked = this.writeLock();
        try {
            super.load(data);
            this.setCoor(((NodeData)data).getCoor());
        }
        finally {
            this.writeUnlock(locked);
        }
    }

    public NodeData save() {
        NodeData data = new NodeData();
        this.saveCommonAttributes(data);
        if (!this.isIncomplete()) {
            data.setCoor(this.getCoor());
        }
        return data;
    }

    public String toString() {
        String coorDesc = this.coor == null ? "" : "lat=" + this.coor.lat() + ",lon=" + this.coor.lon();
        return "{Node id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + coorDesc + "}";
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (other == null || !(other instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(other)) {
            return false;
        }
        Node n = (Node)other;
        if (this.coor == null && n.coor == null) {
            return true;
        }
        if (this.coor != null && n.coor != null) {
            return this.coor.equalsEpsilon(n.coor);
        }
        return false;
    }

    public int compareTo(OsmPrimitive o) {
        return o instanceof Node ? Long.valueOf(this.getUniqueId()).compareTo(o.getUniqueId()) : 1;
    }

    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    public BBox getBBox() {
        return new BBox(this);
    }

    public void updatePosition() {
    }

    public boolean isConnectionNode() {
        return OsmPrimitive.getFilteredList(this.getReferrers(), Way.class).size() > 1;
    }

    public String get3892DebugInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("Unexpected error. Please report it to http://josm.openstreetmap.de/ticket/3892\n");
        builder.append(this.toString());
        builder.append("\n");
        if (this.coor == null) {
            builder.append("Coor is null\n");
        } else {
            builder.append(String.format("EastNorth: %s\n", this.coor.getEastNorth()));
            builder.append(this.coor.getProjection());
            builder.append("\n");
        }
        return builder.toString();
    }
}

