/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version {
    public static final int JOSM_UNKNOWN_VERSION = 0;
    private static Version instance;
    private int version;
    private String revision;
    private String time;
    private boolean isLocalBuild;

    public static String loadResourceFile(URL resource) {
        if (resource == null) {
            return null;
        }
        String s = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(resource.openStream()));
            StringBuffer sb = new StringBuffer();
            String line = in.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = in.readLine();
            }
            s = sb.toString();
        }
        catch (IOException e) {
            System.err.println(I18n.tr("Failed to load resource ''{0}'', error is {1}.", resource.toString(), e.toString()));
            e.printStackTrace();
        }
        return s;
    }

    public static Version getInstance() {
        if (instance == null) {
            instance = new Version();
            instance.init();
        }
        return instance;
    }

    protected HashMap<String, String> parseManifestStyleFormattedString(String content) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (content == null) {
            return properties;
        }
        Pattern p = Pattern.compile("^([^:]+):(.*)$");
        for (String line : content.split("\n")) {
            Matcher m;
            if (line == null || line.trim().equals("") || line.matches("^\\s*#.*$") || !(m = p.matcher(line)).matches()) continue;
            properties.put(m.group(1), m.group(2));
        }
        return properties;
    }

    protected void initFromRevisionInfo(String revisionInfo) {
        if (revisionInfo == null) {
            this.revision = I18n.tr("UNKNOWN");
            this.version = 0;
            this.time = null;
            return;
        }
        HashMap<String, String> properties = this.parseManifestStyleFormattedString(revisionInfo);
        String value = properties.get("Revision");
        if (value != null) {
            value = value.trim();
            try {
                this.version = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.version = 0;
                System.err.println(I18n.tr("Warning: unexpected JOSM version number in revison file, value is ''{0}''", value));
            }
        } else {
            this.version = 0;
        }
        this.time = properties.get("Last Changed Date");
        if (this.time == null) {
            this.time = properties.get("Build-Date");
        }
        this.isLocalBuild = false;
        value = properties.get("Is-Local-Build");
        if (value != null && value.trim().toLowerCase().equals("true")) {
            this.isLocalBuild = true;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            sb.append(property.getKey()).append(":").append(property.getValue()).append("\n");
        }
        this.revision = sb.toString();
    }

    public void init() {
        URL u = Main.class.getResource("/REVISION");
        if (u == null) {
            System.err.println(I18n.tr("Warning: the revision file ''/REVISION'' is missing."));
            this.version = 0;
            this.revision = "";
            return;
        }
        this.initFromRevisionInfo(Version.loadResourceFile(u));
        System.out.println(this.revision);
    }

    public String getVersionString() {
        return this.version == 0 ? I18n.tr("UNKNOWN") : Integer.toString(this.version);
    }

    public String getReleaseAttributes() {
        return this.revision;
    }

    public String getTime() {
        return this.time;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isLocalBuild() {
        return this.isLocalBuild;
    }

    public String getAgentString() {
        String s;
        int v = this.getVersion();
        String string = s = v == 0 ? "UNKNOWN" : Integer.toString(v);
        if (this.isLocalBuild() && v != 0) {
            s = s + " SVN";
        }
        return "JOSM/1.5 (" + s + " " + LanguageInfo.getJOSMLocaleCode() + ")";
    }
}

