/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPrimitivesCommand
extends Command {
    private final List<PrimitiveData> data = new ArrayList<PrimitiveData>();

    public AddPrimitivesCommand(List<PrimitiveData> data) {
        this.data.addAll(data);
    }

    @Override
    public boolean executeCommand() {
        int i;
        ArrayList<OsmPrimitive> createdPrimitives = new ArrayList<OsmPrimitive>(this.data.size());
        for (PrimitiveData pd : this.data) {
            createdPrimitives.add(this.getLayer().data.getPrimitiveById(pd, true));
        }
        for (i = 0; i < createdPrimitives.size(); ++i) {
            if (!(createdPrimitives.get(i) instanceof Node)) continue;
            ((OsmPrimitive)createdPrimitives.get(i)).load(this.data.get(i));
        }
        for (i = 0; i < createdPrimitives.size(); ++i) {
            if (createdPrimitives.get(i) instanceof Node) continue;
            ((OsmPrimitive)createdPrimitives.get(i)).load(this.data.get(i));
        }
        this.getLayer().data.setSelected(createdPrimitives);
        return true;
    }

    @Override
    public void undoCommand() {
        for (PrimitiveData p : this.data) {
            this.getLayer().data.removePrimitive(p);
        }
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.trn("Added {0} object", "Added {0} objects", this.data.size(), this.data.size()), null, 0);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet<OsmPrimitive> prims = new HashSet<OsmPrimitive>();
        for (PrimitiveData d : this.data) {
            OsmPrimitive osm = this.getLayer().data.getPrimitiveById(d);
            if (osm == null) {
                throw new RuntimeException();
            }
            prims.add(osm);
        }
        return prims;
    }
}

