/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.I18n;

public class PlayHeadDragMode
extends MapMode {
    private boolean dragging = false;
    private Point mousePos = null;
    private Point mouseStart = null;
    private PlayHeadMarker playHeadMarker = null;

    public PlayHeadDragMode(PlayHeadMarker m) {
        super(I18n.tr("Drag play head"), "playheaddrag", I18n.tr("Drag play head"), null, Main.map, Cursor.getPredefinedCursor(13));
        this.playHeadMarker = m;
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent ev) {
        this.mouseStart = this.mousePos = ev.getPoint();
    }

    public void mouseDragged(MouseEvent ev) {
        if (this.mouseStart == null || this.mousePos == null) {
            return;
        }
        if ((ev.getModifiersEx() & 0x400) == 0) {
            return;
        }
        Point p = ev.getPoint();
        if (p == null) {
            return;
        }
        if (!this.dragging) {
            if (p.distance(this.mouseStart) < 3.0) {
                return;
            }
            this.playHeadMarker.startDrag();
            this.dragging = true;
        }
        if (p.distance(this.mousePos) == 0.0) {
            return;
        }
        this.playHeadMarker.drag(Main.map.mapView.getEastNorth(ev.getX(), ev.getY()));
        this.mousePos = p;
    }

    public void mouseReleased(MouseEvent ev) {
        Point p = ev.getPoint();
        this.mouseStart = null;
        if (ev.getButton() != 1 || p == null || !this.dragging) {
            return;
        }
        boolean shift = (ev.getModifiers() & 1) != 0;
        EastNorth en = Main.map.mapView.getEastNorth(ev.getX(), ev.getY());
        if (!shift) {
            this.playHeadMarker.reposition(en);
        } else {
            this.playHeadMarker.synchronize(en);
        }
        this.mousePos = null;
        this.dragging = false;
    }

    public String getModeHelpText() {
        return I18n.tr("Drag play head and release near track to play audio from there; SHIFT+release to synchronize audio at that point.");
    }
}

