/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnGlueAction
extends JosmAction {
    private Node selectedNode;
    private Way selectedWay;
    private ArrayList<Node> selectedNodes;

    public UnGlueAction() {
        super(I18n.tr("UnGlue Ways"), "unglueways", I18n.tr("Duplicate nodes that are used by multiple ways."), Shortcut.registerShortcut("tools:unglue", I18n.tr("Tool: {0}", I18n.tr("UnGlue Ways")), 71, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/UnGlue"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        String errMsg = null;
        if (this.checkSelection(selection)) {
            int count = 0;
            for (Way w : OsmPrimitive.getFilteredList(this.selectedNode.getReferrers(), Way.class)) {
                if (!w.isUsable() || w.getNodesCount() < 1) continue;
                ++count;
            }
            if (count < 2) {
                if (this.checkForUnglueNode(selection)) {
                    this.unglueNode(e);
                } else {
                    errMsg = I18n.tr("This node is not glued to anything else.");
                }
            } else {
                this.unglueWays();
            }
        } else if (this.checkSelection2(selection)) {
            ArrayList<Node> tmpNodes = new ArrayList<Node>();
            for (Node n : this.selectedNodes) {
                int count = 0;
                for (Way w : OsmPrimitive.getFilteredList(n.getReferrers(), Way.class)) {
                    if (!w.isUsable()) continue;
                    ++count;
                }
                if (count < 2) continue;
                tmpNodes.add(n);
            }
            if (tmpNodes.size() < 1) {
                errMsg = selection.size() > 1 ? I18n.tr("None of these nodes are glued to anything else.") : I18n.tr("None of this way''s nodes are glued to anything else.");
            } else {
                this.selectedNodes = tmpNodes;
                this.unglueWays2();
            }
        } else {
            errMsg = I18n.tr("The current selection cannot be used for unglueing.") + "\n" + "\n" + I18n.tr("Select either:") + "\n" + I18n.tr("* One tagged node, or") + "\n" + I18n.tr("* One node that is used by more than one way, or") + "\n" + I18n.tr("* One node that is used by more than one way and one of those ways, or") + "\n" + I18n.tr("* One way that has one or more nodes that are used by more than one way, or") + "\n" + I18n.tr("* One way and one or more of its nodes that are used by more than one way.") + "\n" + "\n" + I18n.tr("Note: If a way is selected, this way will get fresh copies of the unglued\nnodes and the new nodes will be selected. Otherwise, all ways will get their\nown copy and all nodes will be selected.");
        }
        if (errMsg != null) {
            JOptionPane.showMessageDialog(Main.parent, errMsg, I18n.tr("Error"), 0);
        }
        this.selectedNode = null;
        this.selectedWay = null;
        this.selectedNodes = null;
    }

    private void unglueNode(ActionEvent e) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        Node c = new Node(this.selectedNode);
        c.removeAll();
        this.getCurrentDataSet().clearSelection(c);
        cmds.add(new ChangeCommand(this.selectedNode, c));
        Node n = new Node(this.selectedNode, true);
        if (e.getSource() instanceof JPanel) {
            MapView mv = Main.map.mapView;
            n.setCoor(mv.getLatLon(mv.lastMEvent.getX(), mv.lastMEvent.getY()));
        }
        cmds.add(new AddCommand(n));
        this.fixRelations(this.selectedNode, cmds, Collections.singletonList(n));
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Unglued Node"), cmds));
        this.getCurrentDataSet().setSelected(n);
        Main.map.mapView.repaint();
    }

    private boolean checkForUnglueNode(Collection<? extends OsmPrimitive> selection) {
        if (selection.size() != 1) {
            return false;
        }
        OsmPrimitive n = (OsmPrimitive)selection.toArray()[0];
        if (!(n instanceof Node)) {
            return false;
        }
        if (OsmPrimitive.getFilteredList(n.getReferrers(), Way.class).isEmpty()) {
            return false;
        }
        this.selectedNode = (Node)n;
        return this.selectedNode.isTagged();
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> selection) {
        int size = selection.size();
        if (size < 1 || size > 2) {
            return false;
        }
        this.selectedNode = null;
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Node) {
                this.selectedNode = (Node)osmPrimitive;
                if (size != 1 && this.selectedWay == null) continue;
                return size == 1 || this.selectedWay.containsNode(this.selectedNode);
            }
            if (!(osmPrimitive instanceof Way)) continue;
            this.selectedWay = (Way)osmPrimitive;
            if (size != 2 || this.selectedNode == null) continue;
            return this.selectedWay.containsNode(this.selectedNode);
        }
        return false;
    }

    private boolean checkSelection2(Collection<? extends OsmPrimitive> selection) {
        if (selection.size() < 1) {
            return false;
        }
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Way)) continue;
            if (this.selectedWay != null) {
                return false;
            }
            this.selectedWay = (Way)osmPrimitive;
        }
        if (this.selectedWay == null) {
            return false;
        }
        this.selectedNodes = new ArrayList();
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Node)) continue;
            Node n = (Node)osmPrimitive;
            if (!this.selectedWay.containsNode(n)) {
                return false;
            }
            this.selectedNodes.add(n);
        }
        if (this.selectedNodes.size() < 1) {
            this.selectedNodes.addAll(this.selectedWay.getNodes());
        }
        return true;
    }

    private Way modifyWay(Node originalNode, Way w, List<Command> cmds, List<Node> newNodes) {
        Node newNode = new Node(originalNode, true);
        newNodes.add(newNode);
        cmds.add(new AddCommand(newNode));
        ArrayList<Node> nn = new ArrayList<Node>();
        for (Node pushNode : w.getNodes()) {
            if (originalNode == pushNode) {
                pushNode = newNode;
            }
            nn.add(pushNode);
        }
        Way newWay = new Way(w);
        newWay.setNodes(nn);
        return newWay;
    }

    private void fixRelations(Node originalNode, List<Command> cmds, List<Node> newNodes) {
        Relation newRel = null;
        HashSet<String> rolesToReAdd = null;
        for (Relation r : OsmPrimitive.getFilteredList(originalNode.getReferrers(), Relation.class)) {
            if (r.isDeleted()) continue;
            newRel = null;
            rolesToReAdd = null;
            for (RelationMember rm : r.getMembers()) {
                if (!rm.isNode() || rm.getMember() != originalNode) continue;
                if (newRel == null) {
                    newRel = new Relation(r);
                    rolesToReAdd = new HashSet<String>();
                }
                rolesToReAdd.add(rm.getRole());
            }
            if (newRel == null) continue;
            for (Node n : newNodes) {
                for (String role : rolesToReAdd) {
                    newRel.addMember(new RelationMember(role, n));
                }
            }
            cmds.add(new ChangeCommand(r, newRel));
        }
    }

    private void unglueWays() {
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Node> newNodes = new LinkedList<Node>();
        if (this.selectedWay == null) {
            boolean firstway = true;
            for (Way w : OsmPrimitive.getFilteredList(this.selectedNode.getReferrers(), Way.class)) {
                if (w.isDeleted() || w.isIncomplete()) continue;
                if (!firstway) {
                    cmds.add(new ChangeCommand(w, this.modifyWay(this.selectedNode, w, cmds, newNodes)));
                }
                firstway = false;
            }
        } else {
            cmds.add(new ChangeCommand(this.selectedWay, this.modifyWay(this.selectedNode, this.selectedWay, cmds, newNodes)));
        }
        this.fixRelations(this.selectedNode, cmds, newNodes);
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Dupe into {0} nodes", newNodes.size() + 1), cmds));
        if (this.selectedWay == null) {
            newNodes.add(this.selectedNode);
        }
        this.getCurrentDataSet().setSelected(newNodes);
    }

    private void unglueWays2() {
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Node> allNewNodes = new LinkedList<Node>();
        Way tmpWay = this.selectedWay;
        for (Node n : this.selectedNodes) {
            LinkedList<Node> newNodes = new LinkedList<Node>();
            tmpWay = this.modifyWay(n, tmpWay, cmds, newNodes);
            this.fixRelations(n, cmds, newNodes);
            allNewNodes.addAll(newNodes);
        }
        cmds.add(new ChangeCommand(this.selectedWay, tmpWay));
        Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Dupe {0} node into {1} nodes", "Dupe {0} nodes into {1} nodes", this.selectedNodes.size(), this.selectedNodes.size(), this.selectedNodes.size() + allNewNodes.size()), cmds));
        this.getCurrentDataSet().setSelected(allNewNodes);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

