/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeNodesAction
extends JosmAction {
    public MergeNodesAction() {
        super(I18n.tr("Merge Nodes"), "mergenodes", I18n.tr("Merge nodes into the oldest one."), Shortcut.registerShortcut("tools:mergenodes", I18n.tr("Tool: {0}", I18n.tr("Merge Nodes")), 77, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/MergeNodesAction"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        LinkedHashSet<Node> selectedNodes = OsmPrimitive.getFilteredSet(selection, Node.class);
        if (selectedNodes.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two nodes to merge."), I18n.tr("Warning"), 2);
            return;
        }
        Node targetNode = MergeNodesAction.selectTargetNode(selectedNodes);
        Node targetLocationNode = MergeNodesAction.selectTargetLocationNode(selectedNodes);
        Command cmd = MergeNodesAction.mergeNodes(Main.main.getEditLayer(), selectedNodes, targetNode, targetLocationNode);
        if (cmd != null) {
            Main.main.undoRedo.add(cmd);
            Main.main.getEditLayer().data.setSelected(targetNode);
        }
    }

    public static Node selectTargetLocationNode(LinkedHashSet<Node> candidates) {
        Node targetNode = null;
        Iterator i$ = candidates.iterator();
        while (i$.hasNext()) {
            Node n;
            targetNode = n = (Node)i$.next();
        }
        return targetNode;
    }

    public static Node selectTargetNode(LinkedHashSet<Node> candidates) {
        Node targetNode = null;
        Node lastNode = null;
        for (Node n : candidates) {
            if (!n.isNew()) {
                if (targetNode == null) {
                    targetNode = n;
                } else if (n.getId() < targetNode.getId()) {
                    targetNode = n;
                }
            }
            lastNode = n;
        }
        if (targetNode == null) {
            targetNode = lastNode;
        }
        return targetNode;
    }

    protected static List<Command> fixParentWays(Collection<Node> nodesToDelete, Node targetNode) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        HashSet<Way> waysToDelete = new HashSet<Way>();
        for (Way w : OsmPrimitive.getFilteredList(OsmPrimitive.getReferrer(nodesToDelete), Way.class)) {
            ArrayList<Node> newNodes = new ArrayList<Node>(w.getNodesCount());
            for (Node n : w.getNodes()) {
                if (!nodesToDelete.contains(n) && n != targetNode) {
                    newNodes.add(n);
                    continue;
                }
                if (newNodes.isEmpty()) {
                    newNodes.add(targetNode);
                    continue;
                }
                if (newNodes.get(newNodes.size() - 1) == targetNode) continue;
                newNodes.add(targetNode);
            }
            if (newNodes.size() < 2) {
                if (w.getReferrers().isEmpty()) {
                    waysToDelete.add(w);
                    continue;
                }
                HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Abort Merging"), ImageProvider.get("cancel"), I18n.tr("Click to abort merging nodes"), null)};
                HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Cannot merge nodes: Would have to delete way ''{0}'' which is still used.", w.getDisplayName(DefaultNameFormatter.getInstance())), I18n.tr("Warning"), 2, null, options, options[0], HelpUtil.ht("/Action/MergeNodes#WaysToDeleteStillInUse"));
                return null;
            }
            if (newNodes.size() < 2 && w.getReferrers().isEmpty()) {
                waysToDelete.add(w);
                continue;
            }
            cmds.add(new ChangeNodesCommand(w, newNodes));
        }
        if (!waysToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(waysToDelete));
        }
        return cmds;
    }

    public static Command mergeNodes(OsmDataLayer layer, Collection<Node> nodes, Node targetNode) {
        return MergeNodesAction.mergeNodes(layer, nodes, targetNode, targetNode);
    }

    public static Command mergeNodes(OsmDataLayer layer, Collection<Node> nodes, Node targetNode, Node targetLocationNode) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        CheckParameterUtil.ensureParameterNotNull(targetNode, "targetNode");
        if (nodes == null) {
            return null;
        }
        Set<RelationToChildReference> relationToNodeReferences = RelationToChildReference.getRelationToChildReferences(nodes);
        TagCollection nodeTags = TagCollection.unionOfAllPrimitives(nodes);
        TagConflictResolutionUtil.combineTigerTags(nodeTags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(nodeTags, nodes);
        TagCollection nodeTagsToEdit = new TagCollection(nodeTags);
        TagConflictResolutionUtil.completeTagCollectionForEditing(nodeTagsToEdit);
        CombinePrimitiveResolverDialog dialog = CombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(nodeTagsToEdit, nodeTags.getKeysWithMultipleValues());
        dialog.getRelationMemberConflictResolverModel().populate(relationToNodeReferences);
        dialog.setTargetPrimitive(targetNode);
        dialog.prepareDefaultDecisions();
        if (!nodeTags.isApplicableToPrimitive() || relationToNodeReferences.size() > 1) {
            dialog.setVisible(true);
            if (dialog.isCancelled()) {
                return null;
            }
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        HashSet<Node> nodesToDelete = new HashSet<Node>(nodes);
        nodesToDelete.remove(targetNode);
        HashSet waysToDelete = new HashSet();
        List<Command> wayFixCommands = MergeNodesAction.fixParentWays(nodesToDelete, targetNode);
        if (wayFixCommands == null) {
            return null;
        }
        cmds.addAll(wayFixCommands);
        if (targetNode != targetLocationNode) {
            Node newTargetNode = new Node(targetNode);
            newTargetNode.setCoor(targetLocationNode.getCoor());
            cmds.add(new ChangeCommand(targetNode, newTargetNode));
        }
        cmds.addAll(dialog.buildResolutionCommands());
        if (!nodesToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(nodesToDelete));
        }
        if (!waysToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(waysToDelete));
        }
        SequenceCommand cmd = new SequenceCommand(I18n.tr("Merge {0} nodes", nodes.size()), cmds);
        return cmd;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null || selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean ok = true;
        if (selection.size() < 2) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Node) continue;
            ok = false;
            break;
        }
        this.setEnabled(ok);
    }
}

