/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import sun.reflect.Reflection;

public class Access {
    private static final String[] FRIENDS = new String[]{"java.dyn.", "sun.dyn."};
    static final Access TOKEN = new Access();
    private static final ClassLoader CLASS_LOADER = Access.class.getClassLoader();

    private Access() {
    }

    public static Access getToken() {
        Class clazz = Reflection.getCallerClass(2);
        if (Access.isFriend(clazz)) {
            return TOKEN;
        }
        throw new IllegalAccessError("bad caller: " + clazz);
    }

    public static boolean isFriendName(String string) {
        for (String string2 : FRIENDS) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFriend(Class<?> clazz) {
        return Access.isFriendName(clazz.getName()) && clazz.getClassLoader() == CLASS_LOADER;
    }

    public static void check(Access access) {
        if (access == null) {
            Access.fail();
        }
        assert (access == TOKEN);
    }

    private static void fail() {
        Class clazz = Reflection.getCallerClass(3);
        throw new IllegalAccessError("bad caller: " + clazz);
    }
}

